/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.component.TexoStaticSingleton;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

public class TitleProvider
implements TexoComponent,
TexoStaticSingleton {
    private static TitleProvider instance = ComponentProvider.getInstance().newInstance(TitleProvider.class);
    private static final EDataType STRING_EDATATYPE = XMLTypePackage.eINSTANCE.getString();
    private final Map<EClass, EClassTitleProvider> titleProviders = new ConcurrentHashMap<EClass, EClassTitleProvider>();

    public static TitleProvider getInstance() {
        return instance;
    }

    public static void setInstance(TitleProvider instance) {
        TitleProvider.instance = instance;
    }

    public String getTitle(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return this.getCreateTitleProvider(eObject.eClass()).getTitle(eObject);
        }
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        return this.getCreateTitleProvider(modelObject.eClass()).getTitle(modelObject);
    }

    protected String getTitle(Object object, boolean nextStep) {
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        return this.getCreateTitleProvider(modelObject.eClass()).getTitle(modelObject, nextStep);
    }

    protected String getTitleSeparator() {
        return " - ";
    }

    protected EClassTitleProvider getCreateTitleProvider(EClass eClass) {
        EClassTitleProvider titleProvider = this.titleProviders.get(eClass);
        if (titleProvider != null) {
            return titleProvider;
        }
        String expression = ModelUtils.getEAnnotation((EModelElement)eClass, "title");
        if (expression != null) {
            ExpressionTitleProvider expressionTitleProvider = ComponentProvider.getInstance().newInstance(ExpressionTitleProvider.class);
            expressionTitleProvider.setEClass(eClass);
            expressionTitleProvider.setExpression(expression);
            titleProvider = expressionTitleProvider;
        } else {
            ArrayList<EStructuralFeature> titleEFeatures = new ArrayList<EStructuralFeature>();
            for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
                if (!ModelUtils.hasEAnnotation((EModelElement)eFeature, "title")) continue;
                titleEFeatures.add(eFeature);
            }
            if (titleEFeatures.isEmpty()) {
                for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                    if (eAttribute.getEAttributeType() != STRING_EDATATYPE && !eAttribute.getEAttributeType().isInstance((Object)" - ")) continue;
                    titleEFeatures.add((EStructuralFeature)eAttribute);
                    break;
                }
            }
            if (titleEFeatures.isEmpty() && eClass.getEAllAttributes().size() > 0) {
                titleEFeatures.add((EStructuralFeature)eClass.getEAllAttributes().get(0));
            }
            if (titleEFeatures.isEmpty() && eClass.getEAllStructuralFeatures().size() > 0) {
                titleEFeatures.add((EStructuralFeature)eClass.getEAllStructuralFeatures().get(0));
            }
            EFeatureTitleProvider eFeatureTitleProvider = new EFeatureTitleProvider();
            eFeatureTitleProvider.setEFeatures(titleEFeatures);
            titleProvider = eFeatureTitleProvider;
        }
        this.titleProviders.put(eClass, titleProvider);
        return titleProvider;
    }

    public static abstract class EClassTitleProvider {
        protected abstract String getTitle(ModelObject<?> var1, boolean var2);

        protected abstract String getTitle(EObject var1, boolean var2);

        public String getTitle(EObject modelObject) {
            return this.getTitle(modelObject, true);
        }

        public String getTitle(ModelObject<?> modelObject) {
            return this.getTitle(modelObject, true);
        }
    }

    public static class EFeatureTitleProvider
    extends EClassTitleProvider {
        private List<EStructuralFeature> eFeatures = new ArrayList<EStructuralFeature>();

        @Override
        protected String getTitle(EObject modelObject, boolean nextStep) {
            if (this.eFeatures.isEmpty()) {
                return modelObject.eClass().getName();
            }
            StringBuilder sb = new StringBuilder();
            for (EStructuralFeature eFeature : this.eFeatures) {
                Object value;
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) continue;
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                if ((value = modelObject.eGet(eFeature)) == null) continue;
                if (eFeature instanceof EAttribute) {
                    if (value instanceof Collection && (((Collection)value).isEmpty() || (value = ((Collection)value).iterator().next()) == null)) continue;
                    EDataType eDataType = ((EAttribute)eFeature).getEAttributeType();
                    sb.append(eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value));
                    continue;
                }
                if (!nextStep) continue;
                if (eFeature.isMany()) {
                    for (Object o : (Collection)value) {
                        if (!(o instanceof EObject)) continue;
                        sb.append(TitleProvider.getInstance().getTitle(o, false));
                    }
                    continue;
                }
                if (!(value instanceof EObject)) continue;
                sb.append(TitleProvider.getInstance().getTitle(value, false));
            }
            return sb.toString();
        }

        @Override
        protected String getTitle(ModelObject<?> modelObject, boolean nextStep) {
            if (this.eFeatures.isEmpty()) {
                return modelObject.eClass().getName();
            }
            StringBuilder sb = new StringBuilder();
            for (EStructuralFeature eFeature : this.eFeatures) {
                Object value;
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                if ((value = modelObject.eGet(eFeature)) == null) continue;
                if (eFeature instanceof EAttribute) {
                    EDataType eDataType = ((EAttribute)eFeature).getEAttributeType();
                    if (eFeature.isMany()) {
                        for (Object o : (Collection)value) {
                            sb.append(eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, o));
                        }
                        continue;
                    }
                    sb.append(eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value));
                    continue;
                }
                if (!nextStep) continue;
                if (eFeature.isMany()) {
                    for (Object o : (Collection)value) {
                        if (!ModelResolver.getInstance().isModelEnabled(o)) continue;
                        sb.append(TitleProvider.getInstance().getTitle(o, false));
                    }
                    continue;
                }
                if (!ModelResolver.getInstance().isModelEnabled(value)) continue;
                sb.append(TitleProvider.getInstance().getTitle(value, false));
            }
            return sb.toString();
        }

        public List<EStructuralFeature> getEFeatures() {
            return this.eFeatures;
        }

        public void setEFeatures(List<EStructuralFeature> eFeatures) {
            this.eFeatures = eFeatures;
        }
    }

    public static class ExpressionTitleProvider
    extends EClassTitleProvider
    implements TexoComponent {
        private static final String EXPRESSION_START = "${";
        private static final int EXPRESSION_START_LENGTH = "${".length();
        private static final String EXPRESSION_END = "}";
        private String expression = null;
        private List<Object> expressionList = new ArrayList<Object>();
        private EClass eClass;

        @Override
        protected String getTitle(EObject modelObject, boolean nextStep) {
            StringBuilder sb = new StringBuilder();
            for (Object element : this.expressionList) {
                if (element instanceof String) {
                    sb.append((String)element);
                    continue;
                }
                Object value = modelObject.eGet((EStructuralFeature)element);
                if (element instanceof EReference) {
                    if (!nextStep) continue;
                    sb.append(TitleProvider.getInstance().getTitle(value, false));
                    continue;
                }
                if (element instanceof EAttribute) {
                    EDataType eDataType = ((EAttribute)element).getEAttributeType();
                    sb.append(eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value));
                    continue;
                }
                throw new IllegalStateException("Type " + element.getClass().getName() + " not supported, expression " + this.expression);
            }
            return sb.toString();
        }

        @Override
        protected String getTitle(ModelObject<?> modelObject, boolean nextStep) {
            StringBuilder sb = new StringBuilder();
            for (Object element : this.expressionList) {
                if (element instanceof String) {
                    sb.append((String)element);
                    continue;
                }
                Object value = modelObject.eGet((EStructuralFeature)element);
                if (element instanceof EReference) {
                    if (!nextStep) continue;
                    sb.append(TitleProvider.getInstance().getTitle(value, false));
                    continue;
                }
                if (element instanceof EAttribute) {
                    EDataType eDataType = ((EAttribute)element).getEAttributeType();
                    sb.append(eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value));
                    continue;
                }
                throw new IllegalStateException("Type " + element.getClass().getName() + " not supported, expression " + this.expression);
            }
            return sb.toString();
        }

        public void setExpression(String expression) {
            block6: {
                int index;
                this.expression = expression;
                int previousIndex = 0;
                while ((index = expression.indexOf(EXPRESSION_START, previousIndex)) != -1) {
                    int nextIndex = expression.indexOf(EXPRESSION_END, index);
                    if (nextIndex != -1) {
                        String featureName;
                        EStructuralFeature eFeature;
                        if (index > previousIndex) {
                            this.expressionList.add(expression.substring(previousIndex, index));
                        }
                        if ((eFeature = this.eClass.getEStructuralFeature(featureName = expression.substring(index + EXPRESSION_START_LENGTH, nextIndex))) == null) {
                            this.expressionList.add("FEATURE NOT FOUND: " + featureName);
                        } else {
                            this.expressionList.add(eFeature);
                        }
                        previousIndex = nextIndex + 1;
                        continue;
                    }
                    break block6;
                }
                if (previousIndex < expression.length()) {
                    this.expressionList.add(expression.substring(previousIndex));
                }
            }
        }

        public EClass getEClass() {
            return this.eClass;
        }

        public void setEClass(EClass eClass) {
            this.eClass = eClass;
        }
    }
}

