/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.converter.EMFModelConverter;
import org.eclipse.emf.texo.converter.ModelEMFConverter;
import org.eclipse.emf.texo.store.MemoryObjectStore;
import org.eclipse.emf.texo.store.TexoEMFResourceURIConverter;

public class EMFResourceObjectStore
extends MemoryObjectStore {
    private Resource resource;
    private ResourceSet resourceSet;
    private URIConverter uriConverter = null;

    @Override
    public void begin() {
        this.resource = this.createResource();
        try {
            boolean loadFile = this.resource.getResourceSet().getURIConverter().exists(this.resource.getURI(), Collections.emptyMap());
            if (loadFile) {
                this.resource.load(this.getResourceLoadOptions());
                ArrayList<EObject> eObjects = new ArrayList<EObject>();
                TreeIterator iterator = this.resource.getAllContents();
                while (iterator.hasNext()) {
                    eObjects.add((EObject)iterator.next());
                }
                EMFModelConverter emfModelConverter = ComponentProvider.getInstance().newInstance(EMFModelConverter.class);
                List<Object> content = emfModelConverter.convert(eObjects);
                this.addData(content);
            } else {
                this.resource.getContents().clear();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Map<?, ?> getResourceLoadOptions() {
        return Collections.emptyMap();
    }

    protected Map<?, ?> getResourceSaveOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        return options;
    }

    protected Resource createResource() {
        if (this.resource != null) {
            return this.resource;
        }
        this.resourceSet = this.createResourceSet();
        return this.resourceSet.createResource(this.getUri());
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter(this.getURIConverter());
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return rs;
    }

    @Override
    public void commit() {
        try {
            this.resource.getContents().clear();
            ModelEMFConverter modelEMFConverter = ComponentProvider.getInstance().newInstance(ModelEMFConverter.class);
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            ArrayList<Object> toConvert = new ArrayList<Object>();
            for (List<Object> objs : this.getData().values()) {
                toConvert.addAll(objs);
            }
            eObjects.addAll(modelEMFConverter.convert(toConvert));
            for (EObject eObject : eObjects) {
                if (eObject.eResource() != null || eObject.eContainer() != null) continue;
                this.resource.getContents().add((Object)eObject);
            }
            this.resource.save(this.getResourceSaveOptions());
            this.resource = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void rollback() {
        this.resource.unload();
        this.resource = null;
    }

    @Override
    public void close() {
        this.resource = null;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = (URIConverter)ComponentProvider.getInstance().newInstance(TexoEMFResourceURIConverter.class);
        }
        return this.uriConverter;
    }

    public void setURIConverter(URIConverter converter) {
        this.uriConverter = converter;
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
    }
}

