/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.store.ObjectStore;
import org.eclipse.emf.texo.utils.ModelUtils;

public class MemoryObjectStore
extends ObjectStore {
    private static final String FROM = "from";
    private static final int FROM_LENGTH = "from".length();
    private final Map<EClass, List<Object>> data = new HashMap<EClass, List<Object>>();

    protected Map<EClass, List<Object>> getData() {
        return this.data;
    }

    public void addData(Collection<Object> objects) {
        for (Object object : objects) {
            ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
            EClass eClass = modelObject.eClass();
            List<Object> dataList = this.data.get(this.resolveEClass(eClass));
            if (dataList == null) {
                dataList = new ArrayList<Object>();
                this.data.put(eClass, dataList);
            }
            dataList.add(object);
        }
    }

    @Override
    public Object get(EClass eClass, Object id) {
        List<Object> dataList = this.data.get(this.resolveEClass(eClass));
        if (dataList != null) {
            for (Object o : dataList) {
                Object objectId = IdProvider.getInstance().getId(o);
                if (objectId == null || !objectId.equals(id)) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public long countNamedQuery(String name, Map<String, Object> namedParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T get(Class<T> clz, Object id) {
        for (List<Object> dataList : this.data.values()) {
            for (Object o : dataList) {
                Object objectId = IdProvider.getInstance().getId(o);
                if (!clz.isAssignableFrom(o.getClass()) || objectId == null || !objectId.equals(id)) continue;
                return (T)o;
            }
        }
        return null;
    }

    @Override
    public <T> T update(T object) {
        return object;
    }

    @Override
    public <T> void remove(T object) {
        if (object == null) {
            return;
        }
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        List<Object> dataList = this.data.get(this.resolveEClass(modelObject.eClass()));
        boolean removed = false;
        if (dataList != null) {
            removed = dataList.remove(object);
        }
        if (!removed) {
            return;
        }
        for (EReference eref : modelObject.eClass().getEAllReferences()) {
            if (!eref.isContainment()) continue;
            if (eref.isMany()) {
                Collection collection = (Collection)modelObject.eGet((EStructuralFeature)eref);
                for (Object o : collection) {
                    this.remove(o);
                }
                continue;
            }
            this.remove(modelObject.eGet((EStructuralFeature)eref));
        }
    }

    protected EClass resolveEClass(EClass eClass) {
        if (this.data.containsKey(eClass)) {
            return eClass;
        }
        for (EClass key : this.data.keySet()) {
            if (!key.getName().equals(eClass.getName()) || !key.getEPackage().getNsURI().equals(eClass.getEPackage().getNsURI())) continue;
            return key;
        }
        return eClass;
    }

    @Override
    public <T> void refresh(T object) {
    }

    @Override
    public <T> void insert(T object) {
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        List<Object> dataList = this.data.get(this.resolveEClass(modelObject.eClass()));
        if (dataList == null) {
            dataList = new ArrayList<Object>();
            this.data.put(modelObject.eClass(), dataList);
        }
        if (dataList.contains(object)) {
            return;
        }
        this.setIdAttributeOnInsert(modelObject);
        dataList.add(object);
        for (EReference eref : modelObject.eClass().getEAllReferences()) {
            if (!eref.isContainment()) continue;
            if (eref.isMany()) {
                Collection collection = (Collection)modelObject.eGet((EStructuralFeature)eref);
                for (Object o : collection) {
                    this.insert(o);
                }
                continue;
            }
            this.insert(modelObject.eGet((EStructuralFeature)eref));
        }
    }

    protected void setIdAttributeOnInsert(ModelObject<?> modelObject) {
        EAttribute idEAttribute = IdProvider.getInstance().getIdEAttribute(modelObject.eClass());
        if (modelObject.eGet((EStructuralFeature)idEAttribute) == null) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idEAttribute.getEAttributeType().getInstanceClass() == String.class) {
                modelObject.eSet((EStructuralFeature)idEAttribute, "" + System.currentTimeMillis());
            } else if (Long.class.isAssignableFrom(idEAttribute.getEAttributeType().getInstanceClass())) {
                modelObject.eSet((EStructuralFeature)idEAttribute, System.currentTimeMillis());
            } else if (Long.TYPE.isAssignableFrom(idEAttribute.getEAttributeType().getInstanceClass())) {
                modelObject.eSet((EStructuralFeature)idEAttribute, System.currentTimeMillis());
            } else if (Integer.class.isAssignableFrom(idEAttribute.getEAttributeType().getInstanceClass())) {
                modelObject.eSet((EStructuralFeature)idEAttribute, new Integer((int)System.currentTimeMillis()));
            } else if (Integer.class.isAssignableFrom(idEAttribute.getEAttributeType().getInstanceClass())) {
                modelObject.eSet((EStructuralFeature)idEAttribute, new Integer((int)System.currentTimeMillis()));
            }
        }
    }

    @Override
    public List<?> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        int index = qryStr.toLowerCase().indexOf(FROM);
        if (index != -1) {
            EClass eClass;
            String eClassName = qryStr.substring(index + FROM_LENGTH).trim();
            if (eClassName.indexOf(" ") != -1) {
                eClassName = eClassName.substring(0, eClassName.indexOf(" "));
            }
            if ((eClass = ModelUtils.getEClassFromQualifiedName(eClassName)) == null) {
                return Collections.emptyList();
            }
            return this.query(eClass, firstResult, maxResults);
        }
        return Collections.emptyList();
    }

    @Override
    public List<?> namedQuery(String name, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(String qryStr, Map<String, Object> namedParameters) {
        List<?> list = this.query(qryStr, namedParameters, 0, -1);
        return list.size();
    }

    @Override
    public List<?> query(EClass eClass, int firstResult, int maxResults) {
        List<Object> result = this.data.get(this.resolveEClass(eClass));
        if (result == null) {
            return Collections.emptyList();
        }
        int from = 0;
        if (firstResult > -1) {
            from = firstResult;
        }
        int to = result.size();
        if (maxResults > -1) {
            to = from + maxResults;
        }
        if (from >= result.size() && (from = result.size()) == 0) {
            return Collections.emptyList();
        }
        if (to > result.size()) {
            to = result.size();
        }
        return result.subList(from, to);
    }

    @Override
    public Object getDelegate() {
        return this.data;
    }

    public List<Object> getReferingObjects(Object target, int maxResult, boolean includeContainmentReferences) {
        return null;
    }

    @Override
    public EObject getEObject(URI objectUri) {
        ModelUtils.TypeIdTuple tuple;
        EObject eObject = super.getEObject(objectUri);
        if (eObject == null && (eObject = (EObject)this.get((tuple = ModelUtils.getTypeAndIdFromUri(this.isUseWebServiceUriFormat(), objectUri)).getEClass(), tuple.getId())) == null) {
            eObject = EcoreUtil.create((EClass)tuple.getEClass());
            eObject.eSet((EStructuralFeature)IdProvider.getInstance().getIdEAttribute(tuple.getEClass()), tuple.getId());
        }
        return eObject;
    }
}

