/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.texo.component.TexoComponent;

public class TexoEMFResourceURIConverter
extends ExtensibleURIConverterImpl
implements TexoComponent {
    private ResourceType resourceType = ResourceType.XMI;

    public URI normalize(URI uri) {
        if (uri.isFile()) {
            return uri;
        }
        String[] segments = uri.segments();
        String fileName = String.valueOf(segments[0]) + "_" + segments[1] + "." + this.getFileExtension();
        String dir = this.getTemporaryDirectoryPath();
        return URI.createFileURI((String)(String.valueOf(dir) + File.separator + fileName));
    }

    protected String getFileExtension() {
        switch (this.resourceType) {
            case XMI: {
                return "xmi";
            }
            case XML: {
                return "xml";
            }
        }
        throw new IllegalStateException("Resource type " + (Object)((Object)this.resourceType) + " not supported");
    }

    protected String getTemporaryDirectoryPath() {
        try {
            File f = File.createTempFile("test" + System.currentTimeMillis(), null);
            String tempDirectory = f.getParentFile().getAbsolutePath();
            f.delete();
            return tempDirectory;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public static enum ResourceType {
        XML,
        XMI;

    }
}

