/**
 * <copyright>
 *
 * Copyright (c) 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ProjectPropertyUtil.java,v 1.2 2010/03/07 19:16:00 mtaal Exp $
 */
package org.eclipse.emf.texo.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;

/**
 * Convenience method to get/set persistent properties on a project.
 * 
 * @author mtaal
 */
public class ProjectPropertyUtil {
  public static final QualifiedName GEN_OUTPUT_FOLDER_PROPERTY = new QualifiedName(
      TexoEclipsePlugin.PLUGIN_ID, "GEN_OUTPUT_FOLDER"); //$NON-NLS-1$

  public static final String GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT = "src-gen"; //$NON-NLS-1$

  /**
   * @param project
   *          the project to get the output folder for.
   * @return the output folder for the project used for generated code artifacts. Is determined on
   *         the basis of a property set ({@link #GEN_OUTPUT_FOLDER_PROPERTY}) on the project. If
   *         not set then the default {@link #GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT} is used.
   */
  public static String getGenOutputFolder(IProject project) {
    try {
      final String value = project.getPersistentProperty(GEN_OUTPUT_FOLDER_PROPERTY);
      if (value == null) {
        return GEN_OUTPUT_FOLDER_PROPERTY_DEFAULT;
      }
      return value;
    } catch (CoreException e) {
      throw new IllegalStateException(e);
    }
  }

  /**
   * Set the gen output folder for the project.
   * 
   * @param project
   *          the project to set the generated output folder for.
   * @param value
   *          the value to set.
   */
  public static void setGenOutputFolder(IProject project, String value) {
    try {
      project.setPersistentProperty(GEN_OUTPUT_FOLDER_PROPERTY, value);
    } catch (CoreException e) {
      throw new IllegalStateException(e);
    }
  }

  /**
   * @param object
   *          an instance of IProject of IJavaProject
   * @return the IProject
   */
  public static IProject getProject(Object object) {
    if (object instanceof IProject) {
      return (IProject) object;
    } else if (object instanceof IJavaProject) {
      return ((IJavaProject) object).getProject();
    } else {
      throw new IllegalArgumentException("The argument " + object + " is not a Project"); //$NON-NLS-1$ //$NON-NLS-2$
    }
  }

}