/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.generator.ModelAnnotator;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.generator.WorkFlowStarter;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelGenAnnotator;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateCode
implements IObjectActionDelegate {
    private List<IFile> modelFiles = new ArrayList<IFile>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor progressMonitor) {
                GenerateCode.this.generate(progressMonitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while generating", e);
        }
    }

    private void generate(IProgressMonitor monitor) {
        HashMap filesByProject = new HashMap();
        for (IFile modelFile : this.modelFiles) {
            IProject project = modelFile.getProject();
            if (filesByProject.get(project) == null) {
                filesByProject.put(project, new ArrayList());
            }
            ((List)filesByProject.get(project)).add(modelFile);
        }
        monitor.setTaskName(Messages.getString("generate.Artifacts"));
        for (IProject project : filesByProject.keySet()) {
            this.generate(monitor, project, (List)filesByProject.get(project));
            monitor.subTask(Messages.getString("generate.Refresh"));
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    private void generate(IProgressMonitor monitor, IProject project, List<IFile> projectModelFiles) {
        monitor.subTask(Messages.getString("generate.Reading"));
        ArrayList<URI> uris = new ArrayList<URI>();
        for (IFile modelFile : this.modelFiles) {
            uris.add(modelFile.getRawLocationURI());
        }
        List ePackages = ModelUtils.readEPackages(uris);
        ModelController modelController = new ModelController();
        modelController.addModelAnnotator((ModelAnnotator)new ModelGenAnnotator());
        modelController.setEPackages(ePackages);
        monitor.subTask(Messages.getString("generate.Annotating"));
        modelController.annotate();
        WorkFlowStarter wfs = new WorkFlowStarter();
        monitor.subTask(Messages.getString("generate.Initialize"));
        wfs.setMonitor(monitor);
        wfs.generateModelCode(project.getName(), ePackages, modelController, ProjectPropertyUtil.getGenOutputFolder(project));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator it = structuredSelection.iterator();
        this.modelFiles.clear();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IFile)) continue;
            this.modelFiles.add((IFile)obj);
        }
    }
}

