/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.properties;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.eclipse.properties.FolderSelectionDialog;
import org.eclipse.emf.texo.generator.TexoResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage {
    private static final int TEXT_FIELD_WIDTH = 50;
    private Text outputFolderText;
    private Button outputFolderButton;
    private Text templateFolderText;
    private Button templateFolderButton;
    private IProject project;

    private void setOutputFolder(IFolder outputFolder) {
        if (outputFolder == null) {
            this.outputFolderText.setText(this.project.getProjectRelativePath().append("src-gen").toPortableString());
        } else {
            this.outputFolderText.setText(outputFolder.getProjectRelativePath().toPortableString());
        }
    }

    private void setTemplateFolder(IFolder templateFolder) {
        if (templateFolder == null) {
            this.templateFolderText.setText(null);
        } else {
            this.templateFolderText.setText(templateFolder.getProjectRelativePath().toPortableString());
        }
    }

    protected Control createContents(Composite parent) {
        this.project = ProjectPropertyUtil.getProject(this.getElement());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createFields(composite);
        return composite;
    }

    private void createFields(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label outputFolderLabel = new Label(composite, 16384);
        outputFolderLabel.setText(Messages.getString("project.output.folder.label"));
        this.outputFolderText = new Text(composite, 18444);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.outputFolderText.setLayoutData((Object)gd);
        this.outputFolderText.setText(ProjectPropertyUtil.getGenOutputFolder(this.project));
        this.outputFolderButton = new Button(composite, 8);
        this.outputFolderButton.setText(Messages.getString("browse"));
        this.outputFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseOutputFolder();
            }
        });
        Label templateFolderLabel = new Label(composite, 16384);
        templateFolderLabel.setText(Messages.getString("project.template.folder.label"));
        this.templateFolderText = new Text(composite, 18444);
        GridData templateFolderGd = new GridData();
        templateFolderGd.widthHint = this.convertWidthInCharsToPixels(50);
        this.templateFolderText.setLayoutData((Object)templateFolderGd);
        try {
            this.templateFolderText.setText(this.getSafeValue(this.project.getPersistentProperty(TexoResourceManager.TEMPLATE_FOLDER_PROPERTY)));
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
        this.templateFolderButton = new Button(composite, 8);
        this.templateFolderButton.setText(Messages.getString("browse"));
        this.templateFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseTemplateFolder();
            }
        });
    }

    private void browseOutputFolder() {
        FolderSelectionDialog selectionDialog = new FolderSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.output.folder.select.title"));
        selectionDialog.setMessage(Messages.getString("project.output.folder.select.message"));
        selectionDialog.setBlockOnOpen(true);
        selectionDialog.setInput(this.project);
        selectionDialog.setInitialSelection(this.outputFolderText.getText());
        if (selectionDialog.open() == 0) {
            this.setOutputFolder((IFolder)selectionDialog.getFirstResult());
        }
    }

    private void browseTemplateFolder() {
        FolderSelectionDialog selectionDialog = new FolderSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.template.folder.select.title"));
        selectionDialog.setMessage(Messages.getString("project.template.folder.select.message"));
        selectionDialog.setBlockOnOpen(true);
        selectionDialog.setInput(this.project);
        selectionDialog.setInitialSelection(this.templateFolderText.getText());
        if (selectionDialog.open() == 0) {
            this.setTemplateFolder((IFolder)selectionDialog.getFirstResult());
        }
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.outputFolderText.setText(this.project.getProjectRelativePath().append("src-gen").toPortableString());
        this.templateFolderText.setText("");
    }

    public boolean performOk() {
        try {
            ProjectPropertyUtil.setGenOutputFolder(this.project, this.outputFolderText.getText());
            if (this.templateFolderText.getText().trim().length() == 0) {
                this.project.setPersistentProperty(TexoResourceManager.TEMPLATE_FOLDER_PROPERTY, null);
            } else {
                this.project.setPersistentProperty(TexoResourceManager.TEMPLATE_FOLDER_PROPERTY, this.templateFolderText.getText());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getSafeValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

