/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.generator.FileCleaner;
import org.eclipse.emf.texo.generator.MergingOutputHandler;
import org.eclipse.emf.texo.generator.TexoResourceManager;
import org.eclipse.xpand2.Generator;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoStrategy;
import org.eclipse.xtend.expression.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactGenerator
extends Generator {
    private String projectName;
    private List<Outlet> specificOutlets;

    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        TexoResourceManager texoResourceManager = new TexoResourceManager();
        texoResourceManager.setProjectName(this.getProjectName());
        this.setResourceManager((ResourceManager)texoResourceManager);
        FileCleaner fileCleaner = new FileCleaner();
        ArrayList<VetoStrategy> vetoStrategies = new ArrayList<VetoStrategy>();
        for (Object o : this.getBeautifier()) {
            if (o instanceof MergingOutputHandler) {
                ((MergingOutputHandler)o).setProjectName(this.getProjectName());
                ((MergingOutputHandler)o).setMonitor(monitor);
            }
            if (!(o instanceof VetoStrategy)) continue;
            vetoStrategies.add((VetoStrategy)o);
        }
        for (Outlet outlet : this.getOutlets()) {
            outlet.setPath(String.valueOf(EclipseGeneratorUtils.getProjectFilePath(this.getProjectName())) + "/" + outlet.getPath());
            outlet.vetoStrategies.add(0, fileCleaner.getNewOutputLocationTracker());
            for (VetoStrategy vs : vetoStrategies) {
                outlet.addVetoStrategy(vs);
            }
            for (PostProcessor postProcesor : outlet.postprocessors) {
                if (postProcesor instanceof MergingOutputHandler) {
                    ((MergingOutputHandler)postProcesor).setProjectName(this.getProjectName());
                    ((MergingOutputHandler)postProcesor).setMonitor(monitor);
                }
                if (!(postProcesor instanceof VetoStrategy)) continue;
                outlet.addVetoStrategy((VetoStrategy)postProcesor);
            }
        }
        try {
            super.invokeInternal2(ctx, monitor, issues);
            fileCleaner.clean();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void addAdvices(String advice) {
        this.addAdvice(advice);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<Outlet> getSpecificOutlets() {
        return this.specificOutlets;
    }

    public void setSpecificOutlets(List<Outlet> specificOutlets) {
        this.specificOutlets = specificOutlets;
        for (Outlet outlet : specificOutlets) {
            this.addOutlet(outlet);
        }
    }
}

