/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EclipseGeneratorUtils {
    public static String getSourceDirectory(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath sourcePath = javaProject.getPackageFragmentRoots()[0].getPath();
            return sourcePath.toString();
        }
        catch (JavaModelException e) {
            throw new IllegalStateException(e);
        }
    }

    public static IProject getProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new IllegalStateException("Project " + projectName + " does not exist in workspace");
        }
        return project;
    }

    public static String getProjectFilePath(String projectName) {
        IProject project = EclipseGeneratorUtils.getProject(projectName);
        if (project.getRawLocation() == null) {
            return project.getLocation().toOSString();
        }
        return project.getRawLocation().toOSString();
    }

    public static String getSourceFilePath(String target) {
        StringBuilder sb = new StringBuilder();
        int lastDot = target.lastIndexOf(".");
        if (lastDot != -1) {
            String[] stringArray = target.substring(0, lastDot).split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                sb.append("/" + segment);
                ++n2;
            }
            return String.valueOf(sb.toString()) + target.substring(lastDot);
        }
        String[] stringArray = target.substring(0, lastDot).split("\\.");
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String segment = stringArray[n3];
            sb.append("/" + segment);
            ++n3;
        }
        return sb.toString();
    }

    public static String getPathInWorkSpace(String path) {
        String wsRootPath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile().getAbsolutePath();
        if (!path.startsWith(wsRootPath)) {
            throw new IllegalArgumentException("Path is not within current workspace: " + path + " workspacepath " + wsRootPath);
        }
        return path.substring(wsRootPath.length() + 1);
    }

    public static void checkCreateWorkspacePath(String wsPath) throws CoreException {
        Path path = new Path(wsPath);
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject container = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (container == null) {
                container = workspace.getRoot().getProject(path.segment(0));
            } else {
                IFolder folder = container.getFolder((IPath)new Path(segment));
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)monitor);
                }
                container = folder;
            }
            ++n2;
        }
    }

    public static boolean exists(String wsPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wsPath)).exists();
    }

    public static String formatSource(String contents, Object codeFormatter) throws BadLocationException {
        Document doc;
        TextEdit edit;
        String localContents = contents;
        if (codeFormatter instanceof CodeFormatter && (edit = ((CodeFormatter)codeFormatter).format(8, (doc = new Document(contents)).get(), 0, doc.get().length(), 0, null)) != null) {
            edit.apply((IDocument)doc);
            localContents = doc.get();
        }
        return localContents;
    }

    public static String getEncoding(String wsPath) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wsPath));
        if (!file.exists()) {
            return null;
        }
        return file.getCharset();
    }

    public static Properties readProperties(IResource modelResource) {
        File file = EclipseGeneratorUtils.getPropertiesFile(modelResource);
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(file);
            props.load(is);
            ((InputStream)is).close();
            return props;
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException for file on path " + file.getAbsolutePath(), e);
        }
    }

    public static void saveProperties(IResource modelResource, Properties props) {
        File file = EclipseGeneratorUtils.getPropertiesFile(modelResource);
        try {
            FileOutputStream os = new FileOutputStream(file);
            props.store(os, null);
            ((OutputStream)os).close();
            modelResource.getParent().refreshLocal(2, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception for file on path " + file.getAbsolutePath(), e);
        }
    }

    public static File getPropertiesFile(IResource modelResource) {
        String ecorePath = modelResource.getLocation().toOSString();
        if (!(ecorePath.endsWith(".ecore") || ecorePath.endsWith(".xsd") || ecorePath.endsWith(".genprops"))) {
            throw new IllegalArgumentException("Path does not point to a real ecore file: " + ecorePath);
        }
        String genPropsPath = String.valueOf(ecorePath.substring(0, ecorePath.lastIndexOf("."))) + ".genprops";
        File file = new File(genPropsPath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException for file on path " + genPropsPath, e);
        }
    }

    public static IContainer getOrCreateContainer(IProject project, String javaPackageName) {
        try {
            String[] pathParts;
            ArrayList<String> pathSegments = new ArrayList<String>();
            pathSegments.add("src");
            String[] stringArray = pathParts = javaPackageName.split("\\.");
            int n = pathParts.length;
            int n2 = 0;
            while (n2 < n) {
                String pathSegment = stringArray[n2];
                pathSegments.add(pathSegment);
                ++n2;
            }
            IProject container = project;
            for (String pathSegment : pathSegments) {
                IFolder folder = container.getFolder((IPath)new Path(pathSegment));
                if (!folder.exists()) {
                    folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                container = folder;
            }
            return container;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while creating folders for: " + javaPackageName);
        }
    }

    public static URI getSibling(URI uri, String siblingSuffix) {
        try {
            String uriStr = uri.toString();
            if (uriStr.lastIndexOf(".") != -1) {
                String newUriStr = String.valueOf(uriStr.substring(0, 1 + uriStr.lastIndexOf("."))) + siblingSuffix;
                return new URI(newUriStr);
            }
            return new URI(String.valueOf(uriStr) + siblingSuffix);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while getting sibling uri " + siblingSuffix, e);
        }
    }

    public static IJavaProject getJavaProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return JavaCore.create((IProject)project);
    }

    public static class CodeGenMonitor
    extends NullProgressMonitor {
        protected PrintStream printStream;

        public CodeGenMonitor(PrintStream printStream) {
            this.printStream = printStream;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null) {
                name.length();
            }
            super.beginTask(name, totalWork);
        }

        public void setTaskName(String name) {
            if (name != null) {
                name.length();
            }
            super.setTaskName(name);
        }

        public void subTask(String name) {
            if (name != null) {
                name.length();
            }
            super.subTask(name);
        }
    }
}

