/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.Annotator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelAnnotator {
    private List<EPackage> ePackages = new ArrayList<EPackage>();
    private AnnotationManager annotationManager;

    public void annotate() {
        for (EPackage ePackage : this.ePackages) {
            EClass annotationEClass = this.getAnnotationEClass((ENamedElement)ePackage);
            if (annotationEClass != null) {
                this.annotationManager.getAnnotation((ENamedElement)ePackage, annotationEClass);
            }
            TreeIterator iterator = ePackage.eAllContents();
            while (iterator.hasNext()) {
                ENamedElement eNamedElement;
                EClass annotationEClass2;
                Object object = iterator.next();
                if (!(object instanceof ENamedElement) || (annotationEClass2 = this.getAnnotationEClass(eNamedElement = (ENamedElement)object)) == null) continue;
                this.annotationManager.getAnnotation(eNamedElement, annotationEClass2);
            }
        }
    }

    public void postAnnotate() {
        for (EPackage ePackage : this.ePackages) {
            EClass annotationEClass = this.getAnnotationEClass((ENamedElement)ePackage);
            if (annotationEClass != null) {
                Annotator<ENamedElementAnnotation> annotator = this.annotationManager.getAnnotator(annotationEClass);
                ENamedElementAnnotation annotation = this.annotationManager.getAnnotation((ENamedElement)ePackage, annotationEClass);
                if (annotator != null) {
                    annotator.postAnnotating(annotation);
                }
            }
            TreeIterator iterator = ePackage.eAllContents();
            while (iterator.hasNext()) {
                ENamedElement eNamedElement;
                EClass annotationEClass2;
                Object object = iterator.next();
                if (!(object instanceof ENamedElement) || (annotationEClass2 = this.getAnnotationEClass(eNamedElement = (ENamedElement)object)) == null) continue;
                Annotator<ENamedElementAnnotation> annotator = this.annotationManager.getAnnotator(annotationEClass2);
                ENamedElementAnnotation annotation = this.annotationManager.getAnnotation(eNamedElement, annotationEClass2);
                if (annotator == null) continue;
                annotator.postAnnotating(annotation);
            }
        }
    }

    protected abstract EClass getAnnotationEClass(ENamedElement var1);

    protected abstract List<Annotator<? extends ENamedElementAnnotation>> getAnnotators();

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }

    public List<EPackage> getEPackages() {
        return this.ePackages;
    }

    public void setEPackages(List<EPackage> ePackages) {
        this.ePackages = ePackages;
    }
}

