/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.ResourceParser;

public class TexoResourceManager
extends ResourceManagerDefaultImpl {
    public static final QualifiedName TEMPLATE_FOLDER_PROPERTY = new QualifiedName("org.eclipse.emf.texo.eclipse", "TEMPLATE_FOLDER");
    private final Map<String, Resource> resources = new HashMap<String, Resource>();
    private File templateFolder;

    public void setProjectName(String projectName) {
        try {
            IProject project = EclipseGeneratorUtils.getProject(projectName);
            String projectFilePath = EclipseGeneratorUtils.getProjectFilePath(projectName);
            File projectDirectory = new File(projectFilePath);
            String templateFolderPath = project.getPersistentProperty(TEMPLATE_FOLDER_PROPERTY);
            if (templateFolderPath != null) {
                this.templateFolder = new File(projectDirectory, templateFolderPath);
                if (!this.templateFolder.exists()) {
                    this.templateFolder = null;
                }
            } else {
                this.templateFolder = null;
            }
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public Resource loadResource(String fullyQualifiedName, String extension) {
        String resourceName = String.valueOf(fullyQualifiedName.replace("::", "/")) + "." + extension;
        if (this.resources.containsKey(resourceName)) {
            return this.resources.get(resourceName);
        }
        File resourceFile = null;
        boolean useDefaultResourceManager = this.templateFolder != null ? !(resourceFile = new File(this.templateFolder, resourceName)).exists() : true;
        if (useDefaultResourceManager) {
            Resource resource = super.loadResource(fullyQualifiedName, extension);
            this.resources.put(resourceName, resource);
            return resource;
        }
        Check.isNotNull((Object)resourceFile, (String)"Resourcefile may not be null at this point");
        try {
            FileInputStream in = new FileInputStream(resourceFile);
            Reader reader = this.createReader(in);
            ResourceParser parser = (ResourceParser)this.registeredParsers.get(extension);
            if (parser == null) {
                throw new RuntimeException("No Parser registered for extension '" + extension + "'! Known extensions are '" + this.registeredParsers.keySet() + "'");
            }
            Resource res = parser.parse(reader, resourceName);
            res.setFullyQualifiedName(fullyQualifiedName);
            this.resources.put(resourceName, res);
            return res;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception loading resource " + resourceName, e);
        }
    }
}

