/**
 * <copyright>
 *
 * Copyright (c) 2009, 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ModelEEnumAnnotator.java,v 1.6 2010/02/15 17:01:13 mtaal Exp $
 */

package org.eclipse.emf.texo.modelgenerator.annotator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;

/**
 * Responsible for setting the values in a {@link EEnumModelGenAnnotation}.
 * 
 * @author <a href="mailto:mtaal@elver.org">Martin Taal</a>
 * @version $Revision: 1.6 $
 */

public class ModelEEnumAnnotator extends ModelEDataTypeAnnotator {

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.emf.texo.generator.Annotator#getAnnotationEClass()
   */
  @Override
  public EClass getAnnotationEClass() {
    return ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation();
  }

  // the enum is not there yet, will be generated
  @Override
  protected Class<?> getInstanceClass(EDataType eDataType, String instanceClassName) {
    return null;
  }

  @Override
  protected String getInstanceClassName(EDataType eDataType) {
    return getInstanceClassNameForEnum((EEnum) eDataType);
  }
}