/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.modelgenerator.annotator.Literals;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.eclipse.xsd.ecore.NameMangler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenUtils {
    private static final HashSet<String> javaWords = new HashSet(50);

    static {
        javaWords.add("true");
        javaWords.add("false");
        javaWords.add("abstract");
        javaWords.add("continue");
        javaWords.add("for");
        javaWords.add("new");
        javaWords.add("switch");
        javaWords.add("assert");
        javaWords.add("default");
        javaWords.add("goto");
        javaWords.add("package");
        javaWords.add("synchronized");
        javaWords.add("boolean");
        javaWords.add("do");
        javaWords.add("if");
        javaWords.add("private");
        javaWords.add("this");
        javaWords.add("break");
        javaWords.add("double");
        javaWords.add("implements");
        javaWords.add("protected");
        javaWords.add("throw");
        javaWords.add("byte");
        javaWords.add("else");
        javaWords.add("import");
        javaWords.add("public");
        javaWords.add("throws");
        javaWords.add("case");
        javaWords.add("enum");
        javaWords.add("instanceof");
        javaWords.add("return");
        javaWords.add("transient");
        javaWords.add("catch");
        javaWords.add("extends");
        javaWords.add("int");
        javaWords.add("short");
        javaWords.add("try");
        javaWords.add("char");
        javaWords.add("final");
        javaWords.add("interface");
        javaWords.add("static");
        javaWords.add("void");
        javaWords.add("class");
        javaWords.add("finally");
        javaWords.add("long");
        javaWords.add("strictfp");
        javaWords.add("volatile");
        javaWords.add("const");
        javaWords.add("float");
        javaWords.add("native");
        javaWords.add("super");
        javaWords.add("while");
    }

    public static Class<?> getEDataTypeClass(EDataType eDataType) {
        Class instanceClass = eDataType.getInstanceClass();
        if (instanceClass != null && !Object.class.equals((Object)instanceClass) && !List.class.equals((Object)instanceClass)) {
            if (instanceClass.isArray()) {
                return eDataType.getInstanceClass().getComponentType();
            }
            return instanceClass;
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            return itemType.getInstanceClass();
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (memberTypes != null && memberTypes.size() > 0) {
            return ((EDataType)memberTypes.get(0)).getInstanceClass();
        }
        return Object.class;
    }

    public static String getPrimitiveObjectType(EClassifier eClassifier) {
        Class instanceClass = eClassifier.getInstanceClass();
        if (instanceClass == null) {
            return null;
        }
        if (!instanceClass.isPrimitive()) {
            if (instanceClass.isArray()) {
                return String.valueOf(instanceClass.getComponentType().getName()) + "[]";
            }
            return instanceClass.getName();
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(instanceClass)) {
            return Date.class.getName();
        }
        if (instanceClass == Boolean.TYPE) {
            return Boolean.class.getName();
        }
        if (instanceClass == Byte.TYPE) {
            return Byte.class.getName();
        }
        if (instanceClass == Character.TYPE) {
            return Character.class.getName();
        }
        if (instanceClass == Double.TYPE) {
            return Double.class.getName();
        }
        if (instanceClass == Float.TYPE) {
            return Float.class.getName();
        }
        if (instanceClass == Integer.TYPE) {
            return Integer.class.getName();
        }
        if (instanceClass == Long.TYPE) {
            return Long.class.getName();
        }
        if (instanceClass == Short.TYPE) {
            return Short.class.getName();
        }
        return null;
    }

    public static String getValidJavaMemberName(String word) {
        if (javaWords.contains(word)) {
            return String.valueOf(word) + "_";
        }
        return word;
    }

    public static String createJavaPackagePath(String nsURI) {
        return new NameMangler().qualifiedPackageName(nsURI.toLowerCase()).toLowerCase();
    }

    public static String getSiblingName(String location, String siblingSuffix) {
        if (location.lastIndexOf(".") != -1) {
            return String.valueOf(location.substring(0, location.lastIndexOf("."))) + siblingSuffix;
        }
        return String.valueOf(location) + siblingSuffix;
    }

    public static boolean isDocumentRoot(EClass eClass) {
        return ExtendedMetaData.INSTANCE.isDocumentRoot(eClass);
    }

    public static String upCaseFirst(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    public static String lowerCaseFirst(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    public static String formatIdentifier(String name) {
        return name.replaceAll(" ", "_");
    }

    public static String getStaticDefaultValue(AnnotationManager annotationManager, EDataType eDataType, String literal) {
        if (eDataType instanceof EEnum) {
            return GenUtils.getStaticDefaultValue(annotationManager, (EEnum)eDataType, literal);
        }
        if (GenUtils.isObjectTypeWithEnumBaseType(eDataType)) {
            EEnum enumDataType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType);
            return GenUtils.getStaticDefaultValue(annotationManager, enumDataType, literal);
        }
        EDataType baseType = GenUtils.getEcoreXMLDataType(eDataType);
        if (baseType != null && !GenUtils.useFactoryFor(baseType)) {
            Object value;
            if (literal == null) {
                value = baseType.getDefaultValue();
            } else {
                try {
                    value = EcoreUtil.createFromString((EDataType)baseType, (String)literal);
                }
                catch (Exception e) {
                    return "Exception: " + e.getMessage() + " literal:" + literal;
                }
            }
            if (value == null) {
                return "null";
            }
            if (baseType.getInstanceClass() == null) {
                return Literals.toLiteral(value.getClass(), value);
            }
            return Literals.toLiteral(baseType.getInstanceClass(), value);
        }
        if (literal == null) {
            return "null";
        }
        if (baseType == eDataType) {
            return GenUtils.createEcoreFactoryCall(baseType, literal);
        }
        return GenUtils.createModelFactoryCall(annotationManager, eDataType, literal);
    }

    private static String getStaticDefaultValue(AnnotationManager annotationManager, EEnum eNum, String literal) {
        EEnumLiteral enumLiteral = literal == null || literal.trim().length() == 0 ? (EEnumLiteral)eNum.getDefaultValue() : eNum.getEEnumLiteralByLiteral(literal);
        if (enumLiteral == null) {
            return "null";
        }
        EEnumModelGenAnnotation annotation = (EEnumModelGenAnnotation)annotationManager.getAnnotation((ENamedElement)eNum, ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation());
        return String.valueOf(annotation.getQualifiedClassName()) + "." + enumLiteral.getName().toUpperCase();
    }

    public static String createModelFactoryCall(AnnotationManager annotationManager, EDataType eDataType, String literalValue) {
        EPackageModelGenAnnotation annotation = GenUtils.getEPackageModelGenAnnotation(annotationManager, eDataType.getEPackage());
        String pkgClassName = annotation.getQualifiedClassName();
        StringBuilder result = new StringBuilder("(" + GenUtils.getInstanceClassName(eDataType) + ")");
        result.append(String.valueOf(pkgClassName) + "." + "MODELFACTORY");
        result.append(".createFromString(");
        result.append(String.valueOf(pkgClassName) + ".INSTANCE.get" + GenUtils.upCaseFirst(eDataType.getName()) + "EDataType()");
        result.append(", ");
        String instanceClassName = GenUtils.getInstanceClassName(eDataType);
        if (!String.class.getName().equals(instanceClassName) && literalValue != null && literalValue.length() == 0) {
            result.append("null");
        } else {
            result.append(Literals.toStringLiteral(literalValue));
        }
        result.append(')');
        return result.toString();
    }

    private static EPackageModelGenAnnotation getEPackageModelGenAnnotation(AnnotationManager annotationManager, EPackage ePackage) {
        return (EPackageModelGenAnnotation)annotationManager.getAnnotation((ENamedElement)ePackage, ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation());
    }

    public static String createEcoreFactoryCall(EDataType ecoreDataType, String literalValue) {
        StringBuilder result = new StringBuilder("(" + GenUtils.getInstanceClassName(ecoreDataType) + ")");
        if (ecoreDataType.getEPackage() instanceof EcorePackage) {
            result.append(String.valueOf(EcoreFactory.class.getName()) + ".eINSTANCE");
        } else if (ecoreDataType.getEPackage() instanceof XMLTypePackage) {
            result.append(String.valueOf(XMLTypeFactory.class.getName()) + ".eINSTANCE");
        } else {
            result.append(String.valueOf(ecoreDataType.getEPackage().getEFactoryInstance().getClass().getName()) + ".eINSTANCE");
        }
        result.append(".createFromString(");
        if (ecoreDataType.getEPackage() instanceof EcorePackage) {
            result.append(EcorePackage.class.getName());
        } else if (ecoreDataType.getEPackage() instanceof XMLTypePackage) {
            result.append(XMLTypePackage.class.getName());
        } else {
            result.append(ecoreDataType.getEPackage().getClass().getName());
        }
        result.append(".eINSTANCE.get");
        result.append(GenUtils.upCaseFirst(ecoreDataType.getName()));
        result.append("(), ");
        String instanceClassName = GenUtils.getInstanceClassName(ecoreDataType);
        if (!String.class.getName().equals(instanceClassName) && literalValue != null && literalValue.length() == 0) {
            result.append("null");
        } else {
            result.append(Literals.toStringLiteral(literalValue));
        }
        result.append(')');
        return result.toString();
    }

    public static String getObjectClassName(EDataType eDataType, String instanceClassName) {
        try {
            if (instanceClassName != null && instanceClassName.indexOf(".") != -1) {
                return instanceClassName;
            }
            return GenUtils.getPrimitiveObjectType((EClassifier)eDataType);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return "";
        }
    }

    public static String getInstanceClassName(EDataType eDataType) {
        if (GenUtils.isDateOrDateTime(eDataType)) {
            return Date.class.getName();
        }
        Check.isFalse((boolean)GenUtils.isObjectTypeWithEnumBaseType(eDataType), (String)("EDataType with base type EEnum should be handled differently, " + eDataType));
        if (eDataType.getInstanceClassName() != null) {
            return GenUtils.removeDollar(eDataType.getInstanceClassName());
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType localDataType = eDataType;
        while (localDataType != null) {
            if (GenUtils.isDateOrDateTime(localDataType)) {
                return Date.class.getName();
            }
            if (localDataType.getInstanceClassName() != null) {
                return GenUtils.removeDollar(localDataType.getInstanceClassName());
            }
            localDataType = extendedMetaData.getBaseType(localDataType);
        }
        return GenUtils.removeDollar(eDataType.getInstanceClassName());
    }

    public static boolean isObjectTypeWithEnumBaseType(EDataType eDataType) {
        return ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType) != null;
    }

    public static boolean isDateOrDateTime(EDataType eDataType) {
        if (eDataType == XMLTypePackage.eINSTANCE.getDate() || eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
            return true;
        }
        if (eDataType.getInstanceClass() != null && XMLGregorianCalendar.class.isAssignableFrom(eDataType.getInstanceClass())) {
            return true;
        }
        if (XMLGregorianCalendar.class.getName().equals(eDataType.getInstanceClassName())) {
            return true;
        }
        return eDataType.getInstanceClass() != null && Date.class.isAssignableFrom(eDataType.getInstanceClass());
    }

    public static EDataType getEcoreXMLDataType(EDataType eDataType) {
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType ecoreDataType = eDataType;
        while (ecoreDataType != null) {
            String namespace = extendedMetaData.getNamespace((EClassifier)ecoreDataType);
            if ("http://www.eclipse.org/emf/2002/Ecore".equals(namespace) || "http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
                return ecoreDataType;
            }
            ecoreDataType = extendedMetaData.getBaseType(ecoreDataType);
        }
        String instanceClassName = eDataType.getInstanceClassName();
        for (EClassifier eClassifier : EcorePackage.eINSTANCE.getEClassifiers()) {
            EDataType ecoreDataType2;
            if (!(eClassifier instanceof EDataType) || !eClassifier.getInstanceClassName().equals(instanceClassName) || !(ecoreDataType2 = (EDataType)eClassifier).isSerializable()) continue;
            return ecoreDataType2;
        }
        return null;
    }

    public static boolean useFactoryFor(EDataType ecoreDataType) {
        String nsURI = ecoreDataType.getEPackage().getNsURI();
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(nsURI)) {
            String name = ecoreDataType.getName();
            return "Date".equals(name) || "DateTime".equals(name) || "Duration".equals(name) || "GDay".equals(name) || "GMonth".equals(name) || "GMonthDay".equals(name) || "GYear".equals(name) || "GYearMonth".equals(name) || "NOTATION".equals(name) || "QName".equals(name) || "Time".equals(name) || "ENTITIES".equals(name) || "ENTITIESBASE".equals(name) || "IDREFS".equals(name) || "IDREFSBase".equals(name) || "NMTOKENS".equals(name) || "NMTOKENSBase".equals(name);
        }
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(nsURI)) {
            if ("EDate".equals(ecoreDataType.getName())) {
                return true;
            }
            if ("EJavaObject".equals(ecoreDataType.getName())) {
                ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
                EDataType base = ecoreDataType;
                while (base != null) {
                    if (!extendedMetaData.getMemberTypes(base).isEmpty()) {
                        return true;
                    }
                    base = extendedMetaData.getBaseType(base);
                }
            }
            return false;
        }
        return true;
    }

    public static Class<?> getClassForName(EDataType eDataType, String name) {
        if (!name.contains(".")) {
            return GenUtils.getPrimitiveClass(name);
        }
        try {
            EPackage p = eDataType.getEPackage();
            return p != null ? Class.forName(name, true, p.getClass().getClassLoader()) : Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> getPrimitiveClass(String className) {
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        return null;
    }

    public static String removeDollar(String className) {
        if (!className.contains("$")) {
            return className;
        }
        return className.replaceAll("\\$", ".");
    }
}

