/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.annotations.annotationsmodel.EStructuralFeatureAnnotation;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEClassifierAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEClassAnnotator
extends ModelEClassifierAnnotator
implements Annotator<EClassModelGenAnnotation> {
    private static final String SERIALIZABLE_NAME = Serializable.class.getName();

    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation();
    }

    public void setAnnotationFeatures(EClassModelGenAnnotation annotation) {
        Check.isNotNull((Object)annotation.getEClass(), (String)"eClass must be set");
        EClass eClass = annotation.getEClass();
        super.annotate(annotation);
        if (annotation.getClassImplements().isEmpty()) {
            annotation.getClassImplements().addAll(this.getClassImplements(eClass));
        }
        List<String> classExtends = this.getClassExtends(eClass);
        if (annotation.getClassExtends().isEmpty()) {
            annotation.getClassExtends().addAll(classExtends);
        }
        if (annotation.getQualifiedClassName() == null && !ModelUtils.isEMap((EClass)eClass)) {
            annotation.setQualifiedClassName(this.getQualifiedClassName((EClassifier)eClass));
        }
        if (annotation.getSimpleClassName() == null) {
            annotation.setSimpleClassName(this.getSimpleClassName((EClassifier)eClass));
        }
        if (!annotation.isSetAbstract()) {
            annotation.setAbstract(eClass.isAbstract());
        }
        if (!annotation.isSetHasSuperEClass()) {
            EClass superEClass = this.getSuperClassEClass(eClass);
            annotation.setHasSuperEClass(superEClass != null);
            if (superEClass != null) {
                annotation.setSuperEClass(this.getEClassModelGenAnnotation(superEClass));
            }
        }
        if (!annotation.isSetHasSuperEClass()) {
            annotation.setHasSuperEClass(classExtends.size() > 0);
        }
        if (!annotation.isSetSerializable()) {
            annotation.setSerializable(this.isJavaSerializable(eClass));
        }
        if (!annotation.isSetGenerateCode()) {
            boolean doGenerateCode = !ModelUtils.isEMap((EClass)eClass);
            annotation.setGenerateCode(doGenerateCode);
        }
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eClass.getEPackage());
        annotation.setOwnerEPackageAnnotation(ePackageAnnotation);
        if (!annotation.isSetHasManyFeatures()) {
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            if (annotation.getEStructuralFeatureAnnotations().isEmpty()) {
                for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                    features.add(eStructuralFeature);
                }
                for (EStructuralFeature eStructuralFeature : this.getAllInterfaceFeatures(eClass)) {
                    features.add(eStructuralFeature);
                }
            } else {
                for (EStructuralFeatureAnnotation featureAnnotation : annotation.getEStructuralFeatureAnnotations()) {
                    features.add(featureAnnotation.getEStructuralFeature());
                }
            }
            for (EStructuralFeature feature : features) {
                if (feature.isVolatile() || !feature.isMany()) continue;
                annotation.setHasManyFeatures(true);
                break;
            }
        }
    }

    public void postAnnotating(EClassModelGenAnnotation annotation) {
        EClass eClass = annotation.getEClass();
        if (annotation.getEStructuralFeatureAnnotations().isEmpty()) {
            for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                annotation.getEStructuralFeatureAnnotations().add((Object)this.getEStructuralFeatureModelGenAnnotation(eStructuralFeature));
            }
            for (EStructuralFeature eStructuralFeature : this.getAllInterfaceFeatures(eClass)) {
                annotation.getEStructuralFeatureAnnotations().add((Object)this.getEStructuralFeatureModelGenAnnotation(eStructuralFeature));
            }
            for (EStructuralFeatureAnnotation featureAnnotation : annotation.getEStructuralFeatureAnnotations()) {
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)featureAnnotation.getEStructuralFeature())) continue;
                annotation.getFeatureMapFeatures().add((Object)((EStructuralFeatureModelGenAnnotation)featureAnnotation));
            }
        }
    }

    private List<EStructuralFeature> getAllInterfaceFeatures(EClass eLocalClass) {
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
        for (EClass superEClass : eLocalClass.getESuperTypes()) {
            if (!superEClass.isInterface()) continue;
            list.addAll((Collection<EStructuralFeature>)superEClass.getEStructuralFeatures());
            list.addAll(this.getAllInterfaceFeatures(superEClass));
        }
        return list;
    }

    private List<String> getClassExtends(EClass eClass) {
        ArrayList<String> result = new ArrayList<String>();
        if (eClass.isInterface()) {
            for (EClass superEClass : eClass.getESuperTypes()) {
                EClassModelGenAnnotation annotation = this.getEClassModelGenAnnotation(superEClass);
                result.add(annotation.getQualifiedClassName());
            }
            return result;
        }
        EClass superEClass = this.getSuperClassEClass(eClass);
        if (superEClass == null) {
            return result;
        }
        EClassModelGenAnnotation annotation = this.getEClassModelGenAnnotation(superEClass);
        result.add(annotation.getQualifiedClassName());
        return result;
    }

    private List<String> getClassImplements(EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (EClass superEClass : superTypes) {
            if (!superEClass.isInterface()) continue;
            EClassModelGenAnnotation annotation = this.getEClassModelGenAnnotation(superEClass);
            interfaces.add(annotation.getQualifiedClassName());
        }
        return interfaces;
    }

    private EClass getSuperClassEClass(EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        if (superTypes.isEmpty()) {
            return null;
        }
        for (EClass superEClass : superTypes) {
            if (superEClass.isInterface()) continue;
            return superEClass;
        }
        return null;
    }

    private boolean isJavaSerializable(EClass eClass) {
        for (String interf : this.getClassImplements(eClass)) {
            if (interf.compareTo(SERIALIZABLE_NAME) != 0) continue;
            return true;
        }
        for (EClass superEClass : eClass.getEAllSuperTypes()) {
            EClassModelGenAnnotation annotation = this.getEClassModelGenAnnotation(superEClass);
            if (!annotation.isSerializable()) continue;
            return true;
        }
        return false;
    }
}

