/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEClassifierAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEDataTypeAnnotator
extends ModelEClassifierAnnotator
implements Annotator<EDataTypeModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation();
    }

    public void setAnnotationFeatures(EDataTypeModelGenAnnotation annotation) {
        EEnum eEnumBaseType;
        boolean isTypeWithEnumBaseType;
        super.annotate(annotation);
        Check.isNotNull((Object)annotation.getEDataType(), (String)"eDataType must be set");
        EDataType eDataType = annotation.getEDataType();
        if (!annotation.isSetEnum()) {
            annotation.setEnum(eDataType instanceof EEnum);
        }
        boolean bl = isTypeWithEnumBaseType = (eEnumBaseType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType)) != null;
        String instanceClassName = annotation.getInstanceClassName() != null ? annotation.getInstanceClassName() : (isTypeWithEnumBaseType ? this.getInstanceClassNameForEnum(eEnumBaseType) : this.getInstanceClassName(eDataType));
        Class<?> instanceClass = this.getInstanceClass(eDataType, instanceClassName);
        if (!annotation.isSetDateType()) {
            if (isTypeWithEnumBaseType) {
                annotation.setDateType(false);
            } else if (GenUtils.isDateOrDateTime(eDataType)) {
                annotation.setDateType(true);
            } else {
                annotation.setDateType(false);
            }
        }
        EDataType itemDataType = ExtendedMetaData.INSTANCE.getItemType(annotation.getEDataType());
        EDataType baseType = annotation.getEDataType();
        while (itemDataType == null && (baseType = ExtendedMetaData.INSTANCE.getBaseType(baseType)) != null) {
            itemDataType = ExtendedMetaData.INSTANCE.getItemType(baseType);
        }
        if (itemDataType != null) {
            EDataTypeModelGenAnnotation itemDataTypeAnnotation = this.getEDataTypeModelGenAnnotation(itemDataType);
            annotation.setItemType(itemDataTypeAnnotation.getInstanceClassName());
        } else {
            annotation.setItemType(Object.class.getName());
        }
        if (annotation.getObjectClassName() == null) {
            if (isTypeWithEnumBaseType) {
                annotation.setObjectClassName(instanceClassName);
            } else if (instanceClass != null && instanceClass.isArray()) {
                annotation.setObjectClassName(instanceClass.getComponentType() + "[]");
            } else if (instanceClass != null && instanceClass.getTypeParameters().length > 0 && annotation.getItemType() != null) {
                annotation.setObjectClassName(String.valueOf(instanceClass.getName()) + "<" + annotation.getItemType() + ">");
            } else {
                annotation.setObjectClassName(GenUtils.getObjectClassName(eDataType, instanceClassName));
            }
        }
        if (annotation.getQualifiedClassName() == null) {
            annotation.setQualifiedClassName(instanceClassName);
        }
        if (annotation.getInstanceClassName() == null) {
            annotation.setInstanceClassName(instanceClassName);
        }
        if (annotation.getSimpleClassName() == null) {
            annotation.setSimpleClassName(this.getSimpleClassName((EClassifier)eDataType));
        }
        if (!annotation.isSetGenerateCode()) {
            annotation.setGenerateCode(true);
        }
        if (!annotation.isSetAutomaticStringConversion()) {
            if (isTypeWithEnumBaseType) {
                annotation.setAutomaticStringConversion(false);
            } else {
                annotation.setAutomaticStringConversion(this.hasInstanceClassStringConstructor(instanceClass));
            }
        }
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eDataType.getEPackage());
        annotation.setOwnerEPackageAnnotation(ePackageAnnotation);
        if (isTypeWithEnumBaseType) {
            EDataTypeModelGenAnnotation baseTypeAnnotation = this.getEDataTypeModelGenAnnotation((EDataType)eEnumBaseType);
            annotation.setBaseTypeAnnotation(baseTypeAnnotation);
        }
    }

    public void postAnnotating(EDataTypeModelGenAnnotation annotation) {
    }

    protected Class<?> getInstanceClass(EDataType eDataType, String instanceClassName) {
        GenUtils.isObjectTypeWithEnumBaseType(eDataType);
        return GenUtils.getClassForName(eDataType, instanceClassName);
    }

    protected String getInstanceClassName(EDataType eDataType) {
        return GenUtils.getInstanceClassName(eDataType);
    }

    private boolean hasInstanceClassStringConstructor(Class<?> instanceClass) {
        if (instanceClass == null) {
            return false;
        }
        try {
            instanceClass.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected String getInstanceClassNameForEnum(EEnum eEnum) {
        EPackageModelGenAnnotation annotation = this.getEPackageModelGenAnnotation(eEnum.getEPackage());
        String qualifiedClassName = String.valueOf(annotation.getPackagePath().toLowerCase()) + "." + this.getSimpleClassName((EClassifier)eEnum);
        return qualifiedClassName;
    }
}

