/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelENamedElementAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

public abstract class ModelEStructuralFeatureAnnotator
extends ModelENamedElementAnnotator {
    protected void annotate(EStructuralFeatureModelGenAnnotation annotation) {
        super.annotate(annotation);
        EStructuralFeature eFeature = annotation.getEStructuralFeature();
        if (annotation.getValidJavaMemberName() == null) {
            annotation.setValidJavaMemberName(this.getValidJavaMemberName(eFeature));
        }
        if (!annotation.isSetUseList()) {
            if (!this.isMany(eFeature)) {
                annotation.setUseList(false);
            } else {
                annotation.setUseList(eFeature.isOrdered());
            }
        }
        if (annotation.getDefaultValue() == null) {
            annotation.setDefaultValue(this.getDefaultValue(eFeature));
        }
        if (annotation.getGetter() == null) {
            annotation.setGetter(this.getGetter(eFeature));
        }
        if (annotation.getSetter() == null) {
            annotation.setSetter(this.getSetter(eFeature));
        }
        if (annotation.getType() == null) {
            annotation.setType(this.getType(eFeature));
        }
        if (!annotation.isSetItemType()) {
            annotation.setItemType(this.getItemType(eFeature));
        }
        if (!annotation.isSetMany()) {
            annotation.setMany(this.isMany(eFeature));
        }
        if (annotation.getObjectType() == null) {
            annotation.setObjectType(this.getObjectType(eFeature));
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
            if (annotation.getFeatureMapQualifiedClassName() == null) {
                annotation.setFeatureMapQualifiedClassName(this.getFeatureMapQualifiedClassName(eFeature));
            }
            if (annotation.getFeatureMapSimpleClassName() == null) {
                annotation.setFeatureMapSimpleClassName(this.getFeatureMapSimpleClassName(eFeature));
            }
        }
        EClassModelGenAnnotation eClassAnnotation = this.getEClassModelGenAnnotation(annotation.getEStructuralFeature().getEContainingClass());
        annotation.setOwnerEClassAnnotation(eClassAnnotation);
    }

    protected abstract String getItemType(EStructuralFeature var1);

    protected String getInstanceClassName(EStructuralFeature eFeature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
            return this.getFeatureMapQualifiedClassName(eFeature);
        }
        return this.getEDataTypeModelGenAnnotation(((EAttribute)eFeature).getEAttributeType()).getInstanceClassName();
    }

    protected boolean isMany(EStructuralFeature eFeature) {
        return eFeature.isMany();
    }

    protected String getValidJavaMemberName(EStructuralFeature eStructuralFeature) {
        return GenUtils.getValidJavaMemberName(this.getName((ENamedElement)eStructuralFeature));
    }

    protected String getGetter(EStructuralFeature eStructuralFeature) {
        return "get" + GenUtils.upCaseFirst(this.getName((ENamedElement)eStructuralFeature));
    }

    protected String getSetter(EStructuralFeature eStructuralFeature) {
        return "set" + GenUtils.upCaseFirst(this.getName((ENamedElement)eStructuralFeature));
    }

    protected String getName(ENamedElement eNamedElement) {
        boolean partOfMix;
        EStructuralFeature eStructuralFeature = (EStructuralFeature)eNamedElement;
        String defaultName = super.getName((ENamedElement)eStructuralFeature);
        boolean partOfFeatureMap = ExtendedMetaData.INSTANCE.getGroup(eStructuralFeature) != null;
        boolean bl = partOfMix = ModelUtils.getMixedEStructuralFeature((EClass)eStructuralFeature.getEContainingClass()) != null;
        if (!partOfFeatureMap && !partOfMix) {
            return defaultName;
        }
        if (partOfMix && (defaultName.compareToIgnoreCase("comment") == 0 || defaultName.compareToIgnoreCase("text") == 0 || defaultName.compareToIgnoreCase("cdata") == 0)) {
            return String.valueOf(defaultName) + "_";
        }
        if (defaultName.compareToIgnoreCase("value") == 0 || defaultName.compareToIgnoreCase("feature") == 0) {
            return String.valueOf(defaultName) + "_";
        }
        return defaultName;
    }

    protected abstract String getType(EStructuralFeature var1);

    protected String getObjectType(EStructuralFeature eStructuralFeature) {
        return this.getType(eStructuralFeature);
    }

    protected abstract String getDefaultValue(EStructuralFeature var1);

    protected String getFeatureMapQualifiedClassName(EStructuralFeature eStructuralFeature) {
        Check.isTrue((boolean)FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature), (String)("The eStructuralFeature " + eStructuralFeature + " is not a feature map"));
        String qualifiedClassName = String.valueOf(this.getFeatureMapPackageName(eStructuralFeature)) + "." + this.getFeatureMapSimpleClassName(eStructuralFeature);
        return qualifiedClassName;
    }

    protected String getFeatureMapPackageName(EStructuralFeature eFeature) {
        return this.getEPackageModelGenAnnotation(eFeature.getEContainingClass().getEPackage()).getPackagePath().toLowerCase();
    }

    protected String getFeatureMapSimpleClassName(EStructuralFeature eStructuralFeature) {
        Check.isTrue((boolean)FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature), (String)("The eStructuralFeature " + eStructuralFeature + " is not a feature map"));
        EClassModelGenAnnotation eClassAnnotation = this.getEClassModelGenAnnotation(eStructuralFeature.getEContainingClass());
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eStructuralFeature.getEContainingClass().getEPackage());
        return String.valueOf(GenUtils.upCaseFirst(eClassAnnotation.getName())) + GenUtils.upCaseFirst(this.getName((ENamedElement)eStructuralFeature)) + ePackageAnnotation.getFeatureGroupClassNamePostFix();
    }

    protected void postAnnotating(EStructuralFeatureModelGenAnnotation annotation) {
        EStructuralFeature mixedFeature;
        EStructuralFeature eFeature = annotation.getEStructuralFeature();
        EStructuralFeature groupFeature = ExtendedMetaData.INSTANCE.getGroup(eFeature);
        if (groupFeature != null) {
            EStructuralFeatureModelGenAnnotation groupAnnotation = this.getEStructuralFeatureModelGenAnnotation(groupFeature);
            groupAnnotation.getMemberFeatureMapFeatures().add((Object)annotation);
        } else if (!ModelUtils.isAttribute((EStructuralFeature)eFeature) && (mixedFeature = ModelUtils.getMixedEStructuralFeature((EClass)eFeature.getEContainingClass())) != null && mixedFeature != eFeature) {
            EStructuralFeatureModelGenAnnotation mixedAnnotation = this.getEStructuralFeatureModelGenAnnotation(mixedFeature);
            mixedAnnotation.getMemberFeatureMapFeatures().add((Object)annotation);
        }
    }
}

