/**
 * <copyright>
 *
 * Copyright (c) 2009, 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ModelXMLResourceImpl.java,v 1.5 2010/01/31 20:39:22 mtaal Exp $
 */

package org.eclipse.emf.texo.xml;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.texo.model.ModelFactory;
import org.eclipse.emf.texo.utils.Check;

/**
 * Overrides the standard {@link XMLResourceImpl} to use another {@link XMLHelperImpl} instance.
 * This redirects EMF to use the generated {@link ModelFactory} to convert data types.
 * 
 * @author <a href="mtaal@elver.org">Martin Taal</a>
 */
public class ModelXMLResourceImpl extends XMLResourceImpl {

  public ModelXMLResourceImpl() {
    super(URI.createURI("model.xmi")); //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl#createXMLHelper()
   */
  @Override
  protected XMLHelper createXMLHelper() {
    return new ModelXMLHelperImpl(this);
  }

  /**
   * Overridden to automatically create a resource set is one is not available. Note it is necessary
   * to put the resources in a resourceset cause EMF uses the resourceset to compute id's etc.
   * 
   * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#getResourceSet()
   */
  @Override
  public ResourceSet getResourceSet() {
    final ResourceSet superResourceSet = super.getResourceSet();
    if (superResourceSet == null) {
      final ResourceSet localResourceSet = new ResourceSetImpl();
      localResourceSet.getResources().add(this);
      Check.isNotNull(super.getResourceSet(), "Resource set not set for " //$NON-NLS-1$
          + this);
    }
    return super.getResourceSet();
  }

}