/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.ElementHandlerImpl;
import org.eclipse.emf.texo.xml.ModelEMFConverter;
import org.eclipse.emf.texo.xml.ModelXMIResourceImpl;
import org.eclipse.emf.texo.xml.ModelXMLResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelXMLSaver {
    private Writer writer;
    private XMLResource xmlResource;
    private Map<String, Object> options = new HashMap<String, Object>();
    private List<Object> objects;
    private ModelEMFConverter modelEMFConverter = new ModelEMFConverter();
    private boolean saveAsXMI = false;

    public void write() {
        try {
            XMLResource localXMLResource = this.getXmlResource();
            List<EObject> eObjects = this.getModelEMFConverter().convert(this.getObjects());
            this.addObjectsToRoot(eObjects);
            localXMLResource.getContents().addAll(eObjects);
            this.setDefaultOptions("ENCODING", "UTF-8");
            this.setDefaultOptions("EXTENDED_META_DATA", true);
            this.setDefaultOptions("SCHEMA_LOCATION", true);
            this.setDefaultOptions("USE_ENCODED_ATTRIBUTE_STYLE", true);
            this.setDefaultOptions("KEEP_DEFAULT_CONTENT", true);
            this.setDefaultOptions("ELEMENT_HANDLER", new ElementHandlerImpl(false));
            localXMLResource.save(this.writer, this.getOptions());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addObjectsToRoot(List<EObject> rootObjects) {
        HashMap<EObject, EObject> visited = new HashMap<EObject, EObject>();
        for (EObject eObject : new ArrayList<EObject>(rootObjects)) {
            this.visit(eObject, visited, rootObjects);
        }
    }

    private void visit(EObject eObject, HashMap<EObject, EObject> visited, List<EObject> rootObjects) {
        if (visited.containsKey(eObject)) {
            return;
        }
        visited.put(eObject, eObject);
        if (eObject.eIsProxy()) {
            return;
        }
        if (eObject.eContainer() == null && !rootObjects.contains(eObject)) {
            rootObjects.add(eObject);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)eReference);
                for (EObject refEObject : list) {
                    this.visit(refEObject, visited, rootObjects);
                }
                continue;
            }
            EObject refEObject = (EObject)eObject.eGet((EStructuralFeature)eReference);
            if (refEObject == null) continue;
            this.visit(refEObject, visited, rootObjects);
        }
    }

    private EObject getDocumentRoot(EObject eObject, EClass eClass) {
        Iterator iterator;
        EPackage ePackage = eClass.getEPackage();
        EClass docRootEClass = ExtendedMetaData.INSTANCE.getDocumentRoot(ePackage);
        if (docRootEClass != null) {
            iterator = docRootEClass.getEAllReferences().iterator();
            while (iterator.hasNext()) {
                EReference eRef = (EReference)iterator.next();
                if (!eRef.getEReferenceType().isInstance((Object)eObject)) continue;
                EObject docRoot = EcoreUtil.create((EClass)docRootEClass);
                if (eRef.isMany()) {
                    ((List)docRoot.eGet((EStructuralFeature)eRef)).add(eObject);
                } else {
                    docRoot.eSet((EStructuralFeature)eRef, (Object)eObject);
                }
                return docRoot;
            }
        }
        if ((iterator = eClass.getESuperTypes().iterator()).hasNext()) {
            EClass eSuperClass = (EClass)iterator.next();
            return this.getDocumentRoot(eObject, eSuperClass);
        }
        return null;
    }

    protected void setDefaultOptions(String option, Object value) {
        if (this.getOptions().get(option) != null) {
            return;
        }
        this.getOptions().put(option, value);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public XMLResource getXmlResource() {
        if (this.xmlResource == null) {
            this.xmlResource = this.saveAsXMI ? new ModelXMIResourceImpl() : new ModelXMLResourceImpl();
        }
        return this.xmlResource;
    }

    public void setXmlResource(XMLResource xmlResource) {
        this.xmlResource = xmlResource;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    public ModelEMFConverter getModelEMFConverter() {
        return this.modelEMFConverter;
    }

    public void setModelEMFConverter(ModelEMFConverter modelEMFConverter) {
        this.modelEMFConverter = modelEMFConverter;
    }

    public boolean isSaveAsXMI() {
        return this.saveAsXMI;
    }

    public void setSaveAsXMI(boolean saveAsXMI) {
        this.saveAsXMI = saveAsXMI;
    }
}

