/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicModelObject
implements ModelObject<DynamicModelObject> {
    private EClass eClass;
    private List<Object> values = new ArrayList<Object>();

    @Override
    public ModelPackage getModelPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTarget(DynamicModelObject target) {
    }

    @Override
    public DynamicModelObject getTarget() {
        return this;
    }

    @Override
    public EClass eClass() {
        return this.eClass;
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    public Object eGet(EStructuralFeature eStructuralFeature) {
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        Object value = this.values.get(featureId);
        if (eStructuralFeature.isMany() && value == null) {
            ArrayList newValue = new ArrayList();
            this.eSet(eStructuralFeature, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public void eSet(EStructuralFeature eStructuralFeature, Object value) {
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        this.values.set(featureId, value);
    }

    private synchronized void checkIncreaseValues(int featureId) {
        int increaseBy = featureId - this.values.size() + 1;
        int i = 0;
        while (i < increaseBy) {
            this.values.add(null);
            ++i;
        }
    }
}

