/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.model.ModelFactory;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.utils.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResolver {
    private static ModelResolver instance = new ModelResolver();
    private static ThreadLocal<ModelResolver> threadInstance = new ThreadLocal();
    private final Map<Class<?>, ModelDescriptor> classToModelMapping = new ConcurrentHashMap();
    private final Map<String, ModelPackage> nsuriToModelPackages = new ConcurrentHashMap<String, ModelPackage>();

    public static ModelResolver getInstance() {
        if (threadInstance.get() != null) {
            return threadInstance.get();
        }
        return instance;
    }

    public static void setInstance(ModelResolver instance) {
        ModelResolver.instance = instance;
    }

    public static void setThreadInstance(ModelResolver instance) {
        threadInstance.set(instance);
    }

    public void registerModelPackage(ModelPackage modelPackage) {
        Check.isNull(this.nsuriToModelPackages.get(modelPackage.getNsURI()), "The EcoreModelPackage with NsUri " + modelPackage.getNsURI() + " has already been registered!");
        this.nsuriToModelPackages.put(modelPackage.getNsURI(), modelPackage);
    }

    public ModelPackage getModelPackage(String nsURI) {
        return this.nsuriToModelPackages.get(nsURI);
    }

    public String convertToString(EDataType eDataType, Object value) {
        ModelPackage modelPackage = this.getModelPackage(eDataType.getEPackage().getNsURI());
        if (modelPackage != null) {
            return modelPackage.getModelFactory().convertToString(eDataType, value);
        }
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
    }

    public Object createFromString(EDataType eDataType, String strValue) {
        ModelPackage modelPackage = this.getModelPackage(eDataType.getEPackage().getNsURI());
        if (modelPackage != null) {
            return modelPackage.getModelFactory().createFromString(eDataType, strValue);
        }
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, strValue);
    }

    public void registerClassModelMapping(Class<?> clazz, EClassifier eClassifier, ModelPackage modelPackage) {
        Check.isFalse(this.classToModelMapping.containsKey(clazz), "The class " + clazz + " already has a model descriptor " + this.classToModelMapping.get(clazz));
        ModelDescriptor modelDescriptor = new ModelDescriptor();
        modelDescriptor.setEClassifier(eClassifier);
        modelDescriptor.setModelPackage(modelPackage);
        this.classToModelMapping.put(clazz, modelDescriptor);
    }

    public boolean isModelEnabled(Object target) {
        if (target == null) {
            return false;
        }
        return this.getModelDescriptor(target.getClass(), false) != null;
    }

    public ModelObject<?> getModelObject(Object target) {
        Check.isNotNullArgument(target, "target");
        if (target instanceof ModelObject) {
            return (ModelObject)target;
        }
        ModelDescriptor modelDescriptor = this.getModelDescriptor(target.getClass(), true);
        return modelDescriptor.createAdapter(target);
    }

    public ModelFeatureMapEntry<?> getModelFeatureMapEntry(EStructuralFeature eFeature, Object adaptee) {
        String nsuri = eFeature.getEContainingClass().getEPackage().getNsURI();
        ModelPackage modelPackage = this.getModelPackage(nsuri);
        Check.isNotNull(modelPackage, "No modelpackage found for EPackage nsuri: " + nsuri);
        return modelPackage.getModelFactory().createModelFeatureMapEntry(eFeature, adaptee);
    }

    public Object createFeatureMapEntry(EStructuralFeature eFeature) {
        String nsuri = eFeature.getEContainingClass().getEPackage().getNsURI();
        ModelPackage modelPackage = this.getModelPackage(nsuri);
        Check.isNotNull(modelPackage, "No modelpackage found for EPackage nsuri: " + nsuri);
        return modelPackage.getModelFactory().createFeatureMapEntry(eFeature);
    }

    protected ModelDescriptor getModelDescriptor(Class<?> clazz, boolean exceptionOnNotFound) {
        ModelDescriptor modelDescriptor = this.classToModelMapping.get(clazz);
        Check.isNotNull(modelDescriptor, "The class " + clazz + " is not managed by this ModelResolver");
        if (modelDescriptor != null) {
            return modelDescriptor;
        }
        modelDescriptor = this.findModelDescriptorSuperClasses(clazz.getSuperclass());
        if (modelDescriptor == null) {
            modelDescriptor = this.findModelDescriptorInterfaces(clazz);
        }
        if (modelDescriptor != null) {
            this.classToModelMapping.put(clazz, modelDescriptor);
            return modelDescriptor;
        }
        if (exceptionOnNotFound) {
            throw new IllegalArgumentException("The class " + clazz + " is not managed by this ModelResolver");
        }
        return null;
    }

    protected ModelDescriptor findModelDescriptorSuperClasses(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ModelDescriptor modelDescriptor = this.classToModelMapping.get(clazz);
        if (modelDescriptor == null) {
            return this.findModelDescriptorSuperClasses(clazz.getSuperclass());
        }
        return modelDescriptor;
    }

    protected ModelDescriptor findModelDescriptorInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interf = classArray[n2];
            ModelDescriptor modelDescriptor = this.classToModelMapping.get(clazz);
            if (modelDescriptor == null) {
                modelDescriptor = this.findModelDescriptorInterfaces(interf);
            }
            if (modelDescriptor != null) {
                return modelDescriptor;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModelDescriptor {
        private EClassifier eClassifier;
        private ModelPackage modelPackage;
        private ModelFactory modelFactory;

        public ModelObject<?> createAdapter(Object modelObject) {
            Check.isTrue(this.getEClassifier() instanceof EClass, "The model descriptor: " + this + " does not represent an EClass");
            return this.modelFactory.createModelObject((EClass)this.eClassifier, modelObject);
        }

        public ModelPackage getModelPackage() {
            return this.modelPackage;
        }

        public void setModelPackage(ModelPackage modelPackage) {
            this.modelPackage = modelPackage;
            this.modelFactory = modelPackage.getModelFactory();
        }

        public EClassifier getEClassifier() {
            return this.eClassifier;
        }

        public void setEClassifier(EClassifier eClassifier) {
            this.eClassifier = eClassifier;
        }

        public String toString() {
            return this.eClassifier + " " + this.modelPackage;
        }
    }
}

