/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    private static final SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");

    public static <T, E extends ModelFeatureMapEntry<?>> List<T> createUnModifiableList(Collection<E> featureMap, EStructuralFeature eStructuralFeature) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ModelFeatureMapEntry entry : featureMap) {
            if (entry.getEStructuralFeature() != eStructuralFeature) continue;
            result.add(entry.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public static EEnum getEnumBaseDataTypeIfObject(EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return null;
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType baseDataType = eDataType;
        while (baseDataType != null) {
            if (baseDataType instanceof EEnum) {
                return (EEnum)baseDataType;
            }
            baseDataType = extendedMetaData.getBaseType(baseDataType);
        }
        return null;
    }

    public static boolean isEMap(EStructuralFeature eFeature) {
        if (!(eFeature.getEType() instanceof EClass)) {
            return false;
        }
        return ModelUtils.isEMap((EClass)eFeature.getEType());
    }

    public static boolean isMixed(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String name = (String)eAnnotation.getDetails().get((Object)"name");
        return kind != null && kind.compareTo("elementWildcard") == 0 && name != null && name.compareTo(":mixed") == 0;
    }

    public static boolean isElement(EStructuralFeature feature) {
        return ModelUtils.isKind(feature, "element");
    }

    public static boolean isGroup(EStructuralFeature feature) {
        return ModelUtils.isKind(feature, "group");
    }

    public static boolean isAttribute(EStructuralFeature feature) {
        return ModelUtils.isKind(feature, "attribute");
    }

    public static EStructuralFeature getMixedEStructuralFeature(EClass eClass) {
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!ModelUtils.isMixed(eStructuralFeature)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    private static boolean isKind(EStructuralFeature feature, String kindValue) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        return kind != null && kind.compareTo(kindValue) == 0;
    }

    public static boolean isEMap(EClass eClass) {
        return eClass != null && eClass.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(eClass.getInstanceClass()) && eClass.getEStructuralFeature("key") != null && eClass.getEStructuralFeature("value") != null;
    }

    public static synchronized String convertToXML(Date dt) {
        return xmlDateFormat.format(dt);
    }

    public static synchronized Date createFromXML(String xmlString) {
        try {
            return xmlDateFormat.parse(xmlString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EPackage getEPackage(String nsuri) {
        EPackage epackage = EPackage.Registry.INSTANCE.getEPackage(nsuri);
        if (epackage == null) {
            throw new IllegalArgumentException("No EPackage registered using the nsuri: " + nsuri);
        }
        return epackage;
    }

    public static List<EPackage> readEPackage(java.net.URI uri) {
        ArrayList<java.net.URI> list = new ArrayList<java.net.URI>();
        list.add(uri);
        return ModelUtils.readEPackages(list);
    }

    public static List<EPackage> readEPackages(List<java.net.URI> uris) {
        ArrayList<URI> emfUris = new ArrayList<URI>();
        for (java.net.URI uri : uris) {
            String uriStr = uri.toString();
            emfUris.add(URI.createURI((String)uriStr));
        }
        return ModelUtils.readEPackagesUsingEMFURI(emfUris);
    }

    public static List<EPackage> readEPackagesUsingEMFURI(List<URI> uris) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        rs.setPackageRegistry(EPackage.Registry.INSTANCE);
        XSDEcoreBuilder ecoreBuilder = new XSDEcoreBuilder((ExtendedMetaData)new BasicExtendedMetaData(rs.getPackageRegistry()));
        for (URI emfURI : uris) {
            if (emfURI.toString().endsWith("xsd")) {
                for (EObject eObject : ecoreBuilder.generate(emfURI)) {
                    EPackage ePackage = ModelUtils.registerEPackage((EPackage)eObject);
                    if (ePackages.contains(ePackage)) continue;
                    ePackages.add(ePackage);
                }
                continue;
            }
            Resource res = rs.createResource(emfURI);
            try {
                res.load(Collections.EMPTY_MAP);
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    EPackage ePackage;
                    Object obj = it.next();
                    if (!(obj instanceof EPackage) || ePackages.contains(ePackage = ModelUtils.registerEPackage((EPackage)obj))) continue;
                    ePackages.add(ePackage);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while loading resource from " + emfURI.toString(), e);
            }
        }
        return ePackages;
    }

    public static void readEPackagesFromFile(ModelPackage modelPackage) {
        String ecoreFileName = modelPackage.getEcoreFileName();
        Check.isNotEmpty(ecoreFileName, "Ecore file of ModelPackage may not be empty.");
        if (ecoreFileName != null && ecoreFileName.length() > 0) {
            try {
                Resource res = new EcoreResourceFactoryImpl().createResource(URI.createURI((String)modelPackage.getNsURI()));
                InputStream is = modelPackage.getClass().getResourceAsStream(ecoreFileName);
                res.load(is, Collections.EMPTY_MAP);
                is.close();
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EPackage)) continue;
                    EPackage epack = (EPackage)obj;
                    ModelUtils.registerEPackage(epack);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while loading models from ecorefile " + ecoreFileName);
            }
        }
    }

    public static void readEPackagesFromFile(String nsUri, String ecoreFileName) {
        Check.isNotEmpty(ecoreFileName, "Ecore file of ModelPackage may not be empty.");
        if (ecoreFileName != null && ecoreFileName.length() > 0) {
            try {
                Resource res = new EcoreResourceFactoryImpl().createResource(URI.createURI((String)nsUri));
                InputStream is = ModelUtils.class.getResourceAsStream(ecoreFileName);
                res.load(is, Collections.EMPTY_MAP);
                is.close();
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EPackage)) continue;
                    EPackage epack = (EPackage)obj;
                    ModelUtils.registerEPackage(epack);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while loading models from ecorefile " + ecoreFileName);
            }
        }
    }

    public static EPackage registerEPackage(EPackage ePackage) {
        Object packageObject;
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        if (registry.containsKey((Object)ePackage.getNsURI()) && (packageObject = registry.get((Object)ePackage.getNsURI())) instanceof EPackage) {
            return (EPackage)packageObject;
        }
        registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        for (EPackage eSubPackage : new ArrayList(ePackage.getESubpackages())) {
            EPackage registeredSubPackage = ModelUtils.registerEPackage(eSubPackage);
            if (registeredSubPackage == eSubPackage) continue;
            int currentIndex = ePackage.getESubpackages().indexOf((Object)eSubPackage);
            assert (eSubPackage == ePackage.getESubpackages().set(currentIndex, (Object)registeredSubPackage));
        }
        return ePackage;
    }

    public static List<EPackage> getAllSubEPackages(List<EPackage> ePackages) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage ePackage : ePackages) {
            result.add(ePackage);
            result.addAll(ModelUtils.getAllSubEPackages(ePackage));
        }
        return result;
    }

    public static List<EPackage> getAllSubEPackages(EPackage ePackage) {
        ArrayList<EPackage> subEPackages = new ArrayList<EPackage>();
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            subEPackages.add(subEPackage);
            subEPackages.addAll(ModelUtils.getAllSubEPackages(subEPackage));
        }
        return subEPackages;
    }

    public static String getEAnnotationValue(EModelElement eModelElement, String source, String key) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)key);
    }

    public static String toString(EStructuralFeature eFeature) {
        Check.isNotNullArgument(eFeature, "eFeature");
        return String.valueOf(eFeature.getClass().getSimpleName()) + ": " + eFeature.getEContainingClass().getName() + "." + eFeature.getName();
    }

    public static EPackage getEPackageInstance(String className) {
        try {
            Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
            EPackage ePackage = (EPackage)clz.getField("eINSTANCE").get(null);
            return ePackage;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception when getting EPackage instance " + className, e);
        }
    }

    public static List<EObject> loadResource(String uri) {
        ResourceSet resourceSet = ModelUtils.createDataResourceSet(EPackage.Registry.INSTANCE);
        Resource resource = resourceSet.createResource(URI.createURI((String)uri));
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        try {
            options.put("EXTENDED_META_DATA", Boolean.TRUE);
            options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            options.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
            options.put("LAX_WILDCARD_PROCESSING", Boolean.TRUE);
            options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
            resource.load(options);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception when loading uri " + uri, e);
        }
        return resource.getContents();
    }

    public static ResourceSet createDataResourceSet(EPackage.Registry registry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(registry);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    public static List<XSDSchema> getXSDSchemas(String uri) {
        ArrayList<XSDSchema> xsdSchemas = new ArrayList<XSDSchema>();
        ResourceSet resourceSet = ModelUtils.getXSDResourceSet(EPackage.Registry.INSTANCE);
        Resource resource = resourceSet.getResource(URI.createURI((String)uri), true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof XSDSchema)) continue;
            xsdSchemas.add((XSDSchema)eObject);
        }
        return xsdSchemas;
    }

    public static ResourceSet getXSDResourceSet(EPackage.Registry registry) {
        ResourceSetImpl result = new ResourceSetImpl();
        result.setPackageRegistry(registry);
        result.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        Map extensionToFactoryMap = result.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("wsdl", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("xsd", new XSDResourceFactoryImpl());
        extensionToFactoryMap.put("ecore", new EcoreResourceFactoryImpl());
        return result;
    }

    public static byte[] getEPackageAsByteArray(EPackage ePackage, EPackage.Registry packageRegistry) {
        try {
            Resource resource = ePackage.eResource();
            if (resource == null) {
                resource = ModelUtils.createEcoreResource(ePackage.getNsURI(), packageRegistry);
                resource.getContents().add((Object)ePackage);
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ZIP", true);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            resource.save((OutputStream)os, options);
            return os.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static EPackage createEPackage(String nsUri, byte[] bytes, EPackage.Registry packageRegistry) {
        if (packageRegistry.getEPackage(nsUri) != null) {
            return packageRegistry.getEPackage(nsUri);
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Resource resource = ModelUtils.createEcoreResource(nsUri, packageRegistry);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ZIP", true);
            resource.load((InputStream)bais, options);
            EList contents = resource.getContents();
            EPackage ePackage = (EPackage)contents.get(0);
            return ePackage;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Resource createEcoreResource(String uri, EPackage.Registry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry(packageRegistry);
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("*", resourceFactory);
        return resourceSet.createResource(URI.createURI((String)uri));
    }
}

