/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.ArtifactGenerator;
import org.eclipse.emf.texo.generator.BaseMainTemplate;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.generator.ModelAnnotatorRegistry;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.modelgenerator.xtend.ModelTemplate;
import org.eclipse.emf.texo.orm.annotator.ORMMappingOptions;
import org.eclipse.emf.texo.orm.annotator.ORMUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexoGeneratorApplication
implements IApplication {
    private static final String ARG_PROJECT_NAME = "-projectName";
    private static final String ARG_JPA = "-jpa";
    private static final String ARG_DAO = "-dao";
    private static final String ARG_MODEL_LOCATION = "-modelLocation";
    private static final String JAVA_PROJECT_NAME = "org.eclipse.emf.texo.gen";

    public Object start(IApplicationContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] args = (String[])context.getArguments().get("application.args");
        String projectName = null;
        boolean nextArgIsProject = false;
        boolean nextArgIsModelLocation = false;
        boolean doDao = false;
        boolean doJpa = false;
        String modelLocation = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (nextArgIsProject) {
                projectName = arg;
                nextArgIsProject = false;
            }
            if (nextArgIsModelLocation) {
                modelLocation = arg;
                nextArgIsModelLocation = false;
            }
            if (ARG_PROJECT_NAME.equals(arg)) {
                nextArgIsProject = true;
            } else if (ARG_MODEL_LOCATION.equals(arg)) {
                nextArgIsModelLocation = true;
            } else if (ARG_DAO.equals(arg)) {
                doDao = true;
            } else if (ARG_JPA.equals(arg)) {
                doJpa = true;
            }
            ++n2;
        }
        if (modelLocation == null) {
            throw new IllegalArgumentException("Missing parameter: modelLocation");
        }
        this.println(">> Texo Artifact Generation");
        this.println("arguments:");
        this.println("workspace path: " + workspace.getRoot().getLocation().toOSString());
        this.println("project: " + (projectName == null ? JAVA_PROJECT_NAME : projectName));
        this.println("modelLocation: " + modelLocation);
        this.println("jpa: " + doJpa);
        this.println("dao: " + doDao);
        if (projectName != null && projectName.trim().length() == 0) {
            projectName = null;
        }
        if (doJpa) {
            if (projectName != null) {
                ORMUtils.setORMMappingOptionsFromProjectProperties((IProject)EclipseGeneratorUtils.getProject((String)projectName));
            } else {
                ORMMappingOptions ormOptions = this.getORMMappingsOptions();
                ORMMappingOptions.setDefaultOptions((ORMMappingOptions)ormOptions);
            }
        }
        try {
            IProject project;
            if (projectName == null) {
                this.println("Creating gen project");
                this.createJavaProject();
                projectName = JAVA_PROJECT_NAME;
            }
            if ((project = workspace.getRoot().getProject(projectName)) == null) {
                throw new RuntimeException("Project " + projectName + " not found in workspace " + workspace.getRoot().getLocation().toOSString());
            }
            this.generateCode(project, modelLocation, doDao, doJpa);
        }
        finally {
            ORMMappingOptions.setDefaultOptions(null);
        }
        return null;
    }

    public void stop() {
    }

    private void println(String line) {
        System.out.println(line);
    }

    private void generateCode(IProject project, String modelLocation, boolean doDao, boolean doJpa) {
        ModelAnnotatorRegistry.getInstance().getModelAnnotators();
        List<URI> uris = this.getURIs(modelLocation);
        if (doJpa) {
            AnnotationManager.enableAnnotationSystem((String)"jpa");
        }
        for (URI uri : uris) {
            try {
                this.println("Generating for model file: " + uri);
                this.generateCode(project, uri, doDao);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception for model file " + uri, e);
            }
        }
    }

    private void generateCode(IProject project, URI uri, boolean doDao) {
        EPackage.Registry packageRegistry = GeneratorUtils.createEPackageRegistry();
        List ePackages = GeneratorUtils.readEPackagesUsingEMFURI(Collections.singletonList(uri), (EPackage.Registry)packageRegistry);
        for (EPackage ePackage : ePackages) {
            this.println("EPackage " + ePackage.getNsURI());
        }
        ModelController modelController = new ModelController();
        modelController.setEPackages(ePackages);
        modelController.getAnnotationManager().getAnnotatedModel().setGeneratingSources(true);
        modelController.annotate(new ArrayList());
        ArtifactGenerator artifactGenerator = new ArtifactGenerator();
        artifactGenerator.setModelController(modelController);
        artifactGenerator.setOutputFolder(ProjectPropertyUtil.getGenOutputFolder((IProject)project));
        artifactGenerator.setProjectName(ProjectPropertyUtil.getTargetProject((IProject)project).getName());
        if (doDao) {
            artifactGenerator.setDoDao(true);
        }
        artifactGenerator.setXTendTemplate((BaseMainTemplate)new ModelTemplate());
        artifactGenerator.run();
    }

    private List<URI> getURIs(String modelLocation) {
        File modelFile = new File(modelLocation);
        ArrayList<File> files = new ArrayList<File>();
        if (!modelFile.exists()) {
            throw new RuntimeException("Model file " + modelLocation + " does not exist");
        }
        if (modelFile.isDirectory()) {
            File[] fileArray = modelFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith("xsd") || file.getName().endsWith("ecore")) {
                    files.add(file);
                }
                ++n2;
            }
            if (files.isEmpty()) {
                throw new RuntimeException("No model files (ecore, xsd) found in location " + modelLocation);
            }
        } else {
            if (!modelLocation.endsWith("xsd") && !modelLocation.endsWith("ecore")) {
                throw new RuntimeException("Model location " + modelLocation + " is not a model file, supported file extensions are xsd or ecore");
            }
            files.add(modelFile);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (File file : files) {
            try {
                uris.add(URI.createFileURI((String)file.getPath()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return uris;
    }

    private ORMMappingOptions getORMMappingsOptions() {
        ORMMappingOptions ormOptions = new ORMMappingOptions();
        ormOptions.setAddOrderColumnToListMappings(true);
        ormOptions.setRenameSQLReservedNames(true);
        ormOptions.setEnforceUniqueNames(true);
        ormOptions.setGenerateFullDbSchemaNames(true);
        return ormOptions;
    }

    private IJavaProject createJavaProject() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject project = root.getProject(JAVA_PROJECT_NAME);
            if (project.exists()) {
                project.delete(true, (IProgressMonitor)progressMonitor);
            }
            project.create((IProgressMonitor)progressMonitor);
            project.open((IProgressMonitor)progressMonitor);
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)progressMonitor);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashSet<IClasspathEntry> entries = new HashSet<IClasspathEntry>();
            entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
            entries.add(JavaRuntime.getDefaultJREContainerEntry());
            javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), (IProgressMonitor)progressMonitor);
            return javaProject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

