/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.popup.actions.BaseGenerateAction;
import org.eclipse.emf.texo.generator.AnnotationModelGenerator;
import org.eclipse.emf.texo.generator.ExtensionPointUtils;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.generator.ModelAnnotator;
import org.eclipse.emf.texo.generator.ModelAnnotatorRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAnnotationModel
extends BaseGenerateAction {
    @Override
    protected void generateFromModelFiles(IProgressMonitor monitor, IProject project, List<IFile> modelFiles) {
        for (IFile modelFile : modelFiles) {
            this.generateFromModelFile(monitor, project, modelFile);
        }
    }

    protected List<ModelAnnotator> getModelAnnotators() {
        return ModelAnnotatorRegistry.getInstance().getModelAnnotators();
    }

    protected boolean doOnlyInitialModel() {
        return false;
    }

    protected String getModelAnnotatorSuffix() {
        return "";
    }

    protected EPackage getAnnotationEPackage() {
        return null;
    }

    protected void generateFromModelFile(IProgressMonitor monitor, IProject project, IFile modelFile) {
        ExtensionPointUtils.readAnnotationsModelsFromExtensions();
        try {
            URI platformUri = new URI(modelFile.getFullPath().toString());
            List ePackages = GeneratorUtils.readEPackages(Collections.singletonList(platformUri), (EPackage.Registry)GeneratorUtils.createEPackageRegistry(), (boolean)true);
            ListIterator iterator = ePackages.listIterator();
            while (iterator.hasNext()) {
                EPackage ePackage = (EPackage)iterator.next();
                if (!(ePackage.eContainer() instanceof EPackage)) continue;
                iterator.remove();
            }
            if (ePackages.size() != 1) {
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("incorrect.number.of.epackages.message"), (String)Messages.formatMessage("incorrect.number.of.epackages.message", platformUri.toString(), ePackages.size()));
                return;
            }
            AnnotationModelGenerator generator = new AnnotationModelGenerator();
            generator.setCreateOnlyInitialModel(this.doOnlyInitialModel());
            generator.setModelAnnotators(this.getModelAnnotators());
            generator.createStoreAnnotationModel((EPackage)ePackages.get(0), this.getModelAnnotatorSuffix(), this.getAnnotationEPackage(), modelFile);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

