/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.eclipse.popup.actions.BaseGenerateAction;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.ArtifactGenerator;
import org.eclipse.emf.texo.generator.BaseMainTemplate;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.modelgenerator.xtend.ModelTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateCode
extends BaseGenerateAction {
    private boolean doDao = false;
    private boolean doJpa = false;

    @Override
    protected void generateFromModelFiles(IProgressMonitor monitor, IProject project, List<IFile> modelFiles) {
        for (IFile modelFile : modelFiles) {
            this.generateFromModelFile(monitor, project, modelFile);
        }
    }

    protected void generateFromModelFile(IProgressMonitor monitor, IProject project, IFile modelFile) {
        if (this.isDoJpa()) {
            AnnotationManager.enableAnnotationSystem((String)"jpa");
        }
        try {
            try {
                URI uri = new URI(modelFile.getFullPath().toString());
                List ePackages = GeneratorUtils.readEPackages(Collections.singletonList(uri), (EPackage.Registry)GeneratorUtils.createEPackageRegistry(), (boolean)true);
                this.validateEPackages(ePackages);
                ModelController modelController = new ModelController();
                modelController.setEPackages(ePackages);
                monitor.subTask(Messages.getString("generate.Annotating"));
                modelController.getAnnotationManager().getAnnotatedModel().setGeneratingSources(true);
                modelController.annotate(new ArrayList());
                ArtifactGenerator artifactGenerator = new ArtifactGenerator();
                artifactGenerator.setMonitor(monitor);
                artifactGenerator.setOutputFolder(ProjectPropertyUtil.getGenOutputFolder(project));
                artifactGenerator.setModelController(modelController);
                artifactGenerator.setProjectName(ProjectPropertyUtil.getTargetProject(project).getName());
                artifactGenerator.setDoDao(this.isDoDao());
                artifactGenerator.setXTendTemplate((BaseMainTemplate)new ModelTemplate());
                int eClassifierCount = 0;
                for (EPackage ePackage : ePackages) {
                    eClassifierCount += ePackage.getEClassifiers().size();
                    ++eClassifierCount;
                }
                monitor.beginTask(Messages.getString("generate.Initialize"), eClassifierCount);
                artifactGenerator.run();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IllegalStateException(e);
            }
        }
        finally {
            AnnotationManager.removeEnabledAnnotationSystem((String)"jpa");
        }
    }

    protected boolean isDoDao() {
        return this.doDao;
    }

    private void validateEPackages(List<EPackage> ePackages) {
        Diagnostician diagnostician = new Diagnostician(EValidator.Registry.INSTANCE){

            public String getObjectLabel(EObject object) {
                return EcoreUtil.getURI((EObject)object).toString();
            }
        };
        HashMap context = new HashMap();
        for (EPackage ePackage : ePackages) {
            List<String> notWellFormedPackageNames = this.getNotWellFormedPackageNames(ePackage);
            Diagnostic diagnostic = diagnostician.validate((EObject)ePackage, context);
            StringBuilder sb = new StringBuilder("Invalid EPackage: " + ePackage.getName());
            sb.append("\n" + diagnostic.getMessage());
            boolean realError = false;
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (notWellFormedPackageNames.contains(childDiagnostic.getMessage())) continue;
                realError = true;
                sb.append("\n" + childDiagnostic.getMessage());
            }
            if (!realError || diagnostic.getSeverity() != 4) continue;
            throw new IllegalStateException(sb.toString(), diagnostic.getException());
        }
    }

    private List<String> getNotWellFormedPackageNames(EPackage ePackage) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("The name '" + ePackage.getName() + "' is not well formed");
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            result.addAll(this.getNotWellFormedPackageNames(subEPackage));
        }
        return result;
    }

    public void setDoDao(boolean doDao) {
        this.doDao = doDao;
    }

    public boolean isDoJpa() {
        return this.doJpa;
    }

    public void setDoJpa(boolean doJpa) {
        this.doJpa = doJpa;
    }
}

