/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.texo.eclipse.popup.actions.BaseGenerateAction;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateEcoreFromXSD
extends BaseGenerateAction {
    @Override
    protected void generateFromModelFiles(IProgressMonitor monitor, IProject project, List<IFile> modelFiles) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            resourceSet.setPackageRegistry(EPackage.Registry.INSTANCE);
            XSDEcoreBuilder ecoreBuilder = new XSDEcoreBuilder((ExtendedMetaData)new BasicExtendedMetaData(EPackage.Registry.INSTANCE));
            for (IFile modelFile : modelFiles) {
                java.net.URI uri = new java.net.URI(modelFile.getFullPath().toString());
                if (!uri.toString().endsWith("xsd")) continue;
                URI emfURI = URI.createURI((String)uri.toString());
                Collection eObjects = ecoreBuilder.generate(emfURI);
                boolean multipleFiles = eObjects.size() > 1;
                for (EObject eObject : eObjects) {
                    EPackage ePackage = (EPackage)eObject;
                    URI ecoreURI = emfURI.trimFileExtension().appendFileExtension("ecore");
                    if (multipleFiles) {
                        String strUri = ecoreURI.toString();
                        int lastDot = strUri.lastIndexOf(".");
                        strUri = String.valueOf(strUri.substring(0, lastDot)) + "_" + ePackage.getName() + strUri.substring(lastDot);
                        ecoreURI = URI.createURI((String)strUri);
                    }
                    Resource resource = resourceSet.createResource(ecoreURI);
                    resource.getContents().clear();
                    resource.getContents().add((Object)ePackage);
                }
                for (Resource resource : resourceSet.getResources()) {
                    resource.save(Collections.emptyMap());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

