/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.properties;

import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.eclipse.nature.TexoAutoCodeGenerator;
import org.eclipse.emf.texo.eclipse.properties.FolderSelectionDialog;
import org.eclipse.emf.texo.eclipse.properties.ProjectSelectionDialog;
import org.eclipse.emf.texo.generator.EclipseGeneratorUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage {
    private static final int TEXT_FIELD_WIDTH = 50;
    private Text targetProjectText;
    private Button targetProjectButton;
    private Text outputFolderText;
    private Button outputFolderButton;
    private Text templateFolderText;
    private Button templateFolderButton;
    private Button autoGenButton;
    private Button daoGenButton;
    private Button jpaGenButton;
    private Button addOrderColumnToListMappingsButton;
    private Button enforceUniqueNamesButton;
    private Button renameSQLReservedNamesButton;
    private Button generateFullDbSchemaNamesButton;
    private Text maximumSqlNameLengthScale;
    private Text modelFolderText;
    private Button modelFolderButton;
    private IProject project;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ProjectPropertyPage.this.getApplyButton().setEnabled(true);
        }
    };

    private void setTargetProject(IProject project) {
        if (project == null) {
            this.targetProjectText.setText(null);
        } else {
            this.targetProjectText.setText(project.getName());
        }
    }

    private void setOutputFolder(IFolder outputFolder) {
        if (outputFolder == null) {
            this.outputFolderText.setText(this.project.getProjectRelativePath().append("src-gen").toPortableString());
        } else {
            this.outputFolderText.setText(outputFolder.getProjectRelativePath().toPortableString());
        }
    }

    private void setTemplateFolder(IFolder templateFolder) {
        if (templateFolder == null) {
            this.templateFolderText.setText(null);
        } else {
            this.templateFolderText.setText(templateFolder.getProjectRelativePath().toPortableString());
        }
    }

    private void setModelFolder(IFolder modelFolder) {
        if (modelFolder == null) {
            this.modelFolderText.setText(null);
        } else {
            this.modelFolderText.setText(modelFolder.getProjectRelativePath().toPortableString());
        }
    }

    protected Control createContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2048);
        TabItem mainTab = new TabItem(tabFolder, 0);
        mainTab.setText(Messages.getString("tab.title.generate"));
        mainTab.setControl((Control)this.createMainTabContent((Composite)tabFolder));
        TabItem ormMappingTab = new TabItem(tabFolder, 0);
        ormMappingTab.setText(Messages.getString("tab.title.ormMapping"));
        ormMappingTab.setControl((Control)this.createORMMappingTabContent((Composite)tabFolder));
        return tabFolder;
    }

    protected Composite createORMMappingTabContent(Composite parent) {
        Composite mainComposite = this.createDefaultComposite(parent, 1);
        Composite composite = this.createDefaultComposite(mainComposite, 2);
        Properties projectProps = ProjectPropertyUtil.getProjectProperties(this.project);
        this.addOrderColumnToListMappingsButton = this.createCheckBox(projectProps, composite, "ORM_ADD_ORDER_COLUMN", "orm.option.add.order.column");
        this.enforceUniqueNamesButton = this.createCheckBox(projectProps, composite, "ORM_ENFORCE_UNIQUE_NAMES", "orm.option.enforce.unique.names");
        this.renameSQLReservedNamesButton = this.createCheckBox(projectProps, composite, "ORM_RENAME_SQL_RESERVED_NAMES", "orm.option.rename.sql.reserved.names");
        this.generateFullDbSchemaNamesButton = this.createCheckBox(projectProps, composite, "ORM_GENERATE_FULL_DB_SCHEMA_NAMES", "orm.option.generate.full.db.schema.names");
        Label maxSQLLabel = new Label(composite, 16384);
        maxSQLLabel.setText(Messages.getString("orm.option.max.sql.name.length"));
        this.maximumSqlNameLengthScale = new Text(composite, 18436);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.maximumSqlNameLengthScale.setLayoutData((Object)gridData);
        this.maximumSqlNameLengthScale.setEditable(true);
        this.maximumSqlNameLengthScale.setText(this.getSafeValue(projectProps.getProperty("ORM_MAX_SQL_NAME_LENGTH")));
        this.maximumSqlNameLengthScale.addModifyListener(this.listener);
        this.maximumSqlNameLengthScale.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        return mainComposite;
    }

    private Button createCheckBox(Properties projectProps, Composite parent, String propName, String label) {
        String val = projectProps.getProperty(propName);
        Button button = new Button(parent, 32);
        button.setText(Messages.getString(label));
        button.setSelection(val != null && val.equals("true"));
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }
        });
        return button;
    }

    protected Composite createMainTabContent(Composite parent) {
        this.project = ProjectPropertyUtil.getProject(this.getElement());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createFields(composite);
        this.createAutoGenGroup(composite);
        return composite;
    }

    private void createFields(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 3);
        Properties projectProps = ProjectPropertyUtil.getProjectProperties(this.project);
        Label projectLabel = new Label(composite, 16384);
        projectLabel.setText(Messages.getString("project.target.label"));
        this.targetProjectText = new Text(composite, 18444);
        GridData projectGd = new GridData();
        projectGd.widthHint = this.convertWidthInCharsToPixels(50);
        this.targetProjectText.setLayoutData((Object)projectGd);
        this.targetProjectText.setEditable(true);
        this.targetProjectText.setText(this.getSafeValue(projectProps.getProperty("TARGET_PROJECT")));
        this.targetProjectText.addModifyListener(this.listener);
        this.targetProjectButton = new Button(composite, 8);
        this.targetProjectButton.setText(Messages.getString("browse"));
        this.targetProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseTargetProject();
            }
        });
        Label outputFolderLabel = new Label(composite, 16384);
        outputFolderLabel.setText(Messages.getString("project.output.folder.label"));
        this.outputFolderText = new Text(composite, 18444);
        GridData folderGd = new GridData();
        folderGd.widthHint = this.convertWidthInCharsToPixels(50);
        this.outputFolderText.setLayoutData((Object)folderGd);
        this.outputFolderText.setEditable(true);
        this.outputFolderText.setText(this.getSafeValue(projectProps.getProperty("OUTPUT_FOLDER")));
        this.outputFolderText.addModifyListener(this.listener);
        this.outputFolderButton = new Button(composite, 8);
        this.outputFolderButton.setText(Messages.getString("browse"));
        this.outputFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseOutputFolder();
            }
        });
        Label templateFolderLabel = new Label(composite, 16384);
        templateFolderLabel.setText(Messages.getString("project.template.folder.label"));
        this.templateFolderText = new Text(composite, 18444);
        GridData templateFolderGd = new GridData();
        templateFolderGd.widthHint = this.convertWidthInCharsToPixels(50);
        this.templateFolderText.setLayoutData((Object)templateFolderGd);
        this.templateFolderText.setEditable(true);
        this.templateFolderText.setText(this.getSafeValue(projectProps.getProperty("TEMPLATE_FOLDER")));
        this.templateFolderText.addModifyListener(this.listener);
        this.templateFolderButton = new Button(composite, 8);
        this.templateFolderButton.setText(Messages.getString("browse"));
        this.templateFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseTemplateFolder();
            }
        });
    }

    private void createAutoGenGroup(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 1);
        Properties projectProps = ProjectPropertyUtil.getProjectProperties(this.project);
        Group autoGenGroup = new Group(composite, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        autoGenGroup.setLayout((Layout)layout);
        GridData data = new GridData(516);
        data.grabExcessHorizontalSpace = true;
        autoGenGroup.setLayoutData((Object)data);
        autoGenGroup.setText(Messages.getString("autoGenGroup"));
        this.autoGenButton = new Button((Composite)autoGenGroup, 32);
        this.autoGenButton.setText(Messages.getString("autoGen"));
        this.autoGenButton.setSelection(projectProps.getProperty("ENABLE_AUTOGEN_PROPERTY") != null);
        this.autoGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.enableDisableAutoGenFields(ProjectPropertyPage.this.autoGenButton.getSelection());
                ProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }
        });
        this.autoGenButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        Label modelFolderLabel = new Label((Composite)autoGenGroup, 16384);
        modelFolderLabel.setText(Messages.getString("project.model.folder.label"));
        this.modelFolderText = new Text((Composite)autoGenGroup, 18444);
        GridData folderGd = new GridData();
        folderGd.widthHint = this.convertWidthInCharsToPixels(50);
        this.modelFolderText.setLayoutData((Object)folderGd);
        this.modelFolderText.setEditable(true);
        this.modelFolderText.setText(this.getSafeValue(projectProps.getProperty("MODEL_FOLDER")));
        this.modelFolderText.addModifyListener(this.listener);
        this.modelFolderButton = new Button((Composite)autoGenGroup, 8);
        this.modelFolderButton.setText(Messages.getString("browse"));
        this.modelFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertyPage.this.browseModelFolder();
            }
        });
        this.daoGenButton = new Button((Composite)autoGenGroup, 32);
        this.daoGenButton.setText(Messages.getString("autoDaoGen"));
        this.daoGenButton.setSelection(projectProps.getProperty("ENABLE_DAO_PROPERTY") != null);
        this.daoGenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.daoGenButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        this.jpaGenButton = new Button((Composite)autoGenGroup, 32);
        this.jpaGenButton.setText(Messages.getString("autoJpaGen"));
        this.jpaGenButton.setSelection(projectProps.getProperty("ENABLE_JPA_PROPERTY") != null);
        this.jpaGenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ProjectPropertyPage.this.getApplyButton().setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.jpaGenButton.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        this.enableDisableAutoGenFields(this.autoGenButton.getSelection());
        TexoAutoCodeGenerator.addRemoveProjectBuilder(this.project, this.autoGenButton.getSelection());
    }

    private void enableDisableAutoGenFields(boolean autoGen) {
        this.jpaGenButton.setEnabled(autoGen);
        this.daoGenButton.setEnabled(autoGen);
        this.modelFolderButton.setEnabled(autoGen);
        this.modelFolderText.setEnabled(autoGen);
    }

    private void browseTargetProject() {
        ProjectSelectionDialog selectionDialog = new ProjectSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.target.select.title"));
        selectionDialog.setMessage(Messages.getString("project.target.select.message"));
        selectionDialog.setBlockOnOpen(true);
        selectionDialog.setInput(this.project.getWorkspace().getRoot());
        selectionDialog.setInitialSelection(this.targetProjectText.getText());
        if (selectionDialog.open() == 0) {
            this.setTargetProject((IProject)selectionDialog.getFirstResult());
        }
    }

    private void browseOutputFolder() {
        FolderSelectionDialog selectionDialog = new FolderSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.output.folder.select.title"));
        selectionDialog.setMessage(Messages.getString("project.output.folder.select.message"));
        selectionDialog.setBlockOnOpen(true);
        if (this.targetProjectText.getText() != null && this.targetProjectText.getText().trim().length() > 0) {
            selectionDialog.setInput(EclipseGeneratorUtils.getProject((String)this.targetProjectText.getText()));
        } else {
            selectionDialog.setInput(this.project);
        }
        selectionDialog.setInitialSelection(this.outputFolderText.getText());
        if (selectionDialog.open() == 0) {
            this.setOutputFolder((IFolder)selectionDialog.getFirstResult());
        }
    }

    private void browseTemplateFolder() {
        FolderSelectionDialog selectionDialog = new FolderSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.template.folder.select.title"));
        selectionDialog.setMessage(Messages.getString("project.template.folder.select.message"));
        selectionDialog.setBlockOnOpen(true);
        selectionDialog.setInput(this.project);
        selectionDialog.setInitialSelection(this.templateFolderText.getText());
        if (selectionDialog.open() == 0) {
            this.setTemplateFolder((IFolder)selectionDialog.getFirstResult());
        }
    }

    private void browseModelFolder() {
        FolderSelectionDialog selectionDialog = new FolderSelectionDialog(Display.getCurrent().getActiveShell());
        selectionDialog.setTitle(Messages.getString("project.model.folder.select.title"));
        selectionDialog.setMessage(Messages.getString("project.model.folder.select.message"));
        selectionDialog.setBlockOnOpen(true);
        selectionDialog.setInput(this.project);
        selectionDialog.setInitialSelection(this.modelFolderText.getText());
        if (selectionDialog.open() == 0) {
            this.setModelFolder((IFolder)selectionDialog.getFirstResult());
        }
    }

    private Composite createDefaultComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.outputFolderText.setText(this.project.getProjectRelativePath().append("src-gen").toPortableString());
        this.templateFolderText.setText("");
        this.modelFolderText.setText("");
        this.autoGenButton.setSelection(false);
        this.jpaGenButton.setSelection(false);
        this.daoGenButton.setSelection(false);
        this.enableDisableAutoGenFields(this.autoGenButton.getSelection());
    }

    public boolean performOk() {
        try {
            Properties props = new Properties();
            this.setProperty(props, "TARGET_PROJECT", this.getNullForEmptyString(this.targetProjectText.getText()));
            this.setProperty(props, "TEMPLATE_FOLDER", this.getNullForEmptyString(this.templateFolderText.getText()));
            this.setProperty(props, "OUTPUT_FOLDER", this.getNullForEmptyString(this.outputFolderText.getText()));
            this.setProperty(props, "MODEL_FOLDER", this.getNullForEmptyString(this.modelFolderText.getText()));
            this.setProperty(props, "ENABLE_AUTOGEN_PROPERTY", this.autoGenButton.getSelection() ? "true" : null);
            this.setProperty(props, "ENABLE_DAO_PROPERTY", this.daoGenButton.getSelection() ? "true" : null);
            this.setProperty(props, "ENABLE_JPA_PROPERTY", this.jpaGenButton.getSelection() ? "true" : null);
            this.setProperty(props, "ORM_ADD_ORDER_COLUMN", this.addOrderColumnToListMappingsButton.getSelection() ? "true" : "false");
            this.setProperty(props, "ORM_ADD_ORDER_COLUMN", this.addOrderColumnToListMappingsButton.getSelection() ? "true" : "false");
            this.setProperty(props, "ORM_ENFORCE_UNIQUE_NAMES", this.enforceUniqueNamesButton.getSelection() ? "true" : "false");
            this.setProperty(props, "ORM_GENERATE_FULL_DB_SCHEMA_NAMES", this.generateFullDbSchemaNamesButton.getSelection() ? "true" : "false");
            this.setProperty(props, "ORM_RENAME_SQL_RESERVED_NAMES", this.renameSQLReservedNamesButton.getSelection() ? "true" : "false");
            this.setProperty(props, "ORM_MAX_SQL_NAME_LENGTH", this.getNullForEmptyString(this.maximumSqlNameLengthScale.getText()));
            ProjectPropertyUtil.setProjectProperties(this.project, props);
            TexoAutoCodeGenerator.addRemoveProjectBuilder(this.project, this.autoGenButton.getSelection());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setProperty(Properties props, String property, String value) {
        if (value == null) {
            props.remove(property);
        } else {
            props.put(property, value);
        }
    }

    private String getNullForEmptyString(String value) {
        if (value == null) {
            return null;
        }
        if (value.trim().length() == 0) {
            return null;
        }
        return value.trim();
    }

    private String getSafeValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    protected void performApply() {
        this.performOk();
        this.getApplyButton().setEnabled(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setEnabled(false);
    }
}

