/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.properties;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionDialog
extends ElementTreeSelectionDialog {
    public ProjectSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ContainerContentProvider());
        this.setValidator(new SelectionValidator());
    }

    public void setInput(Object input) {
        if (!(input instanceof IWorkspaceRoot)) {
            throw new IllegalArgumentException("Input must be of type IWorkspaceRoot.");
        }
        super.setInput(input);
    }

    private static class ContainerContentProvider
    extends WorkbenchContentProvider {
        private ContainerContentProvider() {
        }

        public Object[] getElements(Object element) {
            return this.filter((IWorkspaceRoot)element);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspaceRoot) {
                return this.filter((IWorkspaceRoot)element);
            }
            return new Object[0];
        }

        private Object[] filter(IWorkspaceRoot container) {
            try {
                ArrayList<IResource> resources = new ArrayList<IResource>();
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IProject && ((IProject)resource).isOpen() && (javaProject = JavaCore.create((IProject)((IProject)resource))).exists()) {
                        resources.add(resource);
                    }
                    ++n2;
                }
                return resources.toArray();
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length == 1 && selection[0] instanceof IProject) {
                return new Status(0, "org.eclipse.emf.texo.eclipse", 0, "", null);
            }
            return new Status(4, "org.eclipse.emf.texo.eclipse", 4, "", null);
        }
    }
}

