/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEAttribute;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEDataType;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnum;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnumLiteral;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedENamedElement;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEReference;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelFactory;
import org.eclipse.emf.texo.annotations.annotationsmodel.EAttributeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EClassAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EDataTypeAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EEnumAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EEnumLiteralAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EPackageAnnotation;
import org.eclipse.emf.texo.annotations.annotationsmodel.EReferenceAnnotation;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.ModelAnnotator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager {
    public static final String JPA_ANNOTATION_SYSTEM_ID = "jpa";
    private static List<String> enabledAnnotationSystems = new ArrayList<String>();
    private Map<EClass, Annotator<? extends ENamedElementAnnotation>> annotators = new HashMap<EClass, Annotator<? extends ENamedElementAnnotation>>();
    private AnnotatedModel annotatedModel = AnnotationsmodelFactory.eINSTANCE.createAnnotatedModel();
    private Map<ENamedElementAnnotation, ENamedElementAnnotation> processedAnnotations = new HashMap<ENamedElementAnnotation, ENamedElementAnnotation>();

    public static boolean isAnnotationSystemEnabled(String id) {
        return enabledAnnotationSystems.contains(id);
    }

    public static void enableAnnotationSystem(String id) {
        if (!AnnotationManager.isAnnotationSystemEnabled(id)) {
            enabledAnnotationSystems.add(id);
        }
    }

    public static void removeEnabledAnnotationSystem(String id) {
        enabledAnnotationSystems.remove(id);
    }

    public ENamedElementAnnotation getAnnotation(ENamedElement eModelElement, EClass annotationEClass) {
        return this.getAnnotation(eModelElement, annotationEClass, true);
    }

    public ENamedElementAnnotation getAnnotation(ENamedElement eModelElement, EClass annotationEClass, boolean initialized) {
        AnnotatedENamedElement aElement = this.annotatedModel.getAnnotatedENamedElement(eModelElement, true);
        ENamedElementAnnotation eNamedElementAnnotation = null;
        for (ENamedElementAnnotation annotation : aElement.getAllAnnotations()) {
            if (!annotationEClass.isSuperTypeOf(annotation.eClass())) continue;
            eNamedElementAnnotation = annotation;
            break;
        }
        if (eNamedElementAnnotation == null) {
            eNamedElementAnnotation = (ENamedElementAnnotation)annotationEClass.getEPackage().getEFactoryInstance().create(annotationEClass);
            eNamedElementAnnotation.setGenerated(true);
            this.addAnnotation((EModelElement)eModelElement, eNamedElementAnnotation);
        }
        if (initialized && !this.processedAnnotations.containsKey(eNamedElementAnnotation) && this.annotators.containsKey(annotationEClass)) {
            this.annotators.get(annotationEClass).setAnnotationFeatures((ENamedElementAnnotation)eNamedElementAnnotation);
            this.processedAnnotations.put(eNamedElementAnnotation, eNamedElementAnnotation);
        }
        return eNamedElementAnnotation;
    }

    public List<ENamedElementAnnotation> getAnnotations(ENamedElement namedElement) {
        AnnotatedENamedElement aElement = this.annotatedModel.getAnnotatedENamedElement(namedElement, true);
        return aElement.getAllAnnotations();
    }

    protected void addAnnotation(EModelElement eModelElement, ENamedElementAnnotation annotation) {
        if (eModelElement instanceof EPackage) {
            AnnotatedEPackage aPackage = this.annotatedModel.getAnnotatedEPackage((EPackage)eModelElement, true);
            aPackage.getEPackageAnnotations().add((Object)((EPackageAnnotation)annotation));
        } else if (eModelElement instanceof EClass) {
            AnnotatedEClass aClass = this.annotatedModel.getAnnotatedEClass((EClass)eModelElement, true);
            aClass.getEClassAnnotations().add((Object)((EClassAnnotation)annotation));
        } else if (eModelElement instanceof EReference) {
            AnnotatedEReference aReference = this.annotatedModel.getAnnotatedEReference((EReference)eModelElement, true);
            aReference.getEReferenceAnnotations().add((Object)((EReferenceAnnotation)annotation));
        } else if (eModelElement instanceof EAttribute) {
            AnnotatedEAttribute aAttribute = this.annotatedModel.getAnnotatedEAttribute((EAttribute)eModelElement, true);
            aAttribute.getEAttributeAnnotations().add((Object)((EAttributeAnnotation)annotation));
        } else if (eModelElement instanceof EEnum) {
            AnnotatedEEnum aEnum = this.annotatedModel.getAnnotatedEEnum((EEnum)eModelElement, true);
            if (annotation instanceof EEnumAnnotation) {
                aEnum.getEEnumAnnotations().add((Object)((EEnumAnnotation)annotation));
            } else {
                aEnum.getEDataTypeAnnotations().add((Object)((EDataTypeAnnotation)annotation));
            }
        } else if (eModelElement instanceof EEnumLiteral) {
            AnnotatedEEnumLiteral aEnumLiteral = this.annotatedModel.getAnnotatedEEnumLiteral((EEnumLiteral)eModelElement, true);
            aEnumLiteral.getEEnumLiteralAnnotations().add((Object)((EEnumLiteralAnnotation)annotation));
        } else if (eModelElement instanceof EDataType) {
            AnnotatedEDataType aDataType = this.annotatedModel.getAnnotatedEDataType((EDataType)eModelElement, true);
            aDataType.getEDataTypeAnnotations().add((Object)((EDataTypeAnnotation)annotation));
        } else {
            throw new IllegalArgumentException("Type " + eModelElement + " not supported here");
        }
    }

    public void addAnnotators(ModelAnnotator modelAnnotator) {
        for (Annotator<? extends ENamedElementAnnotation> annotator : modelAnnotator.getAnnotators()) {
            this.addAnnotator(annotator);
        }
    }

    public void addAnnotator(Annotator<? extends ENamedElementAnnotation> annotator) {
        this.annotators.put(annotator.getAnnotationEClass(), annotator);
        annotator.setAnnotationManager(this);
    }

    public Annotator<ENamedElementAnnotation> getAnnotator(EClass annotationEClass) {
        return this.annotators.get(annotationEClass);
    }

    public AnnotatedModel getAnnotatedModel() {
        return this.annotatedModel;
    }

    public void setAnnotatedModel(AnnotatedModel annotatedModel) {
        this.annotatedModel = annotatedModel;
    }
}

