/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.texo.annotations.AnnotationModelSuffixHandler;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEAttribute;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEClass;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEDataType;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEEnum;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedEReference;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotationsmodelFactory;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.ModelAnnotator;
import org.eclipse.emf.texo.generator.ModelController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationModelGenerator {
    private List<ModelAnnotator> modelAnnotators = null;
    private boolean createOnlyInitialModel = false;
    private AnnotatedModel aModel;

    public void createStoreAnnotationModel(EPackage ePackage, String suffix, EPackage annotationEPackage, IFile modelFile) {
        try {
            Resource resource;
            ResourceSet resourceSet = ePackage.eResource().getResourceSet();
            URI fileUri = URI.createFileURI((String)modelFile.getLocation().toOSString());
            URI fileAnnotationModelUri = AnnotationModelSuffixHandler.createAnnotationsModelURIWithSuffix((URI)fileUri, (String)suffix);
            File file = new File(fileAnnotationModelUri.toFileString());
            if (file.exists()) {
                resource = resourceSet.getResource(fileAnnotationModelUri, true);
            } else {
                resource = resourceSet.createResource(fileAnnotationModelUri);
                String encoding = ((XMLResource)ePackage.eResource()).getEncoding();
                ((XMLResource)resource).setEncoding(encoding);
            }
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof AnnotatedModel) {
                this.aModel = (AnnotatedModel)resource.getContents().get(0);
            } else {
                resource.getContents().clear();
                this.aModel = AnnotationsmodelFactory.eINSTANCE.createAnnotatedModel();
                resource.getContents().add((Object)this.aModel);
            }
            this.fillAnnotatedModel(ePackage);
            if (annotationEPackage != null) {
                this.filterAnnotations(annotationEPackage);
            }
            resource.save(Collections.emptyMap());
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception (" + e.getMessage() + ") for modelFile: " + modelFile.getFullPath().toString() + " epackage " + ePackage.getName() + " epackage uri : " + ePackage.eResource().getURI(), e);
        }
    }

    private void filterAnnotations(EPackage annotationEPackage) {
        TreeIterator iterator = this.aModel.eAllContents();
        ArrayList<EObject> allContents = new ArrayList<EObject>();
        while (iterator.hasNext()) {
            allContents.add((EObject)iterator.next());
        }
        for (Object e : allContents) {
            if (e instanceof AnnotatedEPackage) {
                this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEPackage)e).getEPackageAnnotations(), annotationEPackage);
                continue;
            }
            if (e instanceof AnnotatedEClass) {
                this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEClass)e).getEClassAnnotations(), annotationEPackage);
                continue;
            }
            if (e instanceof AnnotatedEEnum) {
                this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEEnum)e).getEEnumAnnotations(), annotationEPackage);
                continue;
            }
            if (e instanceof AnnotatedEDataType) {
                this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEDataType)e).getEDataTypeAnnotations(), annotationEPackage);
                continue;
            }
            if (e instanceof AnnotatedEAttribute) {
                this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEAttribute)e).getEAttributeAnnotations(), annotationEPackage);
                continue;
            }
            if (!(e instanceof AnnotatedEReference)) continue;
            this.filterAnnotations((List<? extends ENamedElementAnnotation>)((AnnotatedEReference)e).getEReferenceAnnotations(), annotationEPackage);
        }
    }

    private void filterAnnotations(List<? extends ENamedElementAnnotation> annotations, EPackage annotationEPackage) {
        ArrayList<ENamedElementAnnotation> toRemove = new ArrayList<ENamedElementAnnotation>();
        for (ENamedElementAnnotation eNamedElementAnnotation : annotations) {
            if (eNamedElementAnnotation.eClass().getEPackage() == annotationEPackage) continue;
            toRemove.add(eNamedElementAnnotation);
        }
        annotations.removeAll(toRemove);
    }

    public void setModelAnnotators(List<ModelAnnotator> modelAnnotators) {
        this.modelAnnotators = modelAnnotators;
    }

    public void fillAnnotatedModel(EPackage ePackage) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        this.collectEPackages(ePackage, ePackages);
        if (this.modelAnnotators != null && this.modelAnnotators.size() > 0) {
            ModelController modelController = new ModelController();
            modelController.setEPackages(ePackages);
            modelController.getAnnotationManager().setAnnotatedModel(this.aModel);
            modelController.annotate(this.modelAnnotators);
        }
        for (EPackage collectedEPackage : ePackages) {
            AnnotatedEPackage aPackage = this.aModel.getAnnotatedEPackage(collectedEPackage, true);
            if (this.isCreateOnlyInitialModel()) {
                aPackage.getAllAnnotations().clear();
                aPackage.getAnnotatedEClassifiers().clear();
                aPackage.getEPackageAnnotations().clear();
                continue;
            }
            for (EClassifier eClassifier : collectedEPackage.getEClassifiers()) {
                this.aModel.getAnnotatedEClassifier(eClassifier, true);
                if (eClassifier instanceof EClass) {
                    EClass eClass = (EClass)eClassifier;
                    for (EAttribute eAttribute : eClass.getEAttributes()) {
                        this.aModel.getAnnotatedEAttribute(eAttribute, true);
                    }
                    for (EReference eReference : eClass.getEReferences()) {
                        this.aModel.getAnnotatedEReference(eReference, true);
                    }
                    continue;
                }
                if (eClassifier instanceof EEnum) {
                    EEnum eEnum = (EEnum)eClassifier;
                    this.aModel.getAnnotatedEEnum(eEnum, true);
                    for (EEnumLiteral literal : eEnum.getELiterals()) {
                        this.aModel.getAnnotatedEEnumLiteral(literal, true);
                    }
                    continue;
                }
                if (!(eClassifier instanceof EDataType)) continue;
                EDataType eDataType = (EDataType)eClassifier;
                this.aModel.getAnnotatedEDataType(eDataType, true);
            }
        }
        ArrayList<AnnotatedEPackage> toRemove = new ArrayList<AnnotatedEPackage>();
        for (AnnotatedEPackage aPackage : this.aModel.getAnnotatedEPackages()) {
            if (ePackages.contains(aPackage.getEPackage())) continue;
            toRemove.add(aPackage);
        }
        this.aModel.getAnnotatedEPackages().removeAll(toRemove);
    }

    private void collectEPackages(EPackage ePackage, List<EPackage> ePackages) {
        ePackages.add(ePackage);
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            this.collectEPackages(subEPackage, ePackages);
        }
    }

    public boolean isCreateOnlyInitialModel() {
        return this.createOnlyInitialModel;
    }

    public void setCreateOnlyInitialModel(boolean createOnlyInitialModel) {
        this.createOnlyInitialModel = createOnlyInitialModel;
    }
}

