/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.generator.ArtifactGenerator;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.generator.XPandTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTemplate {
    private ArtifactGenerator artifactGenerator;
    private Map<String, String> files = new HashMap<String, String>();

    protected boolean executeOverrides(Object mainObject) {
        for (String override : this.getTemplateOverrides()) {
            if (!this.getArtifactGenerator().getResourceManager().doesCustomTemplateExists(override)) continue;
            this.doExecuteXPandTemplate(override, mainObject);
            return true;
        }
        return false;
    }

    public void addFile(String name, String content) {
        this.files.put(name, content);
    }

    public void addFiles(Map<String, String> newFiles) {
        this.files.putAll(newFiles);
    }

    public void clearFiles() {
        this.files.clear();
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public ModelController getModelController() {
        return this.getArtifactGenerator().getModelController();
    }

    protected List<String> getTemplateOverrides() {
        return Collections.emptyList();
    }

    protected String executeXPandTemplate(String template, Object mainObject) {
        XPandTemplate xpand = (XPandTemplate)ComponentProvider.getInstance().newInstance(XPandTemplate.class);
        xpand.setArtifactGenerator(this.getArtifactGenerator());
        xpand.setMainObject(mainObject);
        xpand.setXPandTemplate(template);
        xpand.generate();
        return xpand.getAllContent();
    }

    protected void doExecuteXPandTemplate(String template, Object mainObject) {
        XPandTemplate xpand = (XPandTemplate)ComponentProvider.getInstance().newInstance(XPandTemplate.class);
        xpand.setArtifactGenerator(this.getArtifactGenerator());
        xpand.setMainObject(mainObject);
        xpand.setXPandTemplate(template);
        xpand.generate();
        this.addFiles(xpand.getFiles());
    }

    public ArtifactGenerator getArtifactGenerator() {
        return this.artifactGenerator;
    }

    public void setArtifactGenerator(ArtifactGenerator artifactGenerator) {
        this.artifactGenerator = artifactGenerator;
    }
}

