/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.Collection;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EObjectToJavaAnnotationConverter {
    public static final String JAVA_ANNOTATABLE_FEATURE = "texo.java.annotatable";
    public static final String JAVA_PACKAGE_EANNOTATION_SOURCE = "texo.java.package";
    public static final String EANNOTATION_KEY = "value";
    private static EObjectToJavaAnnotationConverter instance = new EObjectToJavaAnnotationConverter();

    public static EObjectToJavaAnnotationConverter getInstance() {
        return instance;
    }

    public static void setInstance(EObjectToJavaAnnotationConverter instance) {
        EObjectToJavaAnnotationConverter.instance = instance;
    }

    public String convertItsFeaturesToAnnotations(EObject eObject) {
        StringBuilder sb = new StringBuilder();
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            Object value;
            if (eReference.getEAnnotation(JAVA_ANNOTATABLE_FEATURE) == null || (value = eObject.eGet((EStructuralFeature)eReference)) == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(EObjectToJavaAnnotationConverter.getInstance().convert((EObject)value));
        }
        return sb.toString();
    }

    public String convert(EObject eObject) {
        StringBuilder sb = new StringBuilder();
        sb.append("@" + this.getBasePackage((EModelElement)eObject.eClass()) + "." + eObject.eClass().getName());
        sb.append("(");
        boolean addComma = false;
        for (EStructuralFeature eFeature : eObject.eClass().getEAllStructuralFeatures()) {
            Object value;
            if (eFeature instanceof EReference && !((EReference)eFeature).isContainment() || (value = eObject.eGet(eFeature)) == null) continue;
            if (addComma) {
                sb.append(",");
            }
            sb.append(String.valueOf(eFeature.getName()) + "=");
            if (eFeature.isMany()) {
                sb.append(this.handleMany(eFeature, value));
            } else if (eFeature instanceof EAttribute) {
                sb.append(this.convert((EAttribute)eFeature, value));
            } else {
                sb.append(this.convert((EReference)eFeature, value));
            }
            addComma = true;
        }
        sb.append(")");
        return sb.toString();
    }

    private String getBasePackage(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(JAVA_PACKAGE_EANNOTATION_SOURCE);
        if (eAnnotation == null) {
            return "";
        }
        return (String)eAnnotation.getDetails().get((Object)EANNOTATION_KEY);
    }

    public String handleMany(EStructuralFeature eFeature, Object values) {
        StringBuilder sb = new StringBuilder();
        if (eFeature.isMany()) {
            sb.append("{");
        }
        boolean addComma = false;
        for (Object value : (Collection)values) {
            if (addComma) {
                sb.append(",");
            }
            if (eFeature instanceof EAttribute) {
                sb.append(this.convert((EAttribute)eFeature, value));
            } else {
                sb.append(this.convert((EReference)eFeature, value));
            }
            addComma = true;
        }
        if (eFeature.isMany()) {
            sb.append("}");
        }
        return sb.toString();
    }

    public String convert(EReference eReference, Object value) {
        return this.convert((EObject)value);
    }

    public String convert(EAttribute eAttribute, Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Enumerator) {
            return ((Enumerator)value).getLiteral();
        }
        if (eAttribute.getEAttributeType() == EcorePackage.eINSTANCE.getEJavaClass()) {
            if (value instanceof Class) {
                return String.valueOf(((Class)value).getName()) + ".class";
            }
            return String.valueOf(value.toString()) + ".class";
        }
        return eAttribute.getEType().getEPackage().getEFactoryInstance().convertToString(eAttribute.getEAttributeType(), value);
    }
}

