/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.util.AnnotationsModelRegistry;
import org.eclipse.emf.texo.generator.ModelAnnotator;
import org.eclipse.emf.texo.generator.ModelAnnotatorRegistry;

public class ExtensionPointUtils {
    private static String ANNOTATIONS_MODEL_EXTENSION = "org.eclipse.emf.texo.extensionpoint.annotationmodels";
    private static String MODEL_ANNOTATORS_EXTENSION = "org.eclipse.emf.texo.extensionpoint.modelannotators";
    private static final String ATT_URI = "uri";
    private static final String ATT_CLASS = "class";
    private static boolean readAnnotators = false;

    public static void readAnnotationsModelsFromExtensions() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ANNOTATIONS_MODEL_EXTENSION);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getAttribute(ATT_CLASS) != null) {
                value = extension.getAttribute(ATT_CLASS);
                try {
                    Class javaClass = Platform.getBundle((String)extension.getDeclaringExtension().getContributor().getName()).loadClass(value);
                    Field field = javaClass.getField("eINSTANCE");
                    AnnotationsModelRegistry.getInstance().addAnnotationModel((EPackage)field.get(null));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Extension point has illegal value " + value);
                }
            } else if (extension.getAttribute(ATT_URI) != null) {
                value = extension.getAttribute(ATT_URI);
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(value);
                if (ePackage == null) {
                    throw new IllegalStateException("No EPackage found using extension point uri: " + value);
                }
                AnnotationsModelRegistry.getInstance().addAnnotationModel(ePackage);
            }
            ++n2;
        }
    }

    public static synchronized void readModelAnnotatorsFromExtensions() {
        IConfigurationElement[] config;
        if (readAnnotators) {
            return;
        }
        readAnnotators = true;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(MODEL_ANNOTATORS_EXTENSION);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (extension.getAttribute(ATT_CLASS) != null) {
                try {
                    ModelAnnotator modelAnnotator = (ModelAnnotator)extension.createExecutableExtension(ATT_CLASS);
                    ModelAnnotatorRegistry.getInstance().addModelAnnotator(modelAnnotator);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            ++n2;
        }
    }
}

