/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.texo.generator.ImportReferenceCollector;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportResolver {
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final String JAVA_LANG = "java.lang";
    private static final String DOT = ".";
    private String source;
    private CompilationUnit compilationUnit;
    private IJavaProject javaProject;

    public String resolve() {
        Check.isNotNullArgument((Object)this.source, (String)"source");
        Check.isNotNullArgument((Object)this.javaProject, (String)"javaProject");
        ImportReferenceCollector importReferenceCollector = new ImportReferenceCollector();
        this.compilationUnit.accept((ASTVisitor)importReferenceCollector);
        List<ImportDeclaration> importDeclarations = this.determineCurrentNeededImports(importReferenceCollector.getExistingImports(), importReferenceCollector.getQualifiedTypes());
        List<String> cleanedQualifedNames = this.cleanQualifiedNames(importReferenceCollector.getQualifiedTypes());
        List<String> importedNonQualifiedNames = this.importedNonQualifiedNames(importDeclarations);
        ArrayList<String> namesToImport = new ArrayList<String>();
        for (String declaredTypeName : importReferenceCollector.getUnqualifiedDeclaredTypes()) {
            importedNonQualifiedNames.add(this.getLastSegment(declaredTypeName));
        }
        for (ImportDeclaration importDeclaration : importDeclarations) {
            String nameToImport = importDeclaration.getName().getFullyQualifiedName();
            if (namesToImport.contains(nameToImport)) continue;
            namesToImport.add(nameToImport);
        }
        String packageName = importReferenceCollector.getPackageName();
        Collections.sort(cleanedQualifedNames, new QualifiedNameSorter(packageName));
        for (String qualifiedName : cleanedQualifedNames) {
            Object lastSegment;
            String correctedQualifiedName = this.getCorrectQualifiedName(qualifiedName);
            if (namesToImport.contains(correctedQualifiedName) || !correctedQualifiedName.contains(DOT) || importedNonQualifiedNames.contains(lastSegment = this.getLastSegment(correctedQualifiedName)) || correctedQualifiedName.indexOf(DOT) == correctedQualifiedName.lastIndexOf(DOT)) continue;
            importedNonQualifiedNames.add((String)lastSegment);
            namesToImport.add(correctedQualifiedName);
        }
        AST ast = this.compilationUnit.getAST();
        ArrayList<ImportDeclaration> newImports = new ArrayList<ImportDeclaration>();
        for (String nameToImport : namesToImport) {
            if (this.inPackage(packageName, nameToImport)) continue;
            Name name = ast.newName(nameToImport);
            ImportDeclaration importDeclaration = ast.newImportDeclaration();
            importDeclaration.setOnDemand(false);
            importDeclaration.setStatic(false);
            importDeclaration.setName(name);
            newImports.add(importDeclaration);
        }
        try {
            String newSource = this.updateSource(namesToImport, newImports, ast, importReferenceCollector.getPackageName());
            for (String qualifiedName : cleanedQualifedNames) {
                String[] parts;
                if (!qualifiedName.contains(DOT) || (parts = DOT_PATTERN.split(qualifiedName)).length <= 1) continue;
                String part1 = parts[parts.length - 2];
                String part2 = parts[parts.length - 1];
                String searchString = "\t" + part1 + DOT + part2 + ".initialize();";
                if (newSource.contains(searchString)) {
                    newSource = newSource.replace(searchString, "\t" + qualifiedName + ".initialize();");
                }
                if (newSource.contains(searchString = " " + part1 + DOT + part2 + ".initialize();")) {
                    newSource = newSource.replace(searchString, " " + qualifiedName + ".initialize();");
                }
                if (!newSource.contains(searchString = "\n" + part1 + DOT + part2 + ".initialize();")) continue;
                newSource = newSource.replace(searchString, "\n" + qualifiedName + ".initialize();");
            }
            return newSource;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean inPackage(String packageName, String qualifiedName) {
        int index = qualifiedName.lastIndexOf(DOT);
        if (index == -1) {
            return false;
        }
        String qualifyingPart = qualifiedName.substring(0, index);
        return qualifyingPart.equals(packageName);
    }

    protected String updateSource(List<String> allImportedNames, List<ImportDeclaration> newImports, AST ast, String packageName) throws BadLocationException {
        ASTRewrite astRewriter = ASTRewrite.create((AST)ast);
        ImportChangeCollector changeCollector = new ImportChangeCollector();
        changeCollector.setAst(ast);
        changeCollector.setAstRewriter(astRewriter);
        changeCollector.setImportedNames(allImportedNames);
        changeCollector.setPackageName(packageName);
        this.compilationUnit.accept((ASTVisitor)changeCollector);
        Document doc = new Document(this.source);
        ListRewrite listRewrite = astRewriter.getListRewrite((ASTNode)this.compilationUnit, CompilationUnit.IMPORTS_PROPERTY);
        for (Object obj : this.compilationUnit.imports()) {
            listRewrite.remove((ASTNode)((ImportDeclaration)obj), null);
        }
        List<ImportDeclaration> sortedImports = this.sortImports(newImports);
        for (ImportDeclaration importDeclaration : sortedImports) {
            listRewrite.insertLast((ASTNode)importDeclaration, null);
        }
        TextEdit edits = astRewriter.rewriteAST((IDocument)doc, this.getJavaProject().getOptions(true));
        edits.apply((IDocument)doc);
        return doc.get();
    }

    protected List<ImportDeclaration> sortImports(List<ImportDeclaration> imports) {
        ArrayList<ImportDeclaration> alphabeticSortedImports = new ArrayList<ImportDeclaration>(imports);
        Collections.sort(alphabeticSortedImports, new ImportDeclarationComparator());
        String order = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.importorder", (IJavaProject)this.javaProject);
        if (order.endsWith(";")) {
            order = order.substring(0, order.length() - 1);
        }
        String[] orderedParts = SEMICOLON_PATTERN.split(order, -1);
        ArrayList<ImportDeclaration> sortedImports = new ArrayList<ImportDeclaration>();
        String[] stringArray = orderedParts;
        int n = orderedParts.length;
        int n2 = 0;
        while (n2 < n) {
            String orderPart = stringArray[n2];
            if (orderPart.trim().endsWith("*")) {
                orderPart = orderPart.trim().substring(0, orderPart.trim().length() - 1);
            }
            ArrayList<ImportDeclaration> toRemove = new ArrayList<ImportDeclaration>();
            for (ImportDeclaration importDeclaration : alphabeticSortedImports) {
                if (!importDeclaration.getName().getFullyQualifiedName().startsWith(orderPart)) continue;
                sortedImports.add(importDeclaration);
                toRemove.add(importDeclaration);
            }
            alphabeticSortedImports.removeAll(toRemove);
            ++n2;
        }
        sortedImports.addAll(alphabeticSortedImports);
        return sortedImports;
    }

    private List<String> importedNonQualifiedNames(List<ImportDeclaration> importDeclarations) {
        ArrayList<String> result = new ArrayList<String>();
        for (ImportDeclaration importDeclaration : importDeclarations) {
            if (importDeclaration.isOnDemand() || importDeclaration.isStatic()) continue;
            result.add(this.getLastSegment(importDeclaration.getName().getFullyQualifiedName()));
        }
        return result;
    }

    protected String getCorrectQualifiedName(String qualifiedName) {
        if (!qualifiedName.contains(DOT)) {
            return qualifiedName;
        }
        String[] parts = DOT_PATTERN.split(qualifiedName);
        StringBuilder result = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (result.length() > 0) {
                result.append(DOT);
            }
            result.append(part);
            if (Character.isUpperCase(part.toCharArray()[0])) {
                return result.toString();
            }
            ++n2;
        }
        return result.toString();
    }

    protected String getLastSegment(String qualifiedName) {
        if (qualifiedName.contains(DOT)) {
            String correctedQualifiedName = this.getCorrectQualifiedName(qualifiedName);
            if (correctedQualifiedName.length() == qualifiedName.length()) {
                int index = qualifiedName.lastIndexOf(DOT);
                return qualifiedName.substring(1 + index);
            }
            int index = correctedQualifiedName.lastIndexOf(DOT);
            return qualifiedName.substring(1 + index);
        }
        return qualifiedName;
    }

    protected List<String> cleanQualifiedNames(List<String> qualifiedNames) {
        ArrayList<String> cleanList = new ArrayList<String>();
        for (String qualifiedName : qualifiedNames) {
            if (this.isJavaLangClass(qualifiedName) || !qualifiedName.contains(DOT)) continue;
            cleanList.add(qualifiedName);
        }
        return cleanList;
    }

    private boolean isJavaLangClass(String className) {
        if (!className.startsWith(JAVA_LANG)) {
            return false;
        }
        return !className.substring(1 + JAVA_LANG.length()).contains(DOT);
    }

    protected List<ImportDeclaration> determineCurrentNeededImports(List<ImportDeclaration> currentImports, List<String> qualifiedNames) {
        ArrayList<ImportDeclaration> keepImports = new ArrayList<ImportDeclaration>();
        ArrayList<ImportDeclaration> remainingImports = new ArrayList<ImportDeclaration>(currentImports);
        for (ImportDeclaration importDeclaration : currentImports) {
            if (!importDeclaration.isStatic() && !importDeclaration.isOnDemand()) continue;
            keepImports.add(importDeclaration);
            remainingImports.remove(importDeclaration);
        }
        for (String qualifiedName : qualifiedNames) {
            int index = qualifiedName.indexOf(DOT);
            String checkName = index != -1 ? DOT + qualifiedName.substring(0, index) : DOT + qualifiedName;
            ImportDeclaration foundDeclaration = null;
            for (ImportDeclaration importDeclaration : remainingImports) {
                if (!importDeclaration.getName().getFullyQualifiedName().endsWith(checkName)) continue;
                keepImports.add(importDeclaration);
                foundDeclaration = importDeclaration;
                break;
            }
            if (foundDeclaration == null) continue;
            remainingImports.remove(foundDeclaration);
        }
        return keepImports;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(8);
        parser.setSource(source.toCharArray());
        this.compilationUnit = (CompilationUnit)parser.createAST(null);
        IProblem[] problems = this.compilationUnit.getProblems();
        if (problems != null && problems.length > 0) {
            StringBuilder sb = new StringBuilder();
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                sb.append(String.valueOf(problem.getSourceLineNumber()) + ": " + problem.getMessage() + "\n");
                ++n2;
            }
            throw new IllegalStateException(String.valueOf(source) + "\n" + sb.toString());
        }
        this.source = source;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImportChangeCollector
    extends ASTVisitor {
        private List<String> importedNames;
        private AST ast;
        private ASTRewrite astRewriter;
        private String packageName;

        public ImportChangeCollector() {
            super(true);
        }

        public boolean visit(QualifiedName node) {
            String correctedQualifyingName = ImportResolver.this.getCorrectQualifiedName(node.getFullyQualifiedName());
            if (ImportResolver.this.isJavaLangClass(correctedQualifyingName) || ImportResolver.this.inPackage(this.packageName, correctedQualifyingName) || this.importedNames.contains(correctedQualifyingName)) {
                Name newName = this.ast.newName(ImportResolver.this.getLastSegment(node.getFullyQualifiedName()));
                this.astRewriter.replace((ASTNode)node, (ASTNode)newName, null);
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(ImportDeclaration node) {
            return false;
        }

        public void setImportedNames(List<String> importedNames) {
            this.importedNames = importedNames;
        }

        public void setAst(AST ast) {
            this.ast = ast;
        }

        public void setAstRewriter(ASTRewrite astRewriter) {
            this.astRewriter = astRewriter;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImportDeclarationComparator
    implements Comparator<ImportDeclaration> {
        protected ImportDeclarationComparator() {
        }

        @Override
        public int compare(ImportDeclaration id0, ImportDeclaration id1) {
            return id0.getName().getFullyQualifiedName().compareTo(id1.getName().getFullyQualifiedName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QualifiedNameSorter
    implements Comparator<String> {
        private final String packageName;

        private QualifiedNameSorter(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public int compare(String qName1, String qName2) {
            boolean name2InPackage;
            boolean name1InPackage = ImportResolver.this.inPackage(this.packageName, qName1);
            if (name1InPackage == (name2InPackage = ImportResolver.this.inPackage(this.packageName, qName2))) {
                return 0;
            }
            if (name1InPackage) {
                return -1;
            }
            return 1;
        }
    }
}

