/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;

public abstract class MergingOutputHandler
implements PostProcessor {
    private String projectName;
    private IProgressMonitor monitor;
    private int totalCount = 100;

    public void afterClose(FileHandle impl) {
    }

    public void beforeWriteAndClose(FileHandle fileHandle) {
        String targetLocation = fileHandle.getAbsolutePath();
        if (this.monitor != null) {
            this.monitor.worked(1);
            this.monitor.subTask(targetLocation);
        }
        try {
            boolean doMerge = false;
            String[] stringArray = this.getSupportedExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (targetLocation.endsWith(extension)) {
                    doMerge = true;
                    break;
                }
                ++n2;
            }
            if (doMerge) {
                this.merge(fileHandle);
            }
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while merging and saving source file in merging output handler " + targetLocation + " " + e.getMessage() + " " + e, e);
        }
    }

    protected abstract void merge(FileHandle var1);

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected String[] getSupportedExtensions() {
        return new String[0];
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

