/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.texo.annotations.AnnotationModelSuffixHandler;
import org.eclipse.emf.texo.generator.ExtensionPointUtils;
import org.eclipse.emf.texo.generator.ModelAnnotator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAnnotatorRegistry {
    private static ModelAnnotatorRegistry instance = new ModelAnnotatorRegistry();
    private List<ModelAnnotator> modelAnnotators = new ArrayList<ModelAnnotator>();

    public static ModelAnnotatorRegistry getInstance() {
        return instance;
    }

    public static void setInstance(ModelAnnotatorRegistry instance) {
        ModelAnnotatorRegistry.instance = instance;
    }

    public void addModelAnnotator(ModelAnnotator modelAnnotator) {
        this.modelAnnotators.add(modelAnnotator);
        AnnotationModelSuffixHandler.getInstance().getSuffixes().add(modelAnnotator.getAnnotationModelSuffix());
    }

    public List<ModelAnnotator> getModelAnnotators() {
        if (this.modelAnnotators.isEmpty()) {
            this.modelAnnotators = new ArrayList<ModelAnnotator>();
            ExtensionPointUtils.readModelAnnotatorsFromExtensions();
        }
        return this.modelAnnotators;
    }

    public ModelAnnotator getModelAnnotator(Class<?> modelAnnotatorClass) {
        for (ModelAnnotator modelAnnotator : this.getModelAnnotators()) {
            if (!modelAnnotatorClass.isAssignableFrom(modelAnnotator.getClass())) continue;
            return modelAnnotator;
        }
        throw new IllegalArgumentException("No model annotator for model annotator class: " + modelAnnotatorClass);
    }
}

