/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.texo.generator.MergingOutputHandler;
import org.eclipse.xpand2.output.FileHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMerger
extends MergingOutputHandler {
    @Override
    protected void merge(FileHandle fileHandle) {
        try {
            File targetFile = new File(fileHandle.getAbsolutePath());
            Properties currentProps = new Properties();
            if (targetFile.exists()) {
                FileInputStream is = new FileInputStream(targetFile);
                try {
                    currentProps.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            Properties newProps = new Properties();
            ByteArrayInputStream is = new ByteArrayInputStream(fileHandle.getBuffer().toString().getBytes());
            try {
                newProps.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
            newProps.putAll((Map<?, ?>)currentProps);
            List<PropertyEntry> result = this.convertSort(newProps);
            ArrayList<String> prefixes = new ArrayList<String>();
            String currentPrefix = null;
            for (PropertyEntry pe : result) {
                if (pe.key.indexOf(".") != -1) continue;
                if (currentPrefix == null) {
                    currentPrefix = pe.key;
                    prefixes.add(currentPrefix);
                    continue;
                }
                if (currentPrefix.compareTo(String.valueOf(pe.key) + "s") == 0) continue;
                if (pe.key.endsWith("s")) {
                    String shortPrefix = pe.key.substring(0, pe.key.length() - 1);
                    if (prefixes.contains(shortPrefix)) continue;
                    currentPrefix = pe.key;
                    prefixes.add(currentPrefix);
                    continue;
                }
                currentPrefix = pe.key;
                prefixes.add(currentPrefix);
            }
            StringBuilder newContent = new StringBuilder();
            for (String prefix : prefixes) {
                if (newContent.length() > 0) {
                    newContent.append("\n");
                }
                newContent.append("#\n");
                newContent.append("# " + prefix + "\n");
                newContent.append("#\n");
                for (PropertyEntry pe : result) {
                    if (pe.isWritten() || pe.key.compareTo(prefix) != 0 && pe.key.compareTo(String.valueOf(prefix) + "s") != 0 && !pe.key.startsWith(String.valueOf(prefix) + ".")) continue;
                    newContent.append(String.valueOf(pe.write()) + "\n");
                }
            }
            fileHandle.setBuffer((CharSequence)newContent);
        }
        catch (IllegalStateException c) {
            throw c;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while merging and saving property file " + fileHandle.getAbsolutePath() + " " + e.getMessage() + " " + e, e);
        }
    }

    private List<PropertyEntry> convertSort(Properties props) {
        ArrayList<PropertyEntry> result = new ArrayList<PropertyEntry>();
        for (Object keyObject : props.keySet()) {
            String key = (String)keyObject;
            result.add(new PropertyEntry(key, props.getProperty(key)));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected String[] getSupportedExtensions() {
        return new String[]{".properties"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropertyEntry
    implements Comparable<PropertyEntry> {
        private String key;
        private String value;
        private boolean written = false;

        PropertyEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(PropertyEntry o) {
            return this.key.replaceAll("\\.", "z").compareTo(o.key.replaceAll("\\.", "z"));
        }

        private String write() {
            this.written = true;
            return String.valueOf(this.key) + " = " + this.value;
        }

        public boolean isWritten() {
            return this.written;
        }
    }
}

