/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.json.JSONValueConverter;
import org.eclipse.emf.texo.resolver.DefaultObjectResolver;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJSONModelConverter<T>
implements TexoComponent {
    private Map<String, T> resolvedObjects = new HashMap<String, T>();
    private Map<String, T> newObjects = new HashMap<String, T>();
    private ObjectResolver objectResolver = (ObjectResolver)ComponentProvider.getInstance().newInstance(DefaultObjectResolver.class);
    private JSONValueConverter jsonValueConverter = (JSONValueConverter)ComponentProvider.getInstance().newInstance(this.getValueConversionClass());

    protected Class<?> getValueConversionClass() {
        return JSONValueConverter.class;
    }

    public List<T> convert(JSONArray jsonArray) {
        this.resolvedObjects.clear();
        this.newObjects.clear();
        this.doClearInternalDataStructures();
        return this.doConvert(jsonArray);
    }

    protected List<T> doConvert(JSONArray jsonArray) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            int i = 0;
            while (i < jsonArray.length()) {
                Object o = jsonArray.get(i);
                if (o instanceof JSONArray) {
                    result.addAll(this.convert((JSONArray)o));
                } else if (o instanceof JSONObject) {
                    result.add(this.doConvert((JSONObject)o));
                }
                ++i;
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public T convert(JSONObject jsonObject) {
        this.resolvedObjects.clear();
        this.newObjects.clear();
        this.doClearInternalDataStructures();
        return this.doConvert(jsonObject);
    }

    protected void doClearInternalDataStructures() {
    }

    protected T doConvert(JSONObject source) {
        T target = this.resolveObject(source);
        this.convertContent(source, target);
        return target;
    }

    protected T resolveObject(JSONObject jsonObject) {
        try {
            String uriString = null;
            if (jsonObject.has("_uri")) {
                uriString = jsonObject.getString("_uri");
                if (this.resolvedObjects.containsKey(uriString)) {
                    return this.resolvedObjects.get(uriString);
                }
                T object = this.fromUri(uriString);
                if (object != null) {
                    this.resolvedObjects.put(uriString, object);
                    return object;
                }
            }
            if (jsonObject.has("_eclass")) {
                T object;
                EClass eClass = ModelUtils.getEClassFromQualifiedName((String)jsonObject.getString("_eclass"));
                if (eClass == null) {
                    throw new IllegalArgumentException("No eclass found for jsonObject " + jsonObject);
                }
                if (this.hasValue(jsonObject, "_id")) {
                    if (uriString == null) {
                        String idString = jsonObject.getString("_id");
                        URI uri = this.getObjectResolver().toURI(eClass, idString);
                        uriString = uri.toString();
                    }
                    if (this.resolvedObjects.containsKey(uriString)) {
                        return this.resolvedObjects.get(uriString);
                    }
                    object = this.fromUri(uriString);
                    if (object != null) {
                        this.resolvedObjects.put(uriString, object);
                        return object;
                    }
                }
                object = this.create(eClass, uriString);
                if (uriString != null) {
                    this.resolvedObjects.put(uriString, object);
                    this.newObjects.put(uriString, object);
                }
                return object;
            }
            throw new IllegalArgumentException("No eClass property in jsonObject " + jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isNewObject(String uriString) {
        return this.newObjects.containsKey(uriString);
    }

    protected abstract T fromUri(String var1);

    protected abstract T create(EClass var1, String var2);

    protected abstract EClass eClass(T var1);

    protected abstract void eSet(T var1, EStructuralFeature var2, Object var3);

    protected abstract Object eGet(T var1, EStructuralFeature var2);

    protected abstract Object createFeatureMapEntry(T var1, EStructuralFeature var2, JSONObject var3);

    protected abstract void eRemoveFrom(T var1, EStructuralFeature var2, Object var3);

    protected abstract void eAddTo(T var1, EStructuralFeature var2, Object var3);

    private boolean hasValue(JSONObject jsonObject, String propertyName) throws JSONException {
        if (!jsonObject.has(propertyName)) {
            return false;
        }
        Object id = jsonObject.get(propertyName);
        if (id == null || id == JSONObject.NULL) {
            return false;
        }
        return !(id instanceof String) || ((String)id).trim().length() != 0;
    }

    protected void convertContent(JSONObject source, T target) {
        Iterator keyIterator = source.keys();
        try {
            while (keyIterator.hasNext()) {
                EReference eReference;
                EAttribute eAttribute;
                String key = (String)keyIterator.next();
                Object value = source.get(key);
                EStructuralFeature eStructuralFeature = this.getEFeatureFromPropertyName(this.eClass(target), key);
                if (eStructuralFeature == null || !eStructuralFeature.isChangeable() || eStructuralFeature.isVolatile()) continue;
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                    this.convertFeatureMap(source, value, target, eStructuralFeature);
                    continue;
                }
                if (eStructuralFeature.isMany()) {
                    if (eStructuralFeature instanceof EAttribute) {
                        eAttribute = (EAttribute)eStructuralFeature;
                        this.convertManyEAttribute(source, value, target, eAttribute);
                        continue;
                    }
                    eReference = (EReference)eStructuralFeature;
                    this.convertManyEReference(source, value, target, eReference);
                    continue;
                }
                if (eStructuralFeature instanceof EAttribute) {
                    eAttribute = (EAttribute)eStructuralFeature;
                    this.convertSingleEAttribute(source, value, target, eAttribute);
                    continue;
                }
                eReference = (EReference)eStructuralFeature;
                this.convertSingleEReference(source, value, target, eReference);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected EStructuralFeature getEFeatureFromPropertyName(EClass eClass, String propertyName) {
        return eClass.getEStructuralFeature(propertyName);
    }

    protected void convertSingleEReference(JSONObject jsonObject, Object value, T target, EReference eReference) {
        if (eReference.getEOpposite() != null && eReference.getEOpposite().isMany()) {
            return;
        }
        if (value == null || value == JSONObject.NULL) {
            this.eSet(target, (EStructuralFeature)eReference, null);
        } else {
            JSONObject jsonValue = (JSONObject)value;
            this.addEClassProperty((EStructuralFeature)eReference, jsonValue);
            this.eSet(target, (EStructuralFeature)eReference, this.doConvert((JSONObject)value));
        }
    }

    protected void convertManyEReference(JSONObject source, Object featureValue, T target, EReference eReference) {
        JSONArray jValues = (JSONArray)featureValue;
        if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
            EClass mapEClass = eReference.getEReferenceType();
            EObject mapEntryEObject = EcoreUtil.create((EClass)mapEClass);
            EStructuralFeature valueFeature = mapEntryEObject.eClass().getEStructuralFeature("value");
            EStructuralFeature keyFeature = mapEntryEObject.eClass().getEStructuralFeature("key");
            Object mValues = this.eGet(target, (EStructuralFeature)eReference);
            if (mValues instanceof Map) {
                ((Map)mValues).clear();
            } else {
                ((Collection)mValues).clear();
            }
            try {
                int i = 0;
                while (i < jValues.length()) {
                    if (!jValues.isNull(i)) {
                        Object value;
                        Object key;
                        JSONObject jValue = jValues.getJSONObject(i);
                        Object jEntryKey = jValue.get("key");
                        Object jEntryValue = jValue.get("value");
                        if (jEntryKey instanceof JSONObject) {
                            this.addEClassProperty(keyFeature, (JSONObject)jEntryKey);
                            key = this.doConvert((JSONObject)jEntryKey);
                        } else {
                            key = this.jsonValueConverter.fromJSON(target, jEntryKey, ((EAttribute)keyFeature).getEAttributeType());
                        }
                        if (jEntryValue instanceof JSONObject) {
                            this.addEClassProperty(valueFeature, (JSONObject)jEntryValue);
                            value = this.doConvert((JSONObject)jEntryValue);
                        } else {
                            value = this.jsonValueConverter.fromJSON(target, jEntryValue, ((EAttribute)valueFeature).getEAttributeType());
                        }
                        if (mValues instanceof Map) {
                            ((Map)mValues).put(key, value);
                        } else {
                            EObject mapEObject = EcoreUtil.create((EClass)mapEClass);
                            mapEObject.eSet(keyFeature, key);
                            mapEObject.eSet(valueFeature, value);
                            ((Collection)mValues).add(mapEObject);
                        }
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        Collection mValues = (Collection)this.eGet(target, (EStructuralFeature)eReference);
        for (Object o : new ArrayList(mValues)) {
            this.eRemoveFrom(target, (EStructuralFeature)eReference, o);
        }
        int i = 0;
        while (i < jValues.length()) {
            if (jValues.isNull(i)) {
                mValues.add(null);
            } else {
                try {
                    if (jValues.isNull(i) || jValues.get(i) == null) {
                        this.eAddTo(target, (EStructuralFeature)eReference, null);
                    } else if (jValues.get(i) instanceof JSONArray) {
                        JSONArray objects = (JSONArray)jValues.get(i);
                        Object[] array = new Object[objects.length()];
                        int j = 0;
                        while (j < objects.length()) {
                            Object object = objects.get(j);
                            array[j] = object instanceof JSONObject ? this.doConvert((JSONObject)object) : object;
                            ++j;
                        }
                        this.eAddTo(target, (EStructuralFeature)eReference, array);
                    } else {
                        Object otherSide;
                        JSONObject jValue = jValues.getJSONObject(i);
                        this.addEClassProperty((EStructuralFeature)eReference, jValue);
                        T mValue = this.doConvert(jValue);
                        this.eAddTo(target, (EStructuralFeature)eReference, mValue);
                        if (this.setBidirectionalReferences() && eReference.getEOpposite() != null && !eReference.getEOpposite().isMany() && (otherSide = this.eGet(mValue, (EStructuralFeature)eReference.getEOpposite())) != target) {
                            this.eSet(mValue, (EStructuralFeature)eReference.getEOpposite(), target);
                        }
                    }
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
    }

    protected boolean setBidirectionalReferences() {
        return false;
    }

    private void addEClassProperty(EStructuralFeature eFeature, JSONObject value) {
        if (eFeature instanceof EAttribute) {
            return;
        }
        EReference eReference = (EReference)eFeature;
        if (!value.has("_uri") && !value.has("_eclass")) {
            String eClassUri = ModelUtils.getQualifiedNameFromEClass((EClass)eReference.getEReferenceType());
            try {
                value.put("_eclass", (Object)eClassUri);
            }
            catch (JSONException e) {
                throw new Error(e);
            }
        }
    }

    protected void convertSingleEAttribute(JSONObject jsonObject, Object value, T target, EAttribute eAttribute) {
        this.eSet(target, (EStructuralFeature)eAttribute, this.jsonValueConverter.fromJSON(target, value, eAttribute.getEAttributeType()));
    }

    protected void convertFeatureMap(JSONObject jsonObject, Object value, T target, EStructuralFeature eFeature) {
        JSONArray jValues = (JSONArray)value;
        Collection values = (Collection)this.eGet(target, eFeature);
        values.clear();
        try {
            int i = 0;
            while (i < jValues.length()) {
                JSONObject jValue = jValues.getJSONObject(i);
                values.add(this.createFeatureMapEntry(target, eFeature, jValue));
                ++i;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void convertManyEAttribute(JSONObject source, Object value, T target, EAttribute eAttribute) {
        JSONArray jValues = (JSONArray)value;
        EDataType eDataType = eAttribute.getEAttributeType();
        Collection values = (Collection)this.eGet(target, (EStructuralFeature)eAttribute);
        for (Object val : new ArrayList(values)) {
            this.eRemoveFrom(target, (EStructuralFeature)eAttribute, val);
        }
        try {
            int i = 0;
            while (i < jValues.length()) {
                values.add(this.jsonValueConverter.fromJSON(target, jValues.get(i), eDataType));
                ++i;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public ObjectResolver getUriResolver() {
        return this.getObjectResolver();
    }

    public void setObjectResolver(ObjectResolver uriResolver) {
        this.objectResolver = uriResolver;
    }

    public Map<String, T> getResolvedObjects() {
        return this.resolvedObjects;
    }

    public void setResolvedObjects(Map<String, T> resolvedObjects) {
        this.resolvedObjects = resolvedObjects;
    }

    protected JSONValueConverter getJSONValueConverter() {
        return this.jsonValueConverter;
    }
}

