/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.converter.BaseModelConverter;
import org.eclipse.emf.texo.json.JSONValueConverter;
import org.eclipse.emf.texo.model.DynamicModelObject;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.provider.TitleProvider;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModelJSONConverter<T>
extends BaseModelConverter<T>
implements TexoComponent {
    private final HashSet<T> hasConverted = new HashSet();
    private JSONValueConverter jsonValueConverter = (JSONValueConverter)ComponentProvider.getInstance().newInstance(this.getValueConversionClass());
    private boolean preSortManyValues = false;
    private boolean serializeTitleProperty = true;

    public Object convert(T object) {
        this.doBaseActions(Collections.singletonList(object));
        this.hasConverted.clear();
        return this.doConvert(object);
    }

    protected Class<?> getValueConversionClass() {
        return JSONValueConverter.class;
    }

    protected Object doConvert(T object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            try {
                JSONArray jsonArray = new JSONArray();
                int i = 0;
                while (i < Array.getLength(object)) {
                    Object value = Array.get(object, i);
                    if (this.isModelEnabled(value)) {
                        jsonArray.put(i, this.doConvert(value));
                    } else if (value instanceof Date) {
                        jsonArray.put(i, (Object)this.jsonValueConverter.convertDateTimeToJSON(value));
                    } else {
                        jsonArray.put(i, value);
                    }
                    ++i;
                }
                return jsonArray;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        if (object instanceof Collection) {
            try {
                JSONArray jsonArray = new JSONArray();
                Collection collection = (Collection)object;
                int i = 0;
                for (Object value : collection) {
                    if (this.isModelEnabled(value)) {
                        jsonArray.put(i, this.doConvert(value));
                    } else if (value instanceof Date) {
                        jsonArray.put(i, (Object)this.jsonValueConverter.convertDateTimeToJSON(value));
                    } else {
                        jsonArray.put(i, value);
                    }
                    ++i;
                }
                return jsonArray;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hasConverted.contains(object)) {
            if (!this.getProxyObjects().contains(object)) {
                this.getProxyObjects().add(object);
                this.getNonProxiedObjects().remove(object);
            }
        } else {
            this.hasConverted.add(object);
        }
        JSONObject target = this.createJSONObject(object);
        this.convertContent(object, target);
        return target;
    }

    protected JSONObject createJSONObject(T source) {
        JSONObject jsonObject = new JSONObject();
        this.setObjectProperties(source, jsonObject);
        this.setProxyProperties(source, jsonObject);
        return jsonObject;
    }

    protected void convertContent(T source, JSONObject target) {
        if (this.getProxyObjects().contains(source)) {
            return;
        }
        for (EStructuralFeature eStructuralFeature : this.eClass(source).getEAllStructuralFeatures()) {
            EReference eReference;
            EAttribute eAttribute;
            if (this.isSkipVolatileEFeatures() && eStructuralFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                this.convertFeatureMap(source, target, eStructuralFeature);
                continue;
            }
            if (eStructuralFeature.isMany()) {
                if (eStructuralFeature instanceof EAttribute) {
                    eAttribute = (EAttribute)eStructuralFeature;
                    this.convertManyEAttribute(source, target, eAttribute);
                    continue;
                }
                eReference = (EReference)eStructuralFeature;
                this.convertManyEReference(source, target, eReference);
                continue;
            }
            if (eStructuralFeature instanceof EAttribute) {
                eAttribute = (EAttribute)eStructuralFeature;
                this.convertSingleEAttribute(source, target, eAttribute);
                continue;
            }
            eReference = (EReference)eStructuralFeature;
            this.convertSingleEReference(source, target, eReference);
        }
    }

    protected void setProxyProperties(T object, JSONObject jsonObject) {
        try {
            if (!this.isModelEnabled(object)) {
                return;
            }
            URI uri = this.getProxyId(object);
            if (uri != null) {
                if (this.getProxyObjects().contains(object)) {
                    jsonObject.put("_proxy", true);
                }
                jsonObject.put("_uri", (Object)uri.toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setObjectProperties(T object, JSONObject jsonObject) {
        try {
            String idAsString;
            if (!this.isModelEnabled(object) && object.getClass() != DynamicModelObject.class) {
                return;
            }
            if (IdProvider.getInstance().hasIdEAttribute(this.eClass(object)) && (idAsString = IdProvider.getInstance().getIdAsString(object)) != null && idAsString.trim().length() > 0) {
                EAttribute idEAttribute = IdProvider.getInstance().getIdEAttribute(this.eClass(object));
                jsonObject.put("_id", (Object)idAsString);
                jsonObject.put(this.getJSONPropertyName((EStructuralFeature)idEAttribute), this.jsonValueConverter.toJSON(object, this.eGet(object, (EStructuralFeature)idEAttribute), idEAttribute.getEAttributeType()));
            }
            if (this.isSerializeTitleProperty()) {
                jsonObject.put("_title", (Object)TitleProvider.getInstance().getTitle(object));
            }
            jsonObject.put("_eclass", (Object)ModelUtils.getQualifiedNameFromEClass((EClass)this.eClass(object)));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void convertFeatureMap(T source, JSONObject target, EStructuralFeature eFeature) {
        try {
            Collection mValues = (Collection)this.eGet(source, eFeature);
            ArrayList<JSONObject> values = new ArrayList<JSONObject>();
            for (Object mValue : mValues) {
                EStructuralFeature entryFeature = this.getFeatureMapFeature(eFeature, mValue);
                Object entryValue = this.getFeatureMapValue(eFeature, mValue);
                Object convertedValue = entryFeature instanceof EAttribute ? this.jsonValueConverter.toJSON(source, entryValue, ((EAttribute)entryFeature).getEAttributeType()) : this.doConvert(entryValue);
                JSONObject featureMapJSON = new JSONObject();
                featureMapJSON.put("value", convertedValue);
                featureMapJSON.put("_efeature", (Object)ModelUtils.getQualifiedNameFromEStructuralFeature((EStructuralFeature)entryFeature));
                featureMapJSON.put("key", (Object)entryFeature.getName());
                values.add(featureMapJSON);
            }
            target.put(this.getJSONPropertyName(eFeature), (Object)new JSONArray(values));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract EStructuralFeature getFeatureMapFeature(EStructuralFeature var1, Object var2);

    protected abstract Object getFeatureMapValue(EStructuralFeature var1, Object var2);

    protected void convertSingleEReference(T source, JSONObject target, EReference eReference) {
        try {
            String jsonPropName = this.getJSONPropertyName((EStructuralFeature)eReference);
            if (target.has(jsonPropName)) {
                return;
            }
            Object value = this.eGet(source, (EStructuralFeature)eReference);
            if (value == null) {
                target.put(jsonPropName, JSONObject.NULL);
            } else {
                Object object = this.doConvert(value);
                target.put(jsonPropName, object);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getJSONPropertyName(EStructuralFeature eFeature) {
        return eFeature.getName();
    }

    protected void convertManyEReference(T source, JSONObject target, EReference eReference) {
        try {
            String jsonPropName = this.getJSONPropertyName((EStructuralFeature)eReference);
            if (target.has(jsonPropName)) {
                return;
            }
            Object manyValue = this.eGet(source, (EStructuralFeature)eReference);
            if (Map.class.isAssignableFrom(manyValue.getClass())) {
                Check.isTrue((boolean)ModelUtils.isEMap((EStructuralFeature)eReference), (String)("Expected emap EReference, but the case for EReference " + eReference));
                ArrayList<JSONObject> values = new ArrayList<JSONObject>();
                Map map = (Map)manyValue;
                EObject mapEntryEObject = EcoreUtil.create((EClass)eReference.getEReferenceType());
                EStructuralFeature valueFeature = mapEntryEObject.eClass().getEStructuralFeature("value");
                EStructuralFeature keyFeature = mapEntryEObject.eClass().getEStructuralFeature("key");
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    JSONObject entry = new JSONObject();
                    if (this.isModelEnabled(value)) {
                        entry.put("value", this.doConvert(value));
                    } else {
                        entry.put("value", this.jsonValueConverter.toJSON(source, value, ((EAttribute)valueFeature).getEAttributeType()));
                    }
                    if (this.isModelEnabled(key)) {
                        entry.put("key", this.doConvert(key));
                    } else {
                        entry.put("key", this.jsonValueConverter.toJSON(source, key, ((EAttribute)keyFeature).getEAttributeType()));
                    }
                    values.add(entry);
                }
                target.put(this.getJSONPropertyName((EStructuralFeature)eReference), values);
            } else if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
                ArrayList<JSONObject> values = new ArrayList<JSONObject>();
                Collection eMap = (Collection)manyValue;
                EObject mapEntryEObject = EcoreUtil.create((EClass)eReference.getEReferenceType());
                EStructuralFeature valueFeature = mapEntryEObject.eClass().getEStructuralFeature("value");
                EStructuralFeature keyFeature = mapEntryEObject.eClass().getEStructuralFeature("key");
                for (Object e : eMap) {
                    Map.Entry mEntry = (Map.Entry)e;
                    Object key = mEntry.getKey();
                    Object value = mEntry.getValue();
                    JSONObject entry = new JSONObject();
                    if (this.isModelEnabled(value)) {
                        entry.put("value", this.doConvert(value));
                    } else {
                        entry.put("value", this.jsonValueConverter.toJSON(source, value, ((EAttribute)valueFeature).getEAttributeType()));
                    }
                    if (this.isModelEnabled(key)) {
                        entry.put("key", this.doConvert(key));
                    } else {
                        entry.put("key", this.jsonValueConverter.toJSON(source, key, ((EAttribute)keyFeature).getEAttributeType()));
                    }
                    values.add(entry);
                }
                target.put(this.getJSONPropertyName((EStructuralFeature)eReference), values);
            } else {
                Collection sourceValues = (Collection)manyValue;
                ArrayList<Object> targetValues = new ArrayList<Object>();
                for (T value : this.sortedValues(sourceValues)) {
                    if (value == null) {
                        targetValues.add(JSONObject.NULL);
                        continue;
                    }
                    targetValues.add(this.doConvert(value));
                }
                target.put(this.getJSONPropertyName((EStructuralFeature)eReference), targetValues);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<T> sortedValues(Collection<T> values) {
        if (!this.preSortManyValues) {
            return values;
        }
        ArrayList<T> sortedValues = new ArrayList<T>(values);
        Collections.sort(sortedValues, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                try {
                    if (IdProvider.getInstance().hasIdEAttribute(o1) && IdProvider.getInstance().hasIdEAttribute(o2)) {
                        Object id1 = IdProvider.getInstance().getId(o1);
                        Object id2 = IdProvider.getInstance().getId(o2);
                        if (id1 != null && id2 != null) {
                            return id1.toString().compareTo(id2.toString());
                        }
                    }
                    return o1.toString().compareTo(o2.toString());
                }
                catch (UnsupportedOperationException e) {
                    return o1.hashCode() - o2.hashCode();
                }
            }
        });
        return sortedValues;
    }

    private Collection<?> sortedEAttributeValues(Collection<?> values) {
        if (!this.preSortManyValues) {
            return values;
        }
        ArrayList sortedValues = new ArrayList(values);
        Collections.sort(sortedValues, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof Date) {
                    long t2;
                    long t1 = ((Date)o1).getTime();
                    if (t1 < (t2 = ((Date)o2).getTime())) {
                        return -1;
                    }
                    if (t1 > t2) {
                        return 1;
                    }
                    return 0;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        return sortedValues;
    }

    protected void convertSingleEAttribute(T source, JSONObject target, EAttribute eAttribute) {
        try {
            Object value = this.eGet(source, (EStructuralFeature)eAttribute);
            String propName = this.getJSONPropertyName((EStructuralFeature)eAttribute);
            target.put(propName, this.jsonValueConverter.toJSON(source, value, eAttribute.getEAttributeType()));
            if (value instanceof BigDecimal) {
                target.put(String.valueOf(propName) + "_text", (Object)value.toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void convertManyEAttribute(T source, JSONObject target, EAttribute eAttribute) {
        try {
            Collection values = (Collection)this.eGet(source, (EStructuralFeature)eAttribute);
            EDataType eDataType = eAttribute.getEAttributeType();
            ArrayList<Object> targetValues = new ArrayList<Object>();
            boolean bigDecimalsPresent = false;
            for (Object value : this.sortedEAttributeValues(values)) {
                bigDecimalsPresent |= value instanceof BigDecimal;
                targetValues.add(this.jsonValueConverter.toJSON(source, value, eDataType));
            }
            target.put(this.getJSONPropertyName((EStructuralFeature)eAttribute), targetValues);
            if (bigDecimalsPresent) {
                ArrayList<String> bdValues = new ArrayList<String>();
                for (Object value : this.sortedEAttributeValues(values)) {
                    bigDecimalsPresent |= value instanceof BigDecimal;
                    if (value == null) {
                        bdValues.add("");
                        continue;
                    }
                    bdValues.add(value.toString());
                }
                target.put(String.valueOf(this.getJSONPropertyName((EStructuralFeature)eAttribute)) + "_text", bdValues);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPreSortManyValues() {
        return this.preSortManyValues;
    }

    public void setPreSortManyValues(boolean preSortManyValues) {
        this.preSortManyValues = preSortManyValues;
    }

    public boolean isSerializeTitleProperty() {
        return this.serializeTitleProperty;
    }

    public void setSerializeTitleProperty(boolean serializeTitleProperty) {
        this.serializeTitleProperty = serializeTitleProperty;
    }
}

