/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.json.BaseJSONModelConverter;
import org.eclipse.emf.texo.json.JSONEMFValueConverter;
import org.eclipse.emf.texo.resolver.DefaultObjectResolver;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONEMFConverter
extends BaseJSONModelConverter<EObject> {
    private Set<EObject> nonProxiedObjects = new HashSet<EObject>();

    @Override
    protected void doClearInternalDataStructures() {
        this.nonProxiedObjects.clear();
    }

    @Override
    protected void convertContent(JSONObject source, EObject target) {
        boolean deliver = target.eDeliver();
        ((InternalEObject)target).eSetDeliver(false);
        try {
            try {
                if (source.has("_proxy") && source.getBoolean("_proxy") && !this.nonProxiedObjects.contains(target)) {
                    String proxyUri = source.getString("_uri");
                    if (this.isNewObject(proxyUri)) {
                        URI uri = ModelUtils.convertToEMFURI((URI)URI.createURI((String)proxyUri));
                        ((InternalEObject)target).eSetProxyURI(uri);
                    }
                } else {
                    this.nonProxiedObjects.add(target);
                    ((InternalEObject)target).eSetProxyURI(null);
                }
                super.convertContent(source, target);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ((InternalEObject)target).eSetDeliver(deliver);
        }
    }

    @Override
    protected Class<?> getValueConversionClass() {
        return JSONEMFValueConverter.class;
    }

    @Override
    protected EObject fromUri(String uriString) {
        return this.getObjectResolver().getEObject(URI.createURI((String)uriString));
    }

    @Override
    protected EObject create(EClass eClass, String uriString) {
        DefaultObjectResolver resolver = (DefaultObjectResolver)this.getObjectResolver();
        EObject eObject = EcoreUtil.create((EClass)eClass);
        resolver.addToCache(uriString, eObject);
        return eObject;
    }

    @Override
    protected EClass eClass(EObject target) {
        return target.eClass();
    }

    @Override
    protected void eSet(EObject target, EStructuralFeature eFeature, Object value) {
        boolean deliver = target.eDeliver();
        ((InternalEObject)target).eSetDeliver(false);
        boolean deliverValue = false;
        if (value instanceof InternalEObject) {
            deliverValue = ((InternalEObject)value).eDeliver();
            ((InternalEObject)value).eSetDeliver(false);
        }
        try {
            target.eSet(eFeature, value);
        }
        finally {
            ((InternalEObject)target).eSetDeliver(deliver);
            if (value instanceof InternalEObject) {
                ((InternalEObject)value).eSetDeliver(deliverValue);
            }
        }
    }

    @Override
    protected Object eGet(EObject target, EStructuralFeature eFeature) {
        return target.eGet(eFeature);
    }

    @Override
    protected Object createFeatureMapEntry(EObject target, EStructuralFeature eFeature, JSONObject jValue) {
        try {
            EStructuralFeature entryFeature = ModelUtils.getEStructuralFeatureFromQualifiedName((String)jValue.getString("_efeature"));
            Object convertedValue = entryFeature instanceof EAttribute ? this.getJSONValueConverter().fromJSON(target, jValue.get("value"), ((EAttribute)entryFeature).getEAttributeType()) : this.doConvert(jValue.getJSONObject("value"));
            return FeatureMapUtil.createEntry((EStructuralFeature)entryFeature, convertedValue);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void eRemoveFrom(EObject target, EStructuralFeature eFeature, Object value) {
        boolean deliver = target.eDeliver();
        ((InternalEObject)target).eSetDeliver(false);
        boolean deliverValue = false;
        if (value instanceof InternalEObject) {
            deliverValue = ((InternalEObject)value).eDeliver();
            ((InternalEObject)value).eSetDeliver(false);
        }
        try {
            ((Collection)target.eGet(eFeature)).remove(value);
        }
        finally {
            ((InternalEObject)target).eSetDeliver(deliver);
            if (value instanceof InternalEObject) {
                ((InternalEObject)value).eSetDeliver(deliverValue);
            }
        }
    }

    @Override
    protected void eAddTo(EObject target, EStructuralFeature eFeature, Object value) {
        boolean deliver = target.eDeliver();
        ((InternalEObject)target).eSetDeliver(false);
        boolean deliverValue = false;
        if (value instanceof InternalEObject) {
            deliverValue = ((InternalEObject)value).eDeliver();
            ((InternalEObject)value).eSetDeliver(false);
        }
        try {
            ((Collection)target.eGet(eFeature)).add(value);
        }
        finally {
            ((InternalEObject)target).eSetDeliver(deliver);
            if (value instanceof InternalEObject) {
                ((InternalEObject)value).eSetDeliver(deliverValue);
            }
        }
    }
}

