/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

public class JSONValueConverter
implements TexoComponent {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ssZZZZZ");
    private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZZ");

    protected Object toJSON(Object source, Object value, EDataType eDataType) {
        if (value instanceof EEnumLiteral) {
            return ((EEnumLiteral)value).getName();
        }
        if (source instanceof EObject && ModelUtils.isEEnum((EDataType)eDataType)) {
            return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (this.usePlainDate()) {
            if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDate()) {
                return this.convertDateToJSON(value);
            }
            if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
                return this.convertDateTimeToJSON(value);
            }
            if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getTime()) {
                return this.convertTimeToJSON(value);
            }
        }
        if (value instanceof Date) {
            return this.convertDateTimeToJSON(value);
        }
        if (eDataType.getEPackage() == XMLTypePackage.eINSTANCE) {
            return XMLTypeFactory.eINSTANCE.convertToString(eDataType, value);
        }
        return value;
    }

    protected boolean usePlainDate() {
        return true;
    }

    public String convertDateToJSON(Object value) {
        return this.dateFormat.format((Date)value);
    }

    public String convertDateTimeToJSON(Object value) {
        return this.dateTimeFormat.format((Date)value);
    }

    public String convertTimeToJSON(Object value) {
        return this.timeFormat.format((Date)value);
    }

    protected Object fromJSON(Object target, Object value, EDataType eDataType) {
        if (ModelUtils.isEEnum((EDataType)eDataType)) {
            EDataType enumDataType = this.getDataTypeOrBaseType(eDataType);
            EEnum eeNum = (EEnum)enumDataType;
            if (!(value instanceof String)) {
                return value;
            }
            if (target instanceof EObject) {
                for (EEnumLiteral eeNumLiteral : eeNum.getELiterals()) {
                    if (eeNumLiteral.getName().compareToIgnoreCase((String)value) != 0 && eeNumLiteral.getLiteral().compareToIgnoreCase((String)value) != 0) continue;
                    return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, eeNumLiteral.getLiteral());
                }
                return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, (String)value);
            }
            ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(enumDataType.getEPackage().getNsURI());
            if (modelPackage == null) {
                EEnumLiteral literal = eeNum.getEEnumLiteral((String)value);
                if (literal == null) {
                    literal = eeNum.getEEnumLiteralByLiteral((String)value);
                }
                return literal;
            }
            Class enumClass = modelPackage.getEClassifierClass((EClassifier)enumDataType);
            return Enum.valueOf(enumClass, ((String)value).toUpperCase());
        }
        if (this.usePlainDate()) {
            if (eDataType == XMLTypePackage.eINSTANCE.getDate()) {
                return this.createDateFromJSON(value);
            }
            if (eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
                return this.createDateTimeFromJSON(value);
            }
            if (eDataType == XMLTypePackage.eINSTANCE.getTime()) {
                return this.createTimeFromJSON(value);
            }
        }
        if (eDataType.getInstanceClass() != null && Date.class.isAssignableFrom(eDataType.getInstanceClass())) {
            return this.createDateTimeFromJSON(value);
        }
        if (value instanceof Integer) {
            if (eDataType.getInstanceClass() == Long.TYPE || eDataType.getInstanceClass() == Long.class) {
                return ((Integer)value).longValue();
            }
            if (eDataType.getInstanceClass() == Byte.TYPE || eDataType.getInstanceClass() == Byte.class) {
                return ((Integer)value).byteValue();
            }
            if (eDataType.getInstanceClass() == Short.TYPE || eDataType.getInstanceClass() == Short.class) {
                return ((Integer)value).shortValue();
            }
            if (eDataType.getInstanceClass() == Double.TYPE || eDataType.getInstanceClass() == Double.class) {
                return ((Integer)value).doubleValue();
            }
            if (eDataType.getInstanceClass() == Float.TYPE || eDataType.getInstanceClass() == Float.class) {
                return Float.valueOf(((Integer)value).floatValue());
            }
        }
        if (value instanceof String && eDataType.getEPackage() == XMLTypePackage.eINSTANCE) {
            return XMLTypeFactory.eINSTANCE.createFromString(eDataType, (String)value);
        }
        return value;
    }

    public Date createDateTimeFromJSON(Object value) {
        try {
            return this.dateTimeFormat.parse((String)value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date createDateFromJSON(Object value) {
        try {
            return this.dateFormat.parse((String)value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date createTimeFromJSON(Object value) {
        try {
            return this.timeFormat.parse((String)value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private EDataType getDataTypeOrBaseType(EDataType eDataType) {
        EEnum baseType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType);
        if (baseType != null) {
            return baseType;
        }
        return eDataType;
    }
}

