/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEStructuralFeatureAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EAttributeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotationDefinition;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEAttributeAnnotator
extends ModelEStructuralFeatureAnnotator
implements Annotator<EAttributeModelGenAnnotation> {
    public void postAnnotating(EAttributeModelGenAnnotation annotation) {
        super.postAnnotating(annotation);
    }

    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation();
    }

    public void setAnnotationFeatures(EAttributeModelGenAnnotation annotation) {
        Check.isNotNull((Object)annotation.getEAttribute(), (String)"eAttribute must be set");
        super.annotate(annotation);
        EAttribute eAttribute = annotation.getEAttribute();
        if (!annotation.isSetBoolean()) {
            annotation.setBoolean(this.isBooleanType((EStructuralFeature)eAttribute));
        }
        if (!annotation.isSetPrimitive()) {
            annotation.setPrimitive(this.isPrimitiveType((EStructuralFeature)eAttribute));
        }
        if (!annotation.isSetReference()) {
            annotation.setReference(false);
        }
    }

    private boolean isBooleanType(EStructuralFeature eFeature) {
        return this.isPrimitiveType(eFeature) && (this.getInstanceClass(eFeature) == Boolean.TYPE || this.getInstanceClass(eFeature) == Boolean.class);
    }

    private boolean isPrimitiveType(EStructuralFeature eFeature) {
        if (eFeature.isMany() || this.getInstanceClass(eFeature) == null) {
            return false;
        }
        return this.getInstanceClass(eFeature).isPrimitive();
    }

    @Override
    protected String getGetter(EStructuralFeature eFeature) {
        if (this.isBooleanType(eFeature)) {
            return "is" + ModelUtils.upCaseFirst((String)this.getName((ENamedElement)eFeature));
        }
        return super.getGetter(eFeature);
    }

    private boolean isManyInstanceClass(EStructuralFeature eFeature) {
        Class<?> localInstanceClass = this.getInstanceClass(eFeature);
        if (localInstanceClass == null) {
            return false;
        }
        return localInstanceClass.isArray() || Collection.class.isAssignableFrom(localInstanceClass);
    }

    @Override
    protected String getType(EStructuralFeature eFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        if (eFeature.isMany()) {
            if (genAnnotation.isUseList()) {
                return String.valueOf(List.class.getName()) + "<" + this.getItemType(eFeature) + ">";
            }
            return String.valueOf(Set.class.getName()) + "<" + this.getItemType(eFeature) + ">";
        }
        if (this.isManyInstanceClass(eFeature)) {
            Class<?> localInstanceClass = this.getInstanceClass(eFeature);
            if (localInstanceClass == null) {
                return this.getInstanceClassName(eFeature);
            }
            if (localInstanceClass.isArray()) {
                return String.valueOf(localInstanceClass.getComponentType().getName()) + "[]";
            }
            EDataType eDataType = ((EAttribute)eFeature).getEAttributeType();
            EDataTypeModelGenAnnotationDefinition eDataTypeAnnotation = this.getEDataTypeModelGenAnnotation(eDataType);
            return String.valueOf(eDataTypeAnnotation.getInstanceClassName()) + "<" + eDataTypeAnnotation.getItemType() + ">";
        }
        Class<?> clz = this.getInstanceClass(eFeature);
        if (clz != null) {
            return clz.getName();
        }
        return this.getInstanceClassName(eFeature);
    }

    @Override
    protected String getObjectType(EStructuralFeature eStructuralFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        if (this.getType(eStructuralFeature, genAnnotation).contains(".")) {
            return GenUtils.correctTypeDef(this.getType(eStructuralFeature, genAnnotation));
        }
        EDataType eDataType = ((EAttribute)eStructuralFeature).getEAttributeType();
        EDataTypeModelGenAnnotationDefinition annotation = this.getEDataTypeModelGenAnnotation(eDataType);
        return GenUtils.correctTypeDef(annotation.getObjectClassName());
    }

    @Override
    protected String getItemType(EStructuralFeature eFeature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
            return GenUtils.correctTypeDef(this.getFeatureMapQualifiedClassName(eFeature));
        }
        EAttribute eAttribute = (EAttribute)eFeature;
        EDataType eDataType = eAttribute.getEAttributeType();
        EDataTypeModelGenAnnotationDefinition annotation = this.getEDataTypeModelGenAnnotation(eDataType);
        return GenUtils.correctTypeDef(annotation.getObjectClassName());
    }

    @Override
    protected boolean isMany(EStructuralFeature eFeature) {
        return eFeature.isMany();
    }

    @Override
    protected String getDefaultValue(EStructuralFeature eFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        block6: {
            block7: {
                if (eFeature.isMany()) {
                    if (genAnnotation.isUseList()) {
                        return "new " + ArrayList.class.getName() + "<" + this.getItemType(eFeature) + ">()";
                    }
                    return "new " + HashSet.class.getName() + "<" + this.getItemType(eFeature) + ">()";
                }
                try {
                    if (!ModelUtils.isUnsettable((EStructuralFeature)eFeature)) break block6;
                    if (!(eFeature.getEType() instanceof EEnum)) break block7;
                    return "null";
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    throw new Error(t);
                }
            }
            Class<?> clz = this.getInstanceClass(eFeature);
            if (clz == null || clz.isPrimitive()) break block6;
            return "null";
        }
        return GenUtils.getStaticDefaultValue(this.getAnnotationManager(), ((EAttribute)eFeature).getEAttributeType(), eFeature.getDefaultValueLiteral());
    }

    private Class<?> getInstanceClass(EStructuralFeature eFeature) {
        Check.isTrue((!FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature) && !eFeature.isMany() ? 1 : 0) != 0, (String)("The EStructuralFeature " + eFeature + " is a featuremap, this method should not be called"));
        EDataType eDataType = ((EAttribute)eFeature).getEAttributeType();
        EDataTypeModelGenAnnotationDefinition annotation = this.getEDataTypeModelGenAnnotation(eDataType);
        Class<?> clz = this.getClassForName(eDataType, annotation.getInstanceClassName());
        if (ModelUtils.isUnsettable((EStructuralFeature)eFeature) && clz != null && clz.isPrimitive()) {
            return GenUtils.getObjectClass(clz);
        }
        return clz;
    }
}

