/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.Locale;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEClassifierAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEEnumAnnotator
extends ModelEClassifierAnnotator
implements Annotator<EEnumModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation();
    }

    public void setAnnotationFeatures(EEnumModelGenAnnotation annotation) {
        super.annotate(annotation);
        Check.isNotNull((Object)annotation.getEDataType(), (String)"eDataType must be set");
        EDataType eDataType = annotation.getEDataType();
        if (!annotation.isSetEnum()) {
            annotation.setEnum(eDataType instanceof EEnum);
        }
        if (GenUtils.useInstanceClassNames(eDataType.getEPackage()) && !GeneratorUtils.isEmptyOrNull((String)eDataType.getInstanceClassName())) {
            annotation.setQualifiedClassName(eDataType.getInstanceClassName());
            annotation.setGenerateCode(false);
            int dotIndex = eDataType.getInstanceClassName().lastIndexOf(".");
            if (dotIndex == -1) {
                annotation.setSimpleClassName(eDataType.getInstanceClassName());
            } else {
                annotation.setSimpleClassName(eDataType.getInstanceClassName().substring(dotIndex + 1));
            }
        } else {
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName())) {
                if (!GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName())) {
                    int index = annotation.getQualifiedClassName().lastIndexOf(".");
                    if (index == -1) {
                        annotation.setSimpleClassName(annotation.getQualifiedClassName());
                    } else {
                        annotation.setSimpleClassName(annotation.getQualifiedClassName().substring(1 + index));
                    }
                } else {
                    annotation.setSimpleClassName(this.getSimpleClassName((EClassifier)eDataType));
                }
            }
            if (GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName())) {
                annotation.setQualifiedClassName(this.getQualifiedClassName(annotation.getEClassifier(), annotation.getSimpleClassName()));
            }
        }
        annotation.setDateType(false);
        annotation.setItemType(Object.class.getName());
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getObjectClassName())) {
            annotation.setObjectClassName(annotation.getQualifiedClassName());
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getInstanceClassName())) {
            annotation.setInstanceClassName(annotation.getQualifiedClassName());
        }
        if (!annotation.isSetGenerateCode()) {
            annotation.setGenerateCode(true);
        }
        if (!annotation.isSetAutomaticStringConversion()) {
            annotation.setAutomaticStringConversion(false);
        }
        EPackageModelGenAnnotation ePackageAnnotation = this.getEPackageModelGenAnnotation(eDataType.getEPackage());
        annotation.setOwnerEPackageAnnotation(ePackageAnnotation);
    }

    public void postAnnotating(EEnumModelGenAnnotation annotation) {
    }

    protected String getInstanceClassNameForEnum(EEnum eEnum) {
        EPackageModelGenAnnotation annotation = this.getEPackageModelGenAnnotation(eEnum.getEPackage());
        String qualifiedClassName = String.valueOf(annotation.getPackagePath().toLowerCase(Locale.ENGLISH)) + "." + this.getSimpleClassName((EClassifier)eEnum);
        return qualifiedClassName;
    }
}

