/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EAttributeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotationDefinition;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ENamedElementModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EReferenceModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelENamedElementAnnotator {
    private AnnotationManager annotationManager;
    private Map<String, Class<?>> instanceClassCache = new HashMap();

    protected Class<?> getClassForName(EDataType eDataType, String name) {
        String cachedName = String.valueOf(eDataType.getEPackage().getNsURI()) + eDataType.getName() + "___" + name;
        Class<?> result = this.instanceClassCache.get(cachedName);
        if (result != null) {
            if (result == NULLIndicator.class) {
                return null;
            }
            return result;
        }
        result = GenUtils.getClassForName(eDataType, name);
        if (result == null) {
            this.instanceClassCache.put(cachedName, NULLIndicator.class);
        } else {
            this.instanceClassCache.put(cachedName, result);
        }
        return result;
    }

    protected void annotate(ENamedElementModelGenAnnotation annotation) {
        Check.isTrue((boolean)this.getAnnotationEClass().isSuperTypeOf(annotation.eClass()), (String)("Invalid annotation eclass " + annotation + " for this annotator " + this));
        Check.isNotNull((Object)annotation.getENamedElement(), (String)"eNamedElement must be set");
        if (annotation.getDocumentation() == null) {
            annotation.setDocumentation(EcoreUtil.getDocumentation((EModelElement)annotation.getENamedElement()));
        }
        annotation.setName(this.getName(annotation.getENamedElement()));
    }

    public abstract EClass getAnnotationEClass();

    protected String getName(ENamedElement namedElement) {
        return namedElement.getName();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }

    protected EPackageModelGenAnnotation getEPackageModelGenAnnotation(EPackage ePackage) {
        return (EPackageModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)ePackage, ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation());
    }

    protected EPackageModelGenAnnotation getEPackageModelGenAnnotation(EPackage ePackage, boolean initialized) {
        return (EPackageModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)ePackage, ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation(), initialized);
    }

    protected EClassModelGenAnnotation getEClassModelGenAnnotation(EClass eClass) {
        return (EClassModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eClass, ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation());
    }

    protected EStructuralFeatureModelGenAnnotation getEStructuralFeatureModelGenAnnotation(EStructuralFeature eFeature) {
        if (eFeature instanceof EReference) {
            return this.getEReferenceModelGenAnnotation((EReference)eFeature);
        }
        return this.getEAttributeModelGenAnnotation((EAttribute)eFeature);
    }

    protected EReferenceModelGenAnnotation getEReferenceModelGenAnnotation(EReference eReference) {
        return (EReferenceModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
    }

    protected EAttributeModelGenAnnotation getEAttributeModelGenAnnotation(EAttribute eAttribute) {
        return (EAttributeModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
    }

    protected EDataTypeModelGenAnnotationDefinition getEDataTypeModelGenAnnotation(EDataType eDataType) {
        if (eDataType == null) {
            throw new IllegalStateException("The EDataType of one of the model elements in your model is not set, it is null");
        }
        if (eDataType instanceof EEnum) {
            return this.getEEnumModelGenAnnotation((EEnum)eDataType);
        }
        return (EDataTypeModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eDataType, ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation());
    }

    protected EEnumModelGenAnnotation getEEnumModelGenAnnotation(EEnum eEnum) {
        return (EEnumModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eEnum, ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation());
    }

    private static class NULLIndicator {
        private NULLIndicator() {
        }
    }
}

