/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelENamedElementAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassifierModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEPackageAnnotator
extends ModelENamedElementAnnotator
implements Annotator<EPackageModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation();
    }

    public void setAnnotationFeatures(EPackageModelGenAnnotation annotation) {
        String packagePath;
        int lastIndex;
        EPackage ePackage = annotation.getEPackage();
        this.reorderEClassifiers(ePackage);
        super.annotate(annotation);
        Check.isNotNull((Object)annotation.getEPackage(), (String)"ePackage must be set");
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getPackagePath())) {
            if (GeneratorUtils.isNotEmptyAndNotNull((String)annotation.getQualifiedClassName())) {
                lastIndex = annotation.getQualifiedClassName().lastIndexOf(".");
                packagePath = annotation.getQualifiedClassName().substring(0, lastIndex);
            } else {
                packagePath = GenUtils.createJavaPackagePath(ePackage.getNsURI());
            }
            annotation.setPackagePath(packagePath);
        } else {
            packagePath = annotation.getPackagePath();
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getDaoClassesPackagePath())) {
            String patternName = "dao";
            if (!GeneratorUtils.isEmptyOrNull((String)annotation.getDaoPatternName())) {
                patternName = annotation.getDaoPatternName();
            }
            String daoPackagePath = String.valueOf(packagePath) + "." + patternName;
            annotation.setDaoClassesPackagePath(daoPackagePath);
        }
        if (ePackage.getESuperPackage() != null) {
            annotation.setHandleEcoreFile(false);
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getDaoRootClass())) {
            annotation.setDaoRootClass("org.eclipse.emf.texo.server.store.BaseDao");
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getModelClassesPackagePath())) {
            annotation.setModelClassesPackagePath(packagePath);
        }
        if (!GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName())) {
            annotation.setQualifiedClassName(String.valueOf(annotation.getModelClassesPackagePath()) + "." + annotation.getSimpleClassName());
        } else if (GeneratorUtils.isEmptyOrNull((String)annotation.getQualifiedClassName())) {
            String simpleName = GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName()) ? this.getSimpleClassName(ePackage) : annotation.getSimpleClassName();
            annotation.setQualifiedClassName(String.valueOf(annotation.getModelClassesPackagePath()) + "." + simpleName + annotation.getModelPackageClassNamePostFix());
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleClassName())) {
            lastIndex = annotation.getQualifiedClassName().lastIndexOf(".");
            annotation.setSimpleClassName(annotation.getQualifiedClassName().substring(1 + lastIndex));
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getSimpleModelFactoryClassName())) {
            annotation.setSimpleModelFactoryClassName(String.valueOf(this.getSimpleClassName(ePackage)) + annotation.getModelFactoryClassNamePostFix());
        }
        if (GeneratorUtils.isEmptyOrNull((String)annotation.getEcoreFileName())) {
            annotation.setEcoreFileName(String.valueOf(ePackage.getName()) + ".ecore");
        }
        List<EPackageModelGenAnnotation> dependsOn = this.getDependsOn(ePackage);
        if (annotation.getDependsOn().isEmpty()) {
            annotation.getDependsOn().addAll(dependsOn);
        }
        ArrayList<EPackage> subEPackages = new ArrayList<EPackage>();
        this.collectAllSubEPackages(ePackage, subEPackages);
        for (EPackage subEPackage : subEPackages) {
            EPackageModelGenAnnotation genAnnotation = this.getEPackageModelGenAnnotation(subEPackage, false);
            annotation.getSubPackageModelGens().add((Object)genAnnotation);
        }
    }

    public void postAnnotating(EPackageModelGenAnnotation annotation) {
        EPackage ePackage = annotation.getEPackage();
        if (annotation.getEClassifierModelGenAnnotations().isEmpty()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClassifierModelGenAnnotation eClassifierAnnotation;
                if (eClassifier instanceof EClass) {
                    eClassifierAnnotation = (EClassModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation());
                    annotation.getEClassifierModelGenAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                if (eClassifier instanceof EEnum) {
                    eClassifierAnnotation = (EEnumModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation());
                    annotation.getEClassifierModelGenAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                if (eClassifier instanceof EDataType) {
                    eClassifierAnnotation = (EDataTypeModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation());
                    annotation.getEClassifierModelGenAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                throw new IllegalStateException("Not supported here " + eClassifier);
            }
        }
        annotation.setEcoreFileContent(this.getEcoreFileContent(ePackage, this.getAllDependsOn(annotation)));
    }

    private String getSimpleClassName(EPackage ePackage) {
        return ModelUtils.upCaseFirst((String)this.getName((ENamedElement)ePackage));
    }

    private void reorderEClassifiers(EPackage ePackage) {
        boolean reorderNeeded = false;
        boolean encounteredEDataType = false;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (eClassifier instanceof EDataType) {
                encounteredEDataType = true;
                continue;
            }
            if (!encounteredEDataType) continue;
            reorderNeeded = true;
            break;
        }
        if (!reorderNeeded) {
            return;
        }
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            ((EClassifierImpl)eClassifier).setClassifierID(-1);
            if (!(eClassifier instanceof EClass)) continue;
            eClasses.add((EClass)eClassifier);
        }
        for (EPackage eSubPackage : ePackage.getESubpackages()) {
            this.reorderEClassifiers(eSubPackage);
        }
        ePackage.getEClassifiers().removeAll(eClasses);
        ePackage.getEClassifiers().addAll(0, eClasses);
    }

    private List<EPackageModelGenAnnotation> getDependsOn(EPackage ePackage) {
        ArrayList<EPackage> epacks = new ArrayList<EPackage>();
        if (ePackage.getESuperPackage() != null && !epacks.contains(ePackage.getESuperPackage())) {
            epacks.add(ePackage.getESuperPackage());
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EPackage refEPackage;
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EClass superEClass : eClass.getESuperTypes()) {
                if (superEClass.getEPackage() == ePackage || epacks.contains(superEClass.getEPackage())) continue;
                Check.isNotNull((Object)superEClass.getEPackage(), (String)("The epackage of the eclass " + superEClass + " is not set, it is the superEClass of " + eClass + ". This indicates that the super EClass is " + "not loaded correctly, for example the file with " + "the EPackage can not be found"));
                epacks.add(superEClass.getEPackage());
            }
            for (EReference eref : eClass.getEReferences()) {
                refEPackage = eref.getEReferenceType().getEPackage();
                if (refEPackage == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
            for (EAttribute eattr : eClass.getEAttributes()) {
                if (eattr.getEType() == null || (refEPackage = eattr.getEType().getEPackage()) == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
        }
        ArrayList<EPackageModelGenAnnotation> dependsOn = new ArrayList<EPackageModelGenAnnotation>();
        for (EPackage depEPackage : epacks) {
            if (depEPackage == EcorePackage.eINSTANCE || depEPackage == XMLTypePackage.eINSTANCE) continue;
            dependsOn.add(this.getEPackageModelGenAnnotation(depEPackage, false));
        }
        return dependsOn;
    }

    protected boolean isDescendant(EPackage currentEPackage, EPackage descendantPackage) {
        if (currentEPackage == descendantPackage) {
            return true;
        }
        if (descendantPackage.getESuperPackage() != null) {
            return this.isDescendant(currentEPackage, descendantPackage.getESuperPackage());
        }
        return false;
    }

    protected void collectAllSubEPackages(EPackage ePackage, List<EPackage> subEPackages) {
        for (EPackage eSubPackage : ePackage.getESubpackages()) {
            subEPackages.add(eSubPackage);
            this.collectAllSubEPackages(eSubPackage, subEPackages);
        }
    }

    private List<EPackageModelGenAnnotation> getAllDependsOn(EPackageModelGenAnnotation annotation) {
        List<EPackageModelGenAnnotation> dependsOn = this.getDependsOn(annotation.getEPackage());
        ArrayList<EPackage> subPackages = new ArrayList<EPackage>();
        this.collectAllSubEPackages(annotation.getEPackage(), subPackages);
        for (EPackage ePackage : subPackages) {
            List<EPackageModelGenAnnotation> subDependsOns = this.getDependsOn(ePackage);
            for (EPackageModelGenAnnotation subDepends : subDependsOns) {
                if (dependsOn.contains(subDepends) || this.isDescendant(annotation.getEPackage(), subDepends.getEPackage())) continue;
                dependsOn.add(subDepends);
            }
        }
        return dependsOn;
    }

    /*
     * Unable to fully structure code
     */
    public String getEcoreFileContent(EPackage ePackage, List<EPackageModelGenAnnotation> dependsOn) {
        previousURI = new HashMap<Object, URI>();
        try {
            dependsOnEcorePackage = false;
            dependsOnXMLTypePackage = false;
            for (EPackageModelGenAnnotation dependsOnAnnotation : dependsOn) {
                if (dependsOnAnnotation.getEPackage() == ePackage) continue;
                localEPackage = dependsOnAnnotation.getEPackage();
                dependsOnEcorePackage |= localEPackage == EcorePackage.eINSTANCE;
                dependsOnXMLTypePackage |= localEPackage == XMLTypePackage.eINSTANCE;
                res = this.setEPackageResource(localEPackage);
                previousURI.put(res, res.getURI());
                res.setURI(URI.createURI((String)localEPackage.getNsURI()));
            }
            if (!dependsOnEcorePackage) {
                res = this.setEPackageResource((EPackage)EcorePackage.eINSTANCE);
                previousURI.put(res, res.getURI());
            }
            if (!dependsOnXMLTypePackage) {
                res = this.setEPackageResource((EPackage)XMLTypePackage.eINSTANCE);
                previousURI.put(res, res.getURI());
            }
            ecoreResourceFactory = new EcoreResourceFactoryImpl();
            if (ePackage.eResource() == null) {
                outputRes = (XMLResource)ecoreResourceFactory.createResource(URI.createURI((String)""));
                previousURI.put(outputRes, URI.createURI((String)ePackage.getNsURI()));
                outputRes.getContents().add((Object)ePackage);
            } else {
                outputRes = (XMLResource)ePackage.eResource();
            }
            sw = new StringWriter();
            outputRes.save((Writer)sw, Collections.EMPTY_MAP);
            var11_11 = sw.toString();
            return var11_11;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            ** for (res : previousURI.keySet())
        }
lbl-1000:
        // 1 sources

        {
            res.setURI((URI)previousURI.get(res));
            continue;
        }
lbl42:
        // 1 sources

        throw var10_16;
    }

    private Resource setEPackageResource(EPackage ePackage) {
        Resource res = ePackage.eResource();
        if (res == null) {
            res = new XMIResourceImpl();
            res.getContents().add((Object)ePackage);
        }
        return res;
    }

    @Override
    public String getName(ENamedElement namedElement) {
        String name = super.getName(namedElement);
        if (name.indexOf(".") != -1) {
            return name.substring(1 + name.lastIndexOf("."));
        }
        return name;
    }
}

