/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelEStructuralFeatureAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EReferenceModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEReferenceAnnotator
extends ModelEStructuralFeatureAnnotator
implements Annotator<EReferenceModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation();
    }

    public void setAnnotationFeatures(EReferenceModelGenAnnotation annotation) {
        Check.isNotNull((Object)annotation.getEReference(), (String)"eReference must be set");
        super.annotate(annotation);
        if (!annotation.isSetReference()) {
            annotation.setReference(true);
        }
    }

    public void postAnnotating(EReferenceModelGenAnnotation annotation) {
        boolean doBidirectionalHandling;
        super.postAnnotating(annotation);
        boolean saveManyAccess = !ModelUtils.isEMap((EStructuralFeature)annotation.getEStructuralFeature()) && this.getEPackageModelGenAnnotation(annotation.getEReference().getEContainingClass().getEPackage()).isGenerateSafeManyAccess();
        boolean bl = doBidirectionalHandling = !ModelUtils.isEMap((EStructuralFeature)annotation.getEStructuralFeature()) && this.getEPackageModelGenAnnotation(annotation.getEReference().getEContainingClass().getEPackage()).isGenerateBidirectionalAssociationSupport();
        if (!annotation.isSetGenerateSafeManyAccess()) {
            annotation.setGenerateSafeManyAccess(saveManyAccess);
        }
        if (!annotation.isSetGenerateBidirectionalAssociationSupport()) {
            annotation.setGenerateBidirectionalAssociationSupport(doBidirectionalHandling);
        }
        if (saveManyAccess && annotation.getEReference().getEOpposite() != null && annotation.getOppositeModelGenAnnotation() == null) {
            EReferenceModelGenAnnotation oppositeAnnotation = this.getEReferenceModelGenAnnotation(annotation.getEReference().getEOpposite());
            annotation.setOppositeModelGenAnnotation(oppositeAnnotation);
            oppositeAnnotation.setOppositeModelGenAnnotation(annotation);
        }
    }

    @Override
    protected String getType(EStructuralFeature eFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        EReference eReference = (EReference)eFeature;
        if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
            return String.valueOf(Map.class.getName()) + "<" + this.getItemType((EStructuralFeature)eReference) + ">";
        }
        if (eReference.isMany()) {
            if (genAnnotation.isUseList()) {
                return String.valueOf(List.class.getName()) + "<" + this.getItemType((EStructuralFeature)eReference) + ">";
            }
            return String.valueOf(Set.class.getName()) + "<" + this.getItemType((EStructuralFeature)eReference) + ">";
        }
        if (eReference.getEReferenceType() == EcorePackage.eINSTANCE.getEObject()) {
            return Object.class.getName();
        }
        return this.getEClassModelGenAnnotation(eReference.getEReferenceType()).getQualifiedClassName();
    }

    @Override
    protected String getItemType(EStructuralFeature eFeature) {
        EReference eReference = (EReference)eFeature;
        if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
            return this.getMapKeyValueTypes(eReference);
        }
        if (eReference.getEReferenceType() == EcorePackage.eINSTANCE.getEObject()) {
            return Object.class.getName();
        }
        return this.getEClassModelGenAnnotation(eReference.getEReferenceType()).getQualifiedClassName();
    }

    @Override
    protected String getDefaultValue(EStructuralFeature eFeature, EStructuralFeatureModelGenAnnotation genAnnotation) {
        EReference eReference = (EReference)eFeature;
        if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
            if (genAnnotation.isUseList()) {
                return "new " + LinkedHashMap.class.getName() + "<" + this.getItemType((EStructuralFeature)eReference) + ">()";
            }
            return "new " + HashMap.class.getName() + "<" + this.getItemType((EStructuralFeature)eReference) + ">()";
        }
        if (eReference.isMany()) {
            if (genAnnotation.isUseList()) {
                return "new " + ArrayList.class.getName() + "<" + this.getItemType((EStructuralFeature)eReference) + ">()";
            }
            return "new " + HashSet.class.getName() + "<" + this.getItemType((EStructuralFeature)eReference) + ">()";
        }
        return "null";
    }

    private String getMapKeyValueTypes(EReference eReference) {
        EClass mapType = eReference.getEReferenceType();
        String valueClass = this.getInstanceTypeFromEStructuralFeature(mapType.getEStructuralFeature("value"));
        String keyClass = this.getInstanceTypeFromEStructuralFeature(mapType.getEStructuralFeature("key"));
        return String.valueOf(keyClass) + ", " + valueClass;
    }

    private String getInstanceTypeFromEStructuralFeature(EStructuralFeature eStructuralFeature) {
        EStructuralFeatureModelGenAnnotation annotation = this.getEStructuralFeatureModelGenAnnotation(eStructuralFeature);
        return annotation.getType();
    }
}

