/**
 * <copyright>
 * </copyright>
 *
 * $Id: OrmItemProviderAdapterFactory.java,v 1.4 2011/08/25 15:03:10 mtaal Exp $
 */
package org.eclipse.emf.texo.orm.annotations.model.orm.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.texo.orm.annotations.model.orm.util.OrmAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class OrmItemProviderAdapterFactory extends OrmAdapterFactory implements ComposeableAdapterFactory,
    IChangeNotifier, IDisposable {
  /**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public OrmItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.AccessMethods} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected AccessMethodsItemProvider accessMethodsItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.AccessMethods}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createAccessMethodsAdapter() {
    if (accessMethodsItemProvider == null) {
      accessMethodsItemProvider = new AccessMethodsItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return accessMethodsItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.AdditionalCriteria} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdditionalCriteriaItemProvider additionalCriteriaItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.AdditionalCriteria}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdditionalCriteriaAdapter() {
		if (additionalCriteriaItemProvider == null) {
			additionalCriteriaItemProvider = new AdditionalCriteriaItemProvider(this);
		}

		return additionalCriteriaItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Array} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayItemProvider arrayItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Array}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayAdapter() {
		if (arrayItemProvider == null) {
			arrayItemProvider = new ArrayItemProvider(this);
		}

		return arrayItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.AssociationOverride} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected AssociationOverrideItemProvider associationOverrideItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.AssociationOverride}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createAssociationOverrideAdapter() {
    if (associationOverrideItemProvider == null) {
      associationOverrideItemProvider = new AssociationOverrideItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return associationOverrideItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.AttributeOverride} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected AttributeOverrideItemProvider attributeOverrideItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.AttributeOverride}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createAttributeOverrideAdapter() {
    if (attributeOverrideItemProvider == null) {
      attributeOverrideItemProvider = new AttributeOverrideItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return attributeOverrideItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Attributes} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected AttributesItemProvider attributesItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Attributes}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createAttributesAdapter() {
    if (attributesItemProvider == null) {
      attributesItemProvider = new AttributesItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return attributesItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Basic} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected BasicItemProvider basicItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Basic}. <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createBasicAdapter() {
    if (basicItemProvider == null) {
      basicItemProvider = new BasicItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return basicItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.BasicCollection} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected BasicCollectionItemProvider basicCollectionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.BasicCollection}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createBasicCollectionAdapter() {
    if (basicCollectionItemProvider == null) {
      basicCollectionItemProvider = new BasicCollectionItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return basicCollectionItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.BasicMap} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected BasicMapItemProvider basicMapItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.BasicMap}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createBasicMapAdapter() {
    if (basicMapItemProvider == null) {
      basicMapItemProvider = new BasicMapItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return basicMapItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.BatchFetch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BatchFetchItemProvider batchFetchItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.BatchFetch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBatchFetchAdapter() {
		if (batchFetchItemProvider == null) {
			batchFetchItemProvider = new BatchFetchItemProvider(this);
		}

		return batchFetchItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Cache} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected CacheItemProvider cacheItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Cache}. <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCacheAdapter() {
    if (cacheItemProvider == null) {
      cacheItemProvider = new CacheItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return cacheItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.CacheInterceptor} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected CacheInterceptorItemProvider cacheInterceptorItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.CacheInterceptor}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCacheInterceptorAdapter() {
    if (cacheInterceptorItemProvider == null) {
      cacheInterceptorItemProvider = new CacheInterceptorItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return cacheInterceptorItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.CascadeType} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected CascadeTypeItemProvider cascadeTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.CascadeType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCascadeTypeAdapter() {
    if (cascadeTypeItemProvider == null) {
      cascadeTypeItemProvider = new CascadeTypeItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return cascadeTypeItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ChangeTracking} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ChangeTrackingItemProvider changeTrackingItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ChangeTracking}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createChangeTrackingAdapter() {
    if (changeTrackingItemProvider == null) {
      changeTrackingItemProvider = new ChangeTrackingItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return changeTrackingItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ClassExtractor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassExtractorItemProvider classExtractorItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ClassExtractor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassExtractorAdapter() {
		if (classExtractorItemProvider == null) {
			classExtractorItemProvider = new ClassExtractorItemProvider(this);
		}

		return classExtractorItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.CloneCopyPolicy} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected CloneCopyPolicyItemProvider cloneCopyPolicyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.CloneCopyPolicy}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCloneCopyPolicyAdapter() {
    if (cloneCopyPolicyItemProvider == null) {
      cloneCopyPolicyItemProvider = new CloneCopyPolicyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return cloneCopyPolicyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.CollectionTable} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected CollectionTableItemProvider collectionTableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.CollectionTable}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCollectionTableAdapter() {
    if (collectionTableItemProvider == null) {
      collectionTableItemProvider = new CollectionTableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return collectionTableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Column} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected ColumnItemProvider columnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Column}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createColumnAdapter() {
    if (columnItemProvider == null) {
      columnItemProvider = new ColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return columnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ColumnResult} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ColumnResultItemProvider columnResultItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ColumnResult}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createColumnResultAdapter() {
    if (columnResultItemProvider == null) {
      columnResultItemProvider = new ColumnResultItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return columnResultItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ConversionValue} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ConversionValueItemProvider conversionValueItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ConversionValue}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createConversionValueAdapter() {
    if (conversionValueItemProvider == null) {
      conversionValueItemProvider = new ConversionValueItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return conversionValueItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Converter} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected ConverterItemProvider converterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Converter}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createConverterAdapter() {
    if (converterItemProvider == null) {
      converterItemProvider = new ConverterItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return converterItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.CopyPolicy} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected CopyPolicyItemProvider copyPolicyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.CopyPolicy}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCopyPolicyAdapter() {
    if (copyPolicyItemProvider == null) {
      copyPolicyItemProvider = new CopyPolicyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return copyPolicyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Customizer} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected CustomizerItemProvider customizerItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Customizer}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createCustomizerAdapter() {
    if (customizerItemProvider == null) {
      customizerItemProvider = new CustomizerItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return customizerItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorClass} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected DiscriminatorClassItemProvider discriminatorClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorClass}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createDiscriminatorClassAdapter() {
    if (discriminatorClassItemProvider == null) {
      discriminatorClassItemProvider = new DiscriminatorClassItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return discriminatorClassItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorColumn} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected DiscriminatorColumnItemProvider discriminatorColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createDiscriminatorColumnAdapter() {
    if (discriminatorColumnItemProvider == null) {
      discriminatorColumnItemProvider = new DiscriminatorColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return discriminatorColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.DocumentRoot} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected DocumentRootItemProvider documentRootItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.DocumentRoot}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createDocumentRootAdapter() {
    if (documentRootItemProvider == null) {
      documentRootItemProvider = new DocumentRootItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return documentRootItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EclipselinkCollectionTable} instances.
	 * <!-- begin-user-doc
   * --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EclipselinkCollectionTableItemProvider eclipselinkCollectionTableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EclipselinkCollectionTable}.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEclipselinkCollectionTableAdapter() {
    if (eclipselinkCollectionTableItemProvider == null) {
      eclipselinkCollectionTableItemProvider = new EclipselinkCollectionTableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return eclipselinkCollectionTableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ElementCollection} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ElementCollectionItemProvider elementCollectionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ElementCollection}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createElementCollectionAdapter() {
    if (elementCollectionItemProvider == null) {
      elementCollectionItemProvider = new ElementCollectionItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return elementCollectionItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Embeddable} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EmbeddableItemProvider embeddableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Embeddable}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEmbeddableAdapter() {
    if (embeddableItemProvider == null) {
      embeddableItemProvider = new EmbeddableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return embeddableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Embedded} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EmbeddedItemProvider embeddedItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Embedded}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEmbeddedAdapter() {
    if (embeddedItemProvider == null) {
      embeddedItemProvider = new EmbeddedItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return embeddedItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EmbeddedId} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EmbeddedIdItemProvider embeddedIdItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EmbeddedId}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEmbeddedIdAdapter() {
    if (embeddedIdItemProvider == null) {
      embeddedIdItemProvider = new EmbeddedIdItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return embeddedIdItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EmptyType} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EmptyTypeItemProvider emptyTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EmptyType}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEmptyTypeAdapter() {
    if (emptyTypeItemProvider == null) {
      emptyTypeItemProvider = new EmptyTypeItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return emptyTypeItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Entity} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected EntityItemProvider entityItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Entity}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEntityAdapter() {
    if (entityItemProvider == null) {
      entityItemProvider = new EntityItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return entityItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityListener} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected EntityListenerItemProvider entityListenerItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityListener}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEntityListenerAdapter() {
    if (entityListenerItemProvider == null) {
      entityListenerItemProvider = new EntityListenerItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return entityListenerItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityListeners} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected EntityListenersItemProvider entityListenersItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityListeners}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEntityListenersAdapter() {
    if (entityListenersItemProvider == null) {
      entityListenersItemProvider = new EntityListenersItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return entityListenersItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityMappingsType} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected EntityMappingsTypeItemProvider entityMappingsTypeItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityMappingsType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEntityMappingsTypeAdapter() {
    if (entityMappingsTypeItemProvider == null) {
      entityMappingsTypeItemProvider = new EntityMappingsTypeItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return entityMappingsTypeItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityResult} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected EntityResultItemProvider entityResultItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.EntityResult}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createEntityResultAdapter() {
    if (entityResultItemProvider == null) {
      entityResultItemProvider = new EntityResultItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return entityResultItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.FetchAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FetchAttributeItemProvider fetchAttributeItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.FetchAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFetchAttributeAdapter() {
		if (fetchAttributeItemProvider == null) {
			fetchAttributeItemProvider = new FetchAttributeItemProvider(this);
		}

		return fetchAttributeItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.FetchGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FetchGroupItemProvider fetchGroupItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.FetchGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFetchGroupAdapter() {
		if (fetchGroupItemProvider == null) {
			fetchGroupItemProvider = new FetchGroupItemProvider(this);
		}

		return fetchGroupItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.FieldResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected FieldResultItemProvider fieldResultItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.FieldResult}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createFieldResultAdapter() {
    if (fieldResultItemProvider == null) {
      fieldResultItemProvider = new FieldResultItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return fieldResultItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.GeneratedValue} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected GeneratedValueItemProvider generatedValueItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.GeneratedValue}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createGeneratedValueAdapter() {
    if (generatedValueItemProvider == null) {
      generatedValueItemProvider = new GeneratedValueItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return generatedValueItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.HashPartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HashPartitioningItemProvider hashPartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.HashPartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHashPartitioningAdapter() {
		if (hashPartitioningItemProvider == null) {
			hashPartitioningItemProvider = new HashPartitioningItemProvider(this);
		}

		return hashPartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Id} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected IdItemProvider idItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Id}. <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createIdAdapter() {
    if (idItemProvider == null) {
      idItemProvider = new IdItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return idItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.IdClass} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected IdClassItemProvider idClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.IdClass}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createIdClassAdapter() {
    if (idClassItemProvider == null) {
      idClassItemProvider = new IdClassItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return idClassItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Index} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IndexItemProvider indexItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Index}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIndexAdapter() {
		if (indexItemProvider == null) {
			indexItemProvider = new IndexItemProvider(this);
		}

		return indexItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Inheritance} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected InheritanceItemProvider inheritanceItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Inheritance}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createInheritanceAdapter() {
    if (inheritanceItemProvider == null) {
      inheritanceItemProvider = new InheritanceItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return inheritanceItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.InstantiationCopyPolicy} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected InstantiationCopyPolicyItemProvider instantiationCopyPolicyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.InstantiationCopyPolicy}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createInstantiationCopyPolicyAdapter() {
    if (instantiationCopyPolicyItemProvider == null) {
      instantiationCopyPolicyItemProvider = new InstantiationCopyPolicyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return instantiationCopyPolicyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.JoinColumn} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected JoinColumnItemProvider joinColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.JoinColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createJoinColumnAdapter() {
    if (joinColumnItemProvider == null) {
      joinColumnItemProvider = new JoinColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return joinColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.JoinTable} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected JoinTableItemProvider joinTableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.JoinTable}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createJoinTableAdapter() {
    if (joinTableItemProvider == null) {
      joinTableItemProvider = new JoinTableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return joinTableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Lob} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected LobItemProvider lobItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Lob}. <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createLobAdapter() {
    if (lobItemProvider == null) {
      lobItemProvider = new LobItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return lobItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ManyToMany} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected ManyToManyItemProvider manyToManyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ManyToMany}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createManyToManyAdapter() {
    if (manyToManyItemProvider == null) {
      manyToManyItemProvider = new ManyToManyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return manyToManyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ManyToOne} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected ManyToOneItemProvider manyToOneItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ManyToOne}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createManyToOneAdapter() {
    if (manyToOneItemProvider == null) {
      manyToOneItemProvider = new ManyToOneItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return manyToOneItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKey} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected MapKeyItemProvider mapKeyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKey}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createMapKeyAdapter() {
    if (mapKeyItemProvider == null) {
      mapKeyItemProvider = new MapKeyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return mapKeyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyClass} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected MapKeyClassItemProvider mapKeyClassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyClass}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createMapKeyClassAdapter() {
    if (mapKeyClassItemProvider == null) {
      mapKeyClassItemProvider = new MapKeyClassItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return mapKeyClassItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyColumn} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected MapKeyColumnItemProvider mapKeyColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createMapKeyColumnAdapter() {
    if (mapKeyColumnItemProvider == null) {
      mapKeyColumnItemProvider = new MapKeyColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return mapKeyColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyJoinColumn} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected MapKeyJoinColumnItemProvider mapKeyJoinColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.MapKeyJoinColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createMapKeyJoinColumnAdapter() {
    if (mapKeyJoinColumnItemProvider == null) {
      mapKeyJoinColumnItemProvider = new MapKeyJoinColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return mapKeyJoinColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.MappedSuperclass} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected MappedSuperclassItemProvider mappedSuperclassItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.MappedSuperclass}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createMappedSuperclassAdapter() {
    if (mappedSuperclassItemProvider == null) {
      mappedSuperclassItemProvider = new MappedSuperclassItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return mappedSuperclassItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Multitenant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultitenantItemProvider multitenantItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Multitenant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultitenantAdapter() {
		if (multitenantItemProvider == null) {
			multitenantItemProvider = new MultitenantItemProvider(this);
		}

		return multitenantItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected NamedNativeQueryItemProvider namedNativeQueryItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedNativeQuery}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createNamedNativeQueryAdapter() {
    if (namedNativeQueryItemProvider == null) {
      namedNativeQueryItemProvider = new NamedNativeQueryItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return namedNativeQueryItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedPlsqlStoredFunctionQuery} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedPlsqlStoredFunctionQueryItemProvider namedPlsqlStoredFunctionQueryItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedPlsqlStoredFunctionQuery}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedPlsqlStoredFunctionQueryAdapter() {
		if (namedPlsqlStoredFunctionQueryItemProvider == null) {
			namedPlsqlStoredFunctionQueryItemProvider = new NamedPlsqlStoredFunctionQueryItemProvider(this);
		}

		return namedPlsqlStoredFunctionQueryItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedPlsqlStoredProcedureQuery} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedPlsqlStoredProcedureQueryItemProvider namedPlsqlStoredProcedureQueryItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedPlsqlStoredProcedureQuery}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedPlsqlStoredProcedureQueryAdapter() {
		if (namedPlsqlStoredProcedureQueryItemProvider == null) {
			namedPlsqlStoredProcedureQueryItemProvider = new NamedPlsqlStoredProcedureQueryItemProvider(this);
		}

		return namedPlsqlStoredProcedureQueryItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedQuery} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected NamedQueryItemProvider namedQueryItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedQuery}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createNamedQueryAdapter() {
    if (namedQueryItemProvider == null) {
      namedQueryItemProvider = new NamedQueryItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return namedQueryItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedStoredFunctionQuery} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedStoredFunctionQueryItemProvider namedStoredFunctionQueryItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedStoredFunctionQuery}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedStoredFunctionQueryAdapter() {
		if (namedStoredFunctionQueryItemProvider == null) {
			namedStoredFunctionQueryItemProvider = new NamedStoredFunctionQueryItemProvider(this);
		}

		return namedStoredFunctionQueryItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedStoredProcedureQuery} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected NamedStoredProcedureQueryItemProvider namedStoredProcedureQueryItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.NamedStoredProcedureQuery}.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createNamedStoredProcedureQueryAdapter() {
    if (namedStoredProcedureQueryItemProvider == null) {
      namedStoredProcedureQueryItemProvider = new NamedStoredProcedureQueryItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return namedStoredProcedureQueryItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ObjectTypeConverter} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ObjectTypeConverterItemProvider objectTypeConverterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ObjectTypeConverter}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createObjectTypeConverterAdapter() {
    if (objectTypeConverterItemProvider == null) {
      objectTypeConverterItemProvider = new ObjectTypeConverterItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return objectTypeConverterItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.OneToMany} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected OneToManyItemProvider oneToManyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.OneToMany}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createOneToManyAdapter() {
    if (oneToManyItemProvider == null) {
      oneToManyItemProvider = new OneToManyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return oneToManyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.OneToOne} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected OneToOneItemProvider oneToOneItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.OneToOne}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createOneToOneAdapter() {
    if (oneToOneItemProvider == null) {
      oneToOneItemProvider = new OneToOneItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return oneToOneItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.OptimisticLocking} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected OptimisticLockingItemProvider optimisticLockingItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.OptimisticLocking}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createOptimisticLockingAdapter() {
    if (optimisticLockingItemProvider == null) {
      optimisticLockingItemProvider = new OptimisticLockingItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return optimisticLockingItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.OrderColumn} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected OrderColumnItemProvider orderColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.OrderColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createOrderColumnAdapter() {
    if (orderColumnItemProvider == null) {
      orderColumnItemProvider = new OrderColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return orderColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Partitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartitioningItemProvider partitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Partitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartitioningAdapter() {
		if (partitioningItemProvider == null) {
			partitioningItemProvider = new PartitioningItemProvider(this);
		}

		return partitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitDefaults} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected PersistenceUnitDefaultsItemProvider persistenceUnitDefaultsItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitDefaults}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPersistenceUnitDefaultsAdapter() {
    if (persistenceUnitDefaultsItemProvider == null) {
      persistenceUnitDefaultsItemProvider = new PersistenceUnitDefaultsItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return persistenceUnitDefaultsItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitMetadata} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected PersistenceUnitMetadataItemProvider persistenceUnitMetadataItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PersistenceUnitMetadata}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPersistenceUnitMetadataAdapter() {
    if (persistenceUnitMetadataItemProvider == null) {
      persistenceUnitMetadataItemProvider = new PersistenceUnitMetadataItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return persistenceUnitMetadataItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PinnedPartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PinnedPartitioningItemProvider pinnedPartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PinnedPartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPinnedPartitioningAdapter() {
		if (pinnedPartitioningItemProvider == null) {
			pinnedPartitioningItemProvider = new PinnedPartitioningItemProvider(this);
		}

		return pinnedPartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlsqlParameterItemProvider plsqlParameterItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlsqlParameterAdapter() {
		if (plsqlParameterItemProvider == null) {
			plsqlParameterItemProvider = new PlsqlParameterItemProvider(this);
		}

		return plsqlParameterItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlRecord} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlsqlRecordItemProvider plsqlRecordItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlRecord}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlsqlRecordAdapter() {
		if (plsqlRecordItemProvider == null) {
			plsqlRecordItemProvider = new PlsqlRecordItemProvider(this);
		}

		return plsqlRecordItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlTable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlsqlTableItemProvider plsqlTableItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PlsqlTable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlsqlTableAdapter() {
		if (plsqlTableItemProvider == null) {
			plsqlTableItemProvider = new PlsqlTableItemProvider(this);
		}

		return plsqlTableItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostLoad} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PostLoadItemProvider postLoadItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostLoad}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPostLoadAdapter() {
    if (postLoadItemProvider == null) {
      postLoadItemProvider = new PostLoadItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return postLoadItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostPersist} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PostPersistItemProvider postPersistItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostPersist}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPostPersistAdapter() {
    if (postPersistItemProvider == null) {
      postPersistItemProvider = new PostPersistItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return postPersistItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostRemove} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PostRemoveItemProvider postRemoveItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostRemove}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPostRemoveAdapter() {
    if (postRemoveItemProvider == null) {
      postRemoveItemProvider = new PostRemoveItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return postRemoveItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostUpdate} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PostUpdateItemProvider postUpdateItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PostUpdate}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPostUpdateAdapter() {
    if (postUpdateItemProvider == null) {
      postUpdateItemProvider = new PostUpdateItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return postUpdateItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrePersist} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PrePersistItemProvider prePersistItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrePersist}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPrePersistAdapter() {
    if (prePersistItemProvider == null) {
      prePersistItemProvider = new PrePersistItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return prePersistItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PreRemove} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PreRemoveItemProvider preRemoveItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PreRemove}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPreRemoveAdapter() {
    if (preRemoveItemProvider == null) {
      preRemoveItemProvider = new PreRemoveItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return preRemoveItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PreUpdate} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PreUpdateItemProvider preUpdateItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PreUpdate}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPreUpdateAdapter() {
    if (preUpdateItemProvider == null) {
      preUpdateItemProvider = new PreUpdateItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return preUpdateItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrimaryKey} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PrimaryKeyItemProvider primaryKeyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrimaryKey}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPrimaryKeyAdapter() {
    if (primaryKeyItemProvider == null) {
      primaryKeyItemProvider = new PrimaryKeyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return primaryKeyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrimaryKeyJoinColumn} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected PrimaryKeyJoinColumnItemProvider primaryKeyJoinColumnItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.PrimaryKeyJoinColumn}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPrimaryKeyJoinColumnAdapter() {
    if (primaryKeyJoinColumnItemProvider == null) {
      primaryKeyJoinColumnItemProvider = new PrimaryKeyJoinColumnItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return primaryKeyJoinColumnItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Property} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected PropertyItemProvider propertyItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Property}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createPropertyAdapter() {
    if (propertyItemProvider == null) {
      propertyItemProvider = new PropertyItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return propertyItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.QueryHint} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected QueryHintItemProvider queryHintItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.QueryHint}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createQueryHintAdapter() {
    if (queryHintItemProvider == null) {
      queryHintItemProvider = new QueryHintItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return queryHintItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.QueryRedirectors} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected QueryRedirectorsItemProvider queryRedirectorsItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.QueryRedirectors}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createQueryRedirectorsAdapter() {
    if (queryRedirectorsItemProvider == null) {
      queryRedirectorsItemProvider = new QueryRedirectorsItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return queryRedirectorsItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.RangePartition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RangePartitionItemProvider rangePartitionItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.RangePartition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRangePartitionAdapter() {
		if (rangePartitionItemProvider == null) {
			rangePartitionItemProvider = new RangePartitionItemProvider(this);
		}

		return rangePartitionItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.RangePartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RangePartitioningItemProvider rangePartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.RangePartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRangePartitioningAdapter() {
		if (rangePartitioningItemProvider == null) {
			rangePartitioningItemProvider = new RangePartitioningItemProvider(this);
		}

		return rangePartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReadTransformer} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected ReadTransformerItemProvider readTransformerItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReadTransformer}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createReadTransformerAdapter() {
    if (readTransformerItemProvider == null) {
      readTransformerItemProvider = new ReadTransformerItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return readTransformerItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReplicationPartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReplicationPartitioningItemProvider replicationPartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReplicationPartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReplicationPartitioningAdapter() {
		if (replicationPartitioningItemProvider == null) {
			replicationPartitioningItemProvider = new ReplicationPartitioningItemProvider(this);
		}

		return replicationPartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReturnInsert} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReturnInsertItemProvider returnInsertItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ReturnInsert}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReturnInsertAdapter() {
		if (returnInsertItemProvider == null) {
			returnInsertItemProvider = new ReturnInsertItemProvider(this);
		}

		return returnInsertItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.RoundRobinPartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoundRobinPartitioningItemProvider roundRobinPartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.RoundRobinPartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRoundRobinPartitioningAdapter() {
		if (roundRobinPartitioningItemProvider == null) {
			roundRobinPartitioningItemProvider = new RoundRobinPartitioningItemProvider(this);
		}

		return roundRobinPartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.SecondaryTable} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected SecondaryTableItemProvider secondaryTableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.SecondaryTable}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createSecondaryTableAdapter() {
    if (secondaryTableItemProvider == null) {
      secondaryTableItemProvider = new SecondaryTableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return secondaryTableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.SequenceGenerator} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected SequenceGeneratorItemProvider sequenceGeneratorItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.SequenceGenerator}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createSequenceGeneratorAdapter() {
    if (sequenceGeneratorItemProvider == null) {
      sequenceGeneratorItemProvider = new SequenceGeneratorItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return sequenceGeneratorItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.SqlResultSetMapping} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected SqlResultSetMappingItemProvider sqlResultSetMappingItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.SqlResultSetMapping}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createSqlResultSetMappingAdapter() {
    if (sqlResultSetMappingItemProvider == null) {
      sqlResultSetMappingItemProvider = new SqlResultSetMappingItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return sqlResultSetMappingItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.StoredProcedureParameter} instances.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected StoredProcedureParameterItemProvider storedProcedureParameterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.StoredProcedureParameter}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createStoredProcedureParameterAdapter() {
    if (storedProcedureParameterItemProvider == null) {
      storedProcedureParameterItemProvider = new StoredProcedureParameterItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return storedProcedureParameterItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Struct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructItemProvider structItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Struct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructAdapter() {
		if (structItemProvider == null) {
			structItemProvider = new StructItemProvider(this);
		}

		return structItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.StructConverter} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected StructConverterItemProvider structConverterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.StructConverter}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createStructConverterAdapter() {
    if (structConverterItemProvider == null) {
      structConverterItemProvider = new StructConverterItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return structConverterItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Structure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructureItemProvider structureItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Structure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructureAdapter() {
		if (structureItemProvider == null) {
			structureItemProvider = new StructureItemProvider(this);
		}

		return structureItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Table} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected TableItemProvider tableItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Table}. <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTableAdapter() {
    if (tableItemProvider == null) {
      tableItemProvider = new TableItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return tableItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.TableGenerator} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected TableGeneratorItemProvider tableGeneratorItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.TableGenerator}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTableGeneratorAdapter() {
    if (tableGeneratorItemProvider == null) {
      tableGeneratorItemProvider = new TableGeneratorItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return tableGeneratorItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.TenantDiscriminator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TenantDiscriminatorItemProvider tenantDiscriminatorItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.TenantDiscriminator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTenantDiscriminatorAdapter() {
		if (tenantDiscriminatorItemProvider == null) {
			tenantDiscriminatorItemProvider = new TenantDiscriminatorItemProvider(this);
		}

		return tenantDiscriminatorItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.TimeOfDay} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected TimeOfDayItemProvider timeOfDayItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.TimeOfDay}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTimeOfDayAdapter() {
    if (timeOfDayItemProvider == null) {
      timeOfDayItemProvider = new TimeOfDayItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return timeOfDayItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Transformation} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected TransformationItemProvider transformationItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Transformation}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTransformationAdapter() {
    if (transformationItemProvider == null) {
      transformationItemProvider = new TransformationItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return transformationItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Transient} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected TransientItemProvider transientItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Transient}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTransientAdapter() {
    if (transientItemProvider == null) {
      transientItemProvider = new TransientItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return transientItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.TypeConverter} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected TypeConverterItemProvider typeConverterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.TypeConverter}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createTypeConverterAdapter() {
    if (typeConverterItemProvider == null) {
      typeConverterItemProvider = new TypeConverterItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return typeConverterItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.UnionPartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnionPartitioningItemProvider unionPartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.UnionPartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnionPartitioningAdapter() {
		if (unionPartitioningItemProvider == null) {
			unionPartitioningItemProvider = new UnionPartitioningItemProvider(this);
		}

		return unionPartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.UniqueConstraint} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected UniqueConstraintItemProvider uniqueConstraintItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.UniqueConstraint}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createUniqueConstraintAdapter() {
    if (uniqueConstraintItemProvider == null) {
      uniqueConstraintItemProvider = new UniqueConstraintItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return uniqueConstraintItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ValuePartition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValuePartitionItemProvider valuePartitionItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ValuePartition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValuePartitionAdapter() {
		if (valuePartitionItemProvider == null) {
			valuePartitionItemProvider = new ValuePartitionItemProvider(this);
		}

		return valuePartitionItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.ValuePartitioning} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValuePartitioningItemProvider valuePartitioningItemProvider;

		/**
	 * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.ValuePartitioning}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValuePartitioningAdapter() {
		if (valuePartitioningItemProvider == null) {
			valuePartitioningItemProvider = new ValuePartitioningItemProvider(this);
		}

		return valuePartitioningItemProvider;
	}

		/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected VariableOneToOneItemProvider variableOneToOneItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createVariableOneToOneAdapter() {
    if (variableOneToOneItemProvider == null) {
      variableOneToOneItemProvider = new VariableOneToOneItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return variableOneToOneItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.Version} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  protected VersionItemProvider versionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.Version}. <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createVersionAdapter() {
    if (versionItemProvider == null) {
      versionItemProvider = new VersionItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return versionItemProvider;
  }

  /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.texo.orm.annotations.model.orm.WriteTransformer} instances.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  protected WriteTransformerItemProvider writeTransformerItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.texo.orm.annotations.model.orm.WriteTransformer}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generatedNOT
   */
  @Override
  public Adapter createWriteTransformerAdapter() {
    if (writeTransformerItemProvider == null) {
      writeTransformerItemProvider = new WriteTransformerItemProvider(this) {
        @Override
        protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
          super.collectNewChildDescriptors(newChildDescriptors, object);
          Collections.sort((List<Object>) newChildDescriptors, new ChildPropertyDescriptorSorter());
        }
      };
    }

    return writeTransformerItemProvider;
  }

  /**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

  /**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

  /**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  @Override
  public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

  /**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  @Override
  public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

  /**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  @Override
  public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

  /**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

  /**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

  /**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc --> <!--
   * end-user-doc -->
	 * @generated
	 */
  public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

  /**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
  public void dispose() {
		if (accessMethodsItemProvider != null) accessMethodsItemProvider.dispose();
		if (additionalCriteriaItemProvider != null) additionalCriteriaItemProvider.dispose();
		if (arrayItemProvider != null) arrayItemProvider.dispose();
		if (associationOverrideItemProvider != null) associationOverrideItemProvider.dispose();
		if (attributeOverrideItemProvider != null) attributeOverrideItemProvider.dispose();
		if (attributesItemProvider != null) attributesItemProvider.dispose();
		if (basicItemProvider != null) basicItemProvider.dispose();
		if (basicCollectionItemProvider != null) basicCollectionItemProvider.dispose();
		if (basicMapItemProvider != null) basicMapItemProvider.dispose();
		if (batchFetchItemProvider != null) batchFetchItemProvider.dispose();
		if (cacheItemProvider != null) cacheItemProvider.dispose();
		if (cacheInterceptorItemProvider != null) cacheInterceptorItemProvider.dispose();
		if (cascadeTypeItemProvider != null) cascadeTypeItemProvider.dispose();
		if (changeTrackingItemProvider != null) changeTrackingItemProvider.dispose();
		if (classExtractorItemProvider != null) classExtractorItemProvider.dispose();
		if (cloneCopyPolicyItemProvider != null) cloneCopyPolicyItemProvider.dispose();
		if (collectionTableItemProvider != null) collectionTableItemProvider.dispose();
		if (columnItemProvider != null) columnItemProvider.dispose();
		if (columnResultItemProvider != null) columnResultItemProvider.dispose();
		if (conversionValueItemProvider != null) conversionValueItemProvider.dispose();
		if (converterItemProvider != null) converterItemProvider.dispose();
		if (copyPolicyItemProvider != null) copyPolicyItemProvider.dispose();
		if (customizerItemProvider != null) customizerItemProvider.dispose();
		if (discriminatorClassItemProvider != null) discriminatorClassItemProvider.dispose();
		if (discriminatorColumnItemProvider != null) discriminatorColumnItemProvider.dispose();
		if (documentRootItemProvider != null) documentRootItemProvider.dispose();
		if (eclipselinkCollectionTableItemProvider != null) eclipselinkCollectionTableItemProvider.dispose();
		if (elementCollectionItemProvider != null) elementCollectionItemProvider.dispose();
		if (embeddableItemProvider != null) embeddableItemProvider.dispose();
		if (embeddedItemProvider != null) embeddedItemProvider.dispose();
		if (embeddedIdItemProvider != null) embeddedIdItemProvider.dispose();
		if (emptyTypeItemProvider != null) emptyTypeItemProvider.dispose();
		if (entityItemProvider != null) entityItemProvider.dispose();
		if (entityListenerItemProvider != null) entityListenerItemProvider.dispose();
		if (entityListenersItemProvider != null) entityListenersItemProvider.dispose();
		if (entityMappingsTypeItemProvider != null) entityMappingsTypeItemProvider.dispose();
		if (entityResultItemProvider != null) entityResultItemProvider.dispose();
		if (fetchAttributeItemProvider != null) fetchAttributeItemProvider.dispose();
		if (fetchGroupItemProvider != null) fetchGroupItemProvider.dispose();
		if (fieldResultItemProvider != null) fieldResultItemProvider.dispose();
		if (generatedValueItemProvider != null) generatedValueItemProvider.dispose();
		if (hashPartitioningItemProvider != null) hashPartitioningItemProvider.dispose();
		if (idItemProvider != null) idItemProvider.dispose();
		if (idClassItemProvider != null) idClassItemProvider.dispose();
		if (indexItemProvider != null) indexItemProvider.dispose();
		if (inheritanceItemProvider != null) inheritanceItemProvider.dispose();
		if (instantiationCopyPolicyItemProvider != null) instantiationCopyPolicyItemProvider.dispose();
		if (joinColumnItemProvider != null) joinColumnItemProvider.dispose();
		if (joinTableItemProvider != null) joinTableItemProvider.dispose();
		if (lobItemProvider != null) lobItemProvider.dispose();
		if (manyToManyItemProvider != null) manyToManyItemProvider.dispose();
		if (manyToOneItemProvider != null) manyToOneItemProvider.dispose();
		if (mapKeyItemProvider != null) mapKeyItemProvider.dispose();
		if (mapKeyClassItemProvider != null) mapKeyClassItemProvider.dispose();
		if (mapKeyColumnItemProvider != null) mapKeyColumnItemProvider.dispose();
		if (mapKeyJoinColumnItemProvider != null) mapKeyJoinColumnItemProvider.dispose();
		if (mappedSuperclassItemProvider != null) mappedSuperclassItemProvider.dispose();
		if (multitenantItemProvider != null) multitenantItemProvider.dispose();
		if (namedNativeQueryItemProvider != null) namedNativeQueryItemProvider.dispose();
		if (namedPlsqlStoredFunctionQueryItemProvider != null) namedPlsqlStoredFunctionQueryItemProvider.dispose();
		if (namedPlsqlStoredProcedureQueryItemProvider != null) namedPlsqlStoredProcedureQueryItemProvider.dispose();
		if (namedQueryItemProvider != null) namedQueryItemProvider.dispose();
		if (namedStoredFunctionQueryItemProvider != null) namedStoredFunctionQueryItemProvider.dispose();
		if (namedStoredProcedureQueryItemProvider != null) namedStoredProcedureQueryItemProvider.dispose();
		if (objectTypeConverterItemProvider != null) objectTypeConverterItemProvider.dispose();
		if (oneToManyItemProvider != null) oneToManyItemProvider.dispose();
		if (oneToOneItemProvider != null) oneToOneItemProvider.dispose();
		if (optimisticLockingItemProvider != null) optimisticLockingItemProvider.dispose();
		if (orderColumnItemProvider != null) orderColumnItemProvider.dispose();
		if (partitioningItemProvider != null) partitioningItemProvider.dispose();
		if (persistenceUnitDefaultsItemProvider != null) persistenceUnitDefaultsItemProvider.dispose();
		if (persistenceUnitMetadataItemProvider != null) persistenceUnitMetadataItemProvider.dispose();
		if (pinnedPartitioningItemProvider != null) pinnedPartitioningItemProvider.dispose();
		if (plsqlParameterItemProvider != null) plsqlParameterItemProvider.dispose();
		if (plsqlRecordItemProvider != null) plsqlRecordItemProvider.dispose();
		if (plsqlTableItemProvider != null) plsqlTableItemProvider.dispose();
		if (postLoadItemProvider != null) postLoadItemProvider.dispose();
		if (postPersistItemProvider != null) postPersistItemProvider.dispose();
		if (postRemoveItemProvider != null) postRemoveItemProvider.dispose();
		if (postUpdateItemProvider != null) postUpdateItemProvider.dispose();
		if (prePersistItemProvider != null) prePersistItemProvider.dispose();
		if (preRemoveItemProvider != null) preRemoveItemProvider.dispose();
		if (preUpdateItemProvider != null) preUpdateItemProvider.dispose();
		if (primaryKeyItemProvider != null) primaryKeyItemProvider.dispose();
		if (primaryKeyJoinColumnItemProvider != null) primaryKeyJoinColumnItemProvider.dispose();
		if (propertyItemProvider != null) propertyItemProvider.dispose();
		if (queryHintItemProvider != null) queryHintItemProvider.dispose();
		if (queryRedirectorsItemProvider != null) queryRedirectorsItemProvider.dispose();
		if (rangePartitionItemProvider != null) rangePartitionItemProvider.dispose();
		if (rangePartitioningItemProvider != null) rangePartitioningItemProvider.dispose();
		if (readTransformerItemProvider != null) readTransformerItemProvider.dispose();
		if (replicationPartitioningItemProvider != null) replicationPartitioningItemProvider.dispose();
		if (returnInsertItemProvider != null) returnInsertItemProvider.dispose();
		if (roundRobinPartitioningItemProvider != null) roundRobinPartitioningItemProvider.dispose();
		if (secondaryTableItemProvider != null) secondaryTableItemProvider.dispose();
		if (sequenceGeneratorItemProvider != null) sequenceGeneratorItemProvider.dispose();
		if (sqlResultSetMappingItemProvider != null) sqlResultSetMappingItemProvider.dispose();
		if (storedProcedureParameterItemProvider != null) storedProcedureParameterItemProvider.dispose();
		if (structItemProvider != null) structItemProvider.dispose();
		if (structConverterItemProvider != null) structConverterItemProvider.dispose();
		if (structureItemProvider != null) structureItemProvider.dispose();
		if (tableItemProvider != null) tableItemProvider.dispose();
		if (tableGeneratorItemProvider != null) tableGeneratorItemProvider.dispose();
		if (tenantDiscriminatorItemProvider != null) tenantDiscriminatorItemProvider.dispose();
		if (timeOfDayItemProvider != null) timeOfDayItemProvider.dispose();
		if (transformationItemProvider != null) transformationItemProvider.dispose();
		if (transientItemProvider != null) transientItemProvider.dispose();
		if (typeConverterItemProvider != null) typeConverterItemProvider.dispose();
		if (unionPartitioningItemProvider != null) unionPartitioningItemProvider.dispose();
		if (uniqueConstraintItemProvider != null) uniqueConstraintItemProvider.dispose();
		if (valuePartitionItemProvider != null) valuePartitionItemProvider.dispose();
		if (valuePartitioningItemProvider != null) valuePartitioningItemProvider.dispose();
		if (variableOneToOneItemProvider != null) variableOneToOneItemProvider.dispose();
		if (versionItemProvider != null) versionItemProvider.dispose();
		if (writeTransformerItemProvider != null) writeTransformerItemProvider.dispose();
	}

  private static class ChildPropertyDescriptorSorter implements Comparator<Object> {

    public int compare(Object o1, Object o2) {
      final CommandParameter cp1 = (CommandParameter) o1;
      final CommandParameter cp2 = (CommandParameter) o2;
      return cp1.getEStructuralFeature().getName().compareTo(cp2.getEStructuralFeature().getName());
    }

  }
}
