/**
 * <copyright>
 * </copyright>
 *
 * $Id: VariableOneToOne.java,v 1.5 2011/10/25 13:21:26 mtaal Exp $
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.texo.orm.annotator.BaseOrmAnnotation;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Variable One To One</b></em>'. <!-- end-user-doc
 * -->
 * 
 * <!-- begin-model-doc -->
 * 
 * * * Variable one to one mappings are used to represent a pointer * references between a java object and an
 * implementer of an interface. * This mapping is usually represented by a single pointer (stored in an * instance
 * variable) between the source and target objects. In the * relational database tables, these mappings are normally
 * implemented * using a foreign key and a type code. * * A VariableOneToOne can be specified within an Entity, *
 * MappedSuperclass and Embeddable class. *
 * 
 * @Target({METHOD, FIELD})
 * @Retention(RUNTIME) public @interface VariableOneToOne { * * (Optional) The interface class that is the target of the
 *                     * association. If not specified it will be inferred from the type * of the object being
 *                     referenced. * Class targetInterface() default void.class;
 * 
 *                     * * (Optional) The operations that must be cascaded to the target of * the association. *
 *                     CascadeType[] cascade() default {};
 * 
 *                     * * (Optional) Defines whether the value of the field or property * should be lazily loaded or
 *                     must be eagerly fetched. The EAGER * strategy is a requirement on the persistence provider
 *                     runtime * that the value must be eagerly fetched. The LAZY strategy is a * hint to the
 *                     persistence provider runtime. If not specified, * defaults to EAGER. * FetchType fetch() default
 *                     EAGER;
 * 
 *                     * * (Optional) Whether the association is optional. If set to false * then a non-null
 *                     relationship must always exist. * boolean optional() default true;
 * 
 *                     * * (Optional) The discriminator column will hold the type * indicators. If the
 *                     DiscriminatorColumn is not specified, the name * of the discriminator column defaults to "DTYPE"
 *                     and the * discriminator type to STRING. * DiscriminatorColumn discriminatorColumn() default
 * @DiscriminatorColumn;
 * 
 *                       * * (Optional) The list of discriminator types that can be used with * this VariableOneToOne.
 *                       If none are specified then those entities * within the persistence unit that implement the
 *                       target interface * will be added to the list of types. The discriminator type will * default as
 *                       follows: * - If DiscriminatorColumn type is STRING: Entity.name() * - If DiscriminatorColumn
 *                       type is CHAR: First letter of the * Entity class * - If DiscriminatorColumn type is INTEGER:
 *                       The next integer after * the highest integer explicitly added. * DiscriminatorClass[]
 *                       discriminatorClasses() default {}; }
 * 
 * 
 *                       <!-- end-model-doc -->
 * 
 *                       <p>
 *                       The following features are supported:
 *                       <ul>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getCascade <em>
 *                       Cascade </em>}</li>
 *                       <li>
 *                       {@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getDiscriminatorColumn
 *                       <em>Discriminator Column</em>}</li>
 *                       <li>
 *                       {@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getDiscriminatorClass
 *                       <em>Discriminator Class</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getJoinColumn <em>
 *                       Join Column</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getPrivateOwned <em>
 *                       Private Owned</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getProperty <em>
 *                       Property</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccessMethods
 *                       <em> Access Methods</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccess <em>Access
 *                       </em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getFetch <em>Fetch
 *                       </em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getName <em>Name
 *                       </em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOptional <em>
 *                       Optional</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOrphanRemoval <em>
 *                       Orphan Removal</em>}</li>
 *                       <li>{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getTargetInterface
 *                       <em>Target Interface</em>}</li>
 *                       </ul>
 *                       </p>
 * 
 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne()
 * @model extendedMetaData="name='variable-one-to-one' kind='elementOnly'"
 * @generated
 */
public interface VariableOneToOne extends BaseOrmAnnotation {
  /**
	 * Returns the value of the '<em><b>Cascade</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Cascade</em>' containment reference isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Cascade</em>' containment reference.
	 * @see #setCascade(CascadeType)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Cascade()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='cascade' namespace='##targetNamespace'"
	 * @generated
	 */
  CascadeType getCascade();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getCascade <em>Cascade</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cascade</em>' containment reference.
	 * @see #getCascade()
	 * @generated
	 */
  void setCascade(CascadeType value);

  /**
	 * Returns the value of the '<em><b>Discriminator Column</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Discriminator Column</em>' containment reference isn't clear, there really should be
   * more of a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Discriminator Column</em>' containment reference.
	 * @see #setDiscriminatorColumn(DiscriminatorColumn)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_DiscriminatorColumn()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='discriminator-column' namespace='##targetNamespace'"
	 * @generated
	 */
  DiscriminatorColumn getDiscriminatorColumn();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getDiscriminatorColumn <em>Discriminator Column</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Discriminator Column</em>' containment reference.
	 * @see #getDiscriminatorColumn()
	 * @generated
	 */
  void setDiscriminatorColumn(DiscriminatorColumn value);

  /**
	 * Returns the value of the '<em><b>Discriminator Class</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorClass}.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Discriminator Class</em>' containment reference list isn't clear, there really should be
   * more of a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Discriminator Class</em>' containment reference list.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_DiscriminatorClass()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='discriminator-class' namespace='##targetNamespace'"
	 * @generated
	 */
  EList<DiscriminatorClass> getDiscriminatorClass();

  /**
	 * Returns the value of the '<em><b>Join Column</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.texo.orm.annotations.model.orm.JoinColumn}.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Join Column</em>' containment reference list isn't clear, there really should be more of
   * a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Join Column</em>' containment reference list.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_JoinColumn()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='join-column' namespace='##targetNamespace'"
	 * @generated
	 */
  EList<JoinColumn> getJoinColumn();

  /**
	 * Returns the value of the '<em><b>Private Owned</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Private Owned</em>' containment reference isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Private Owned</em>' containment reference.
	 * @see #setPrivateOwned(EmptyType)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_PrivateOwned()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='private-owned' namespace='##targetNamespace'"
	 * @generated
	 */
  EmptyType getPrivateOwned();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getPrivateOwned <em>Private Owned</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Private Owned</em>' containment reference.
	 * @see #getPrivateOwned()
	 * @generated
	 */
  void setPrivateOwned(EmptyType value);

  /**
	 * Returns the value of the '<em><b>Property</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.texo.orm.annotations.model.orm.Property}.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Property</em>' containment reference list isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Property</em>' containment reference list.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Property()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='property' namespace='##targetNamespace'"
	 * @generated
	 */
  EList<Property> getProperty();

  /**
	 * Returns the value of the '<em><b>Access Methods</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Access Methods</em>' containment reference isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Access Methods</em>' containment reference.
	 * @see #setAccessMethods(AccessMethods)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_AccessMethods()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='access-methods' namespace='##targetNamespace'"
	 * @generated
	 */
  AccessMethods getAccessMethods();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccessMethods <em>Access Methods</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Access Methods</em>' containment reference.
	 * @see #getAccessMethods()
	 * @generated
	 */
  void setAccessMethods(AccessMethods value);

  /**
	 * Returns the value of the '<em><b>Noncacheable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Noncacheable</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Noncacheable</em>' containment reference.
	 * @see #setNoncacheable(EmptyType)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Noncacheable()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='noncacheable' namespace='##targetNamespace'"
	 * @generated
	 */
	EmptyType getNoncacheable();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getNoncacheable <em>Noncacheable</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Noncacheable</em>' containment reference.
	 * @see #getNoncacheable()
	 * @generated
	 */
	void setNoncacheable(EmptyType value);

		/**
	 * Returns the value of the '<em><b>Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Partitioning</em>' containment reference.
	 * @see #setPartitioning(Partitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Partitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	Partitioning getPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getPartitioning <em>Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Partitioning</em>' containment reference.
	 * @see #getPartitioning()
	 * @generated
	 */
	void setPartitioning(Partitioning value);

		/**
	 * Returns the value of the '<em><b>Replication Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Replication Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Replication Partitioning</em>' containment reference.
	 * @see #setReplicationPartitioning(ReplicationPartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_ReplicationPartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='replication-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	ReplicationPartitioning getReplicationPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getReplicationPartitioning <em>Replication Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Replication Partitioning</em>' containment reference.
	 * @see #getReplicationPartitioning()
	 * @generated
	 */
	void setReplicationPartitioning(ReplicationPartitioning value);

		/**
	 * Returns the value of the '<em><b>Round Robin Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Round Robin Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Round Robin Partitioning</em>' containment reference.
	 * @see #setRoundRobinPartitioning(RoundRobinPartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_RoundRobinPartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='round-robin-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	RoundRobinPartitioning getRoundRobinPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getRoundRobinPartitioning <em>Round Robin Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Round Robin Partitioning</em>' containment reference.
	 * @see #getRoundRobinPartitioning()
	 * @generated
	 */
	void setRoundRobinPartitioning(RoundRobinPartitioning value);

		/**
	 * Returns the value of the '<em><b>Pinned Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pinned Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pinned Partitioning</em>' containment reference.
	 * @see #setPinnedPartitioning(PinnedPartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_PinnedPartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='pinned-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	PinnedPartitioning getPinnedPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getPinnedPartitioning <em>Pinned Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pinned Partitioning</em>' containment reference.
	 * @see #getPinnedPartitioning()
	 * @generated
	 */
	void setPinnedPartitioning(PinnedPartitioning value);

		/**
	 * Returns the value of the '<em><b>Range Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Range Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Range Partitioning</em>' containment reference.
	 * @see #setRangePartitioning(RangePartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_RangePartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='range-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	RangePartitioning getRangePartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getRangePartitioning <em>Range Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Range Partitioning</em>' containment reference.
	 * @see #getRangePartitioning()
	 * @generated
	 */
	void setRangePartitioning(RangePartitioning value);

		/**
	 * Returns the value of the '<em><b>Value Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value Partitioning</em>' containment reference.
	 * @see #setValuePartitioning(ValuePartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_ValuePartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='value-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	ValuePartitioning getValuePartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getValuePartitioning <em>Value Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value Partitioning</em>' containment reference.
	 * @see #getValuePartitioning()
	 * @generated
	 */
	void setValuePartitioning(ValuePartitioning value);

		/**
	 * Returns the value of the '<em><b>Hash Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hash Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hash Partitioning</em>' containment reference.
	 * @see #setHashPartitioning(HashPartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_HashPartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='hash-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	HashPartitioning getHashPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getHashPartitioning <em>Hash Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hash Partitioning</em>' containment reference.
	 * @see #getHashPartitioning()
	 * @generated
	 */
	void setHashPartitioning(HashPartitioning value);

		/**
	 * Returns the value of the '<em><b>Union Partitioning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Union Partitioning</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Union Partitioning</em>' containment reference.
	 * @see #setUnionPartitioning(UnionPartitioning)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_UnionPartitioning()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='union-partitioning' namespace='##targetNamespace'"
	 * @generated
	 */
	UnionPartitioning getUnionPartitioning();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getUnionPartitioning <em>Union Partitioning</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Union Partitioning</em>' containment reference.
	 * @see #getUnionPartitioning()
	 * @generated
	 */
	void setUnionPartitioning(UnionPartitioning value);

		/**
	 * Returns the value of the '<em><b>Partitioned</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partitioned</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Partitioned</em>' attribute.
	 * @see #setPartitioned(String)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Partitioned()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='element' name='partitioned' namespace='##targetNamespace'"
	 * @generated
	 */
	String getPartitioned();

		/**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getPartitioned <em>Partitioned</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Partitioned</em>' attribute.
	 * @see #getPartitioned()
	 * @generated
	 */
	void setPartitioned(String value);

		/**
	 * Returns the value of the '<em><b>Access</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.emf.texo.orm.annotations.model.orm.AccessType}.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Access</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Access</em>' attribute.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.AccessType
	 * @see #isSetAccess()
	 * @see #unsetAccess()
	 * @see #setAccess(AccessType)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Access()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='attribute' name='access'"
	 * @generated
	 */
  AccessType getAccess();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccess <em>Access</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Access</em>' attribute.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.AccessType
	 * @see #isSetAccess()
	 * @see #unsetAccess()
	 * @see #getAccess()
	 * @generated
	 */
  void setAccess(AccessType value);

  /**
	 * Unsets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccess <em>Access</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSetAccess()
	 * @see #getAccess()
	 * @see #setAccess(AccessType)
	 * @generated
	 */
  void unsetAccess();

  /**
	 * Returns whether the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getAccess <em>Access</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Access</em>' attribute is set.
	 * @see #unsetAccess()
	 * @see #getAccess()
	 * @see #setAccess(AccessType)
	 * @generated
	 */
  boolean isSetAccess();

  /**
	 * Returns the value of the '<em><b>Fetch</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.emf.texo.orm.annotations.model.orm.FetchType}.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Fetch</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Fetch</em>' attribute.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.FetchType
	 * @see #isSetFetch()
	 * @see #unsetFetch()
	 * @see #setFetch(FetchType)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Fetch()
	 * @model unsettable="true"
	 *        extendedMetaData="kind='attribute' name='fetch'"
	 * @generated
	 */
  FetchType getFetch();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getFetch <em>Fetch</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Fetch</em>' attribute.
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.FetchType
	 * @see #isSetFetch()
	 * @see #unsetFetch()
	 * @see #getFetch()
	 * @generated
	 */
  void setFetch(FetchType value);

  /**
	 * Unsets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getFetch <em>Fetch</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSetFetch()
	 * @see #getFetch()
	 * @see #setFetch(FetchType)
	 * @generated
	 */
  void unsetFetch();

  /**
	 * Returns whether the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getFetch <em>Fetch</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Fetch</em>' attribute is set.
	 * @see #unsetFetch()
	 * @see #getFetch()
	 * @see #setFetch(FetchType)
	 * @generated
	 */
  boolean isSetFetch();

  /**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Name</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Name()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='attribute' name='name'"
	 * @generated
	 */
  String getName();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
  void setName(String value);

  /**
	 * Returns the value of the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Optional</em>' attribute isn't clear, there really should be more of a description
   * here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Optional</em>' attribute.
	 * @see #isSetOptional()
	 * @see #unsetOptional()
	 * @see #setOptional(boolean)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_Optional()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='attribute' name='optional'"
	 * @generated
	 */
  boolean isOptional();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOptional <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Optional</em>' attribute.
	 * @see #isSetOptional()
	 * @see #unsetOptional()
	 * @see #isOptional()
	 * @generated
	 */
  void setOptional(boolean value);

  /**
	 * Unsets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOptional <em>Optional</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSetOptional()
	 * @see #isOptional()
	 * @see #setOptional(boolean)
	 * @generated
	 */
  void unsetOptional();

  /**
	 * Returns whether the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOptional <em>Optional</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Optional</em>' attribute is set.
	 * @see #unsetOptional()
	 * @see #isOptional()
	 * @see #setOptional(boolean)
	 * @generated
	 */
  boolean isSetOptional();

  /**
	 * Returns the value of the '<em><b>Orphan Removal</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Orphan Removal</em>' attribute isn't clear, there really should be more of a description
   * here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Orphan Removal</em>' attribute.
	 * @see #isSetOrphanRemoval()
	 * @see #unsetOrphanRemoval()
	 * @see #setOrphanRemoval(boolean)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_OrphanRemoval()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 *        extendedMetaData="kind='attribute' name='orphan-removal'"
	 * @generated
	 */
  boolean isOrphanRemoval();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOrphanRemoval <em>Orphan Removal</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Orphan Removal</em>' attribute.
	 * @see #isSetOrphanRemoval()
	 * @see #unsetOrphanRemoval()
	 * @see #isOrphanRemoval()
	 * @generated
	 */
  void setOrphanRemoval(boolean value);

  /**
	 * Unsets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOrphanRemoval <em>Orphan Removal</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSetOrphanRemoval()
	 * @see #isOrphanRemoval()
	 * @see #setOrphanRemoval(boolean)
	 * @generated
	 */
  void unsetOrphanRemoval();

  /**
	 * Returns whether the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#isOrphanRemoval <em>Orphan Removal</em>}' attribute is set.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return whether the value of the '<em>Orphan Removal</em>' attribute is set.
	 * @see #unsetOrphanRemoval()
	 * @see #isOrphanRemoval()
	 * @see #setOrphanRemoval(boolean)
	 * @generated
	 */
  boolean isSetOrphanRemoval();

  /**
	 * Returns the value of the '<em><b>Target Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Target Interface</em>' attribute isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
	 * @return the value of the '<em>Target Interface</em>' attribute.
	 * @see #setTargetInterface(String)
	 * @see org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage#getVariableOneToOne_TargetInterface()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String"
	 *        extendedMetaData="kind='attribute' name='target-interface'"
	 * @generated
	 */
  String getTargetInterface();

  /**
	 * Sets the value of the '{@link org.eclipse.emf.texo.orm.annotations.model.orm.VariableOneToOne#getTargetInterface <em>Target Interface</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target Interface</em>' attribute.
	 * @see #getTargetInterface()
	 * @generated
	 */
  void setTargetInterface(String value);

} // VariableOneToOne
