/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheIsolationType implements Enumerator
{
    SHARED(0, "SHARED", "SHARED"),
    PROTECTED(1, "PROTECTED", "PROTECTED"),
    ISOLATED(2, "ISOLATED", "ISOLATED");

    public static final int SHARED_VALUE = 0;
    public static final int PROTECTED_VALUE = 1;
    public static final int ISOLATED_VALUE = 2;
    private static final CacheIsolationType[] VALUES_ARRAY;
    public static final List<CacheIsolationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheIsolationType[]{SHARED, PROTECTED, ISOLATED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheIsolationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheIsolationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheIsolationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheIsolationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheIsolationType get(int value) {
        switch (value) {
            case 0: {
                return SHARED;
            }
            case 1: {
                return PROTECTED;
            }
            case 2: {
                return ISOLATED;
            }
        }
        return null;
    }

    private CacheIsolationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

