/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheType implements Enumerator
{
    FULL(0, "FULL", "FULL"),
    WEAK(1, "WEAK", "WEAK"),
    SOFT(2, "SOFT", "SOFT"),
    SOFTWEAK(3, "SOFTWEAK", "SOFT_WEAK"),
    HARDWEAK(4, "HARDWEAK", "HARD_WEAK"),
    CACHE(5, "CACHE", "CACHE"),
    NONE(6, "NONE", "NONE");

    public static final int FULL_VALUE = 0;
    public static final int WEAK_VALUE = 1;
    public static final int SOFT_VALUE = 2;
    public static final int SOFTWEAK_VALUE = 3;
    public static final int HARDWEAK_VALUE = 4;
    public static final int CACHE_VALUE = 5;
    public static final int NONE_VALUE = 6;
    private static final CacheType[] VALUES_ARRAY;
    public static final List<CacheType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheType[]{FULL, WEAK, SOFT, SOFTWEAK, HARDWEAK, CACHE, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheType get(int value) {
        switch (value) {
            case 0: {
                return FULL;
            }
            case 1: {
                return WEAK;
            }
            case 2: {
                return SOFT;
            }
            case 3: {
                return SOFTWEAK;
            }
            case 4: {
                return HARDWEAK;
            }
            case 5: {
                return CACHE;
            }
            case 6: {
                return NONE;
            }
        }
        return null;
    }

    private CacheType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

