/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.orm.annotations.model.orm.AccessType;
import org.eclipse.emf.texo.orm.annotations.model.orm.DiscriminatorColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.Embeddable;
import org.eclipse.emf.texo.orm.annotations.model.orm.Entity;
import org.eclipse.emf.texo.orm.annotations.model.orm.Inheritance;
import org.eclipse.emf.texo.orm.annotations.model.orm.MappedSuperclass;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.PrimaryKeyJoinColumn;
import org.eclipse.emf.texo.orm.annotations.model.orm.Table;
import org.eclipse.emf.texo.orm.annotations.model.orm.Transient;
import org.eclipse.emf.texo.orm.annotator.ETypeElementORMAnnotator;
import org.eclipse.emf.texo.orm.annotator.ORMMappingOptions;
import org.eclipse.emf.texo.orm.annotator.ORMNamingStrategy;
import org.eclipse.emf.texo.orm.annotator.ORMUtils;
import org.eclipse.emf.texo.orm.ormannotations.EClassORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;
import org.eclipse.emf.texo.orm.ormannotations.OrmannotationsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassORMAnnotator
extends ETypeElementORMAnnotator
implements Annotator<EClassORMAnnotation> {
    public void setAnnotationFeatures(EClassORMAnnotation annotation) {
        Entity entity;
        EClass eClass = annotation.getEClass();
        if (GenUtils.isDocumentRoot((EClass)eClass)) {
            return;
        }
        ORMNamingStrategy namingStrategy = this.getOrmNamingStrategy(eClass.getEPackage());
        if (annotation.getTransient() != null) {
            Transient transnt = annotation.getTransient();
            if (GeneratorUtils.isEmptyOrNull((String)transnt.getName())) {
                transnt.setName(namingStrategy.getEntityName(eClass));
            }
            return;
        }
        EClassModelGenAnnotation modelGenAnnotation = (EClassModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClass, ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation());
        EPackageORMAnnotation ePackageAnnotation = (EPackageORMAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClass.getEPackage(), OrmannotationsPackage.eINSTANCE.getEPackageORMAnnotation());
        if (annotation.getMappedSuperclass() != null) {
            MappedSuperclass mappedSuperclass = annotation.getMappedSuperclass();
            if (GeneratorUtils.isEmptyOrNull((String)mappedSuperclass.getClass_())) {
                mappedSuperclass.setClass(modelGenAnnotation.getQualifiedClassName());
            }
            return;
        }
        Embeddable embeddable = annotation.getEmbeddable();
        if (embeddable == null && annotation.getEntity() == null) {
            annotation.setEntity(OrmFactory.eINSTANCE.createEntity());
        }
        if (this.isRoot(annotation) && annotation.getInheritance() == null && ePackageAnnotation.getInheritance() != null && ePackageAnnotation.getInheritance().isSetStrategy()) {
            annotation.setInheritance((Inheritance)EcoreUtil.copy((EObject)ePackageAnnotation.getInheritance()));
        }
        if (annotation.getInheritance() == null && annotation.getEntity() != null && annotation.getEntity().getInheritance() == null) {
            annotation.getEntity().setInheritance((Inheritance)EcoreUtil.copy((EObject)annotation.getInheritance()));
        }
        if (ORMMappingOptions.getDefaultOptions().isTestRun()) {
            if (annotation.getEntity() != null) {
                annotation.getEntity().getConverter().add((Object)ORMUtils.createDefaultConverter());
                annotation.getEntity().getConverter().add((Object)ORMUtils.createQNameConverter());
            } else if (annotation.getMappedSuperclass() != null) {
                annotation.getMappedSuperclass().getConverter().add((Object)ORMUtils.createDefaultConverter());
                annotation.getMappedSuperclass().getConverter().add((Object)ORMUtils.createQNameConverter());
            }
        }
        if ((entity = annotation.getEntity()) != null) {
            if (namingStrategy.isGenerateAllDBSchemaNames() && this.hasItsOwnTable(annotation)) {
                Table table;
                if (entity.getTable() == null) {
                    entity.setTable(OrmFactory.eINSTANCE.createTable());
                }
                if ((table = entity.getTable()).getName() == null) {
                    table.setName(namingStrategy.getTableName(eClass));
                }
                if (!this.isRoot(annotation) && entity.getPrimaryKeyJoinColumn().isEmpty()) {
                    entity.getPrimaryKeyJoinColumn().add((Object)OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn());
                    ((PrimaryKeyJoinColumn)entity.getPrimaryKeyJoinColumn().get(0)).setName(namingStrategy.getPrimaryKeyJoinColumn(eClass));
                }
            }
            if (this.isRoot(annotation) && ORMMappingOptions.getDefaultOptions().isTestRun()) {
                DiscriminatorColumn dc = OrmFactory.eINSTANCE.createDiscriminatorColumn();
                dc.setLength(255);
                entity.setDiscriminatorColumn(dc);
            }
            if (eClass.isInterface()) {
                entity.setAccess(AccessType.PROPERTY);
            }
            if (GeneratorUtils.isEmptyOrNull((String)entity.getClass_())) {
                entity.setClass(modelGenAnnotation.getQualifiedClassName());
            }
            if (GeneratorUtils.isEmptyOrNull((String)entity.getName())) {
                entity.setName(namingStrategy.getEntityName(eClass));
            }
        } else if (embeddable != null) {
            if (eClass.isInterface()) {
                embeddable.setAccess(AccessType.PROPERTY);
            }
            if (GeneratorUtils.isEmptyOrNull((String)embeddable.getClass_())) {
                embeddable.setClass(modelGenAnnotation.getQualifiedClassName());
            }
        }
    }

    public void postAnnotating(EClassORMAnnotation annotation) {
    }

    public EClass getAnnotationEClass() {
        return OrmannotationsPackage.eINSTANCE.getEClassORMAnnotation();
    }
}

